--
-- fillLevelWarningForageWagon
--
-- Author: DR_Modding
-- Date: 04/16/2022
-- Website: https://dr-modding.jimdofree.com/
-- Discord: DR_Dominik#4998



fillLevelWarningForageWagon = {}
fillLevelWarningForageWagon.MOD_NAME = g_currentModName


BeepSound = createSample("BeepSound")
local file = g_currentModDirectory.."sounds/beep.wav"
loadSample(BeepSound, file, false)
--print ("DEBUG: loadSample")


function fillLevelWarningForageWagon.prerequisitesPresent(specializations)
  return true
end

function fillLevelWarningForageWagon.registerEventListeners(vehicleType)
  SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", fillLevelWarningForageWagon)
  SpecializationUtil.registerEventListener(vehicleType, "onUpdate", fillLevelWarningForageWagon)
  --print ("DEBUG: registerEventListeners")
end


function fillLevelWarningForageWagon:onPreLoad(vehicle)
	

	self.BeepAktive1 = false
	self.BeepAktive2 = false
	self.BeepAktiveAdditive1 = false
	self.BeepAktiveAdditive2 = false
	self.loud = 1
	
	--Index 1: Grass Silage or whatever is in the forage wagon
	self.fillUnitIndex1 = 1
	
	--Index 2: silage additive
	self.fillUnitIndex2 = 2
	
	--print ("DEBUG: preLoad FInished ")

end




function fillLevelWarningForageWagon:onUpdate(dt)

	if self:getIsActive() then
			  --print ("DEBUG: getIsActive")

		self.fillLevel1 = self:getFillUnitFillLevelPercentage(self.fillUnitIndex1)  
		
		self.fillLevel2 = self:getFillUnitFillLevelPercentage(self.fillUnitIndex2)
		--print ("fillLevel2:" .. self.fillLevel2)

		
		if self.fillLevel1 > 0 then
			if not	self.BeepAktive1 then
				if self.fillLevel1 >= 0.8 then
						playSample(BeepSound ,self.loud ,self.loud ,1 ,0 ,0)	
						g_currentMission:showBlinkingWarning(g_i18n:getText("warning_almostFull"), 3000)
					self.BeepAktive1 = true
				end
			else
				if self.fillLevel1 < 0.8 then
					self.BeepAktive1 = false
				end
			end
			if not self.BeepAktive2 then
				if self.fillLevel1 >= 0.99 then
						playSample(BeepSound ,self.loud ,self.loud ,1 ,0 ,0)	
						g_currentMission:showBlinkingWarning(g_i18n:getText("warning_full"), 3000)
				self.BeepAktive2 = true
				end
			else
				if self.fillLevel1 < 0.99 then
					self.BeepAktive2 = false
				end	
			end
		end
		
		
		
		if self:getFillUnitExists(self.fillUnitIndex2) then
			if not self.fillLevel2 ~= nil then 
				if self.fillLevel2 > 0 then
					if not	self.BeepAktiveAdditive1 then
						if self.fillLevel2 <= 0.05 then
								playSample(BeepSound ,self.loud ,self.loud ,1 ,0 ,0)	
								g_currentMission:showBlinkingWarning(g_i18n:getText("warning_additivesAlmostEmpty"), 3000)
							self.BeepAktiveAdditive1 = true
						end
					else
						if self.fillLevel2 > 0.05 then
							self.BeepAktiveAdditive1 = false
						end
					end
					if not self.BeepAktiveAdditive2 then
						if self.fillLevel2 <= 0.001 then
								playSample(BeepSound ,self.loud ,self.loud ,1 ,0 ,0)	
								g_currentMission:showBlinkingWarning(g_i18n:getText("warning_additivesEmpty"), 3000)
						self.BeepAktiveAdditive2 = true
						end
					else
						if self.fillLevel2 > 0.001 then
							self.BeepAktiveAdditive2 = false
						end	
					end
				end
			end
		end
		
		g_inputBinding:setActionEventText(fillLevelWarningForageWagon.actionEventId, Vehicle.togglesound)
	end

end