--[[
LanguageChecker.lua

Author: 	Ifko[nator]
Date:		29.09.2022
Version:	1.7

History:	v1.0 @14.05.2020 - initial implemation in FS 19
			----------------------------------------------------------------------------------------------
			v1.1 @11.07.2020 - added support for all ingame languages
			----------------------------------------------------------------------------------------------
			v1.2 @14.02.2021 - reworkt load function
			----------------------------------------------------------------------------------------------
			v1.3 @15.02.2021 - added hook function for the load function of the BuyingStation.lua
			----------------------------------------------------------------------------------------------
			v1.4 @13.06.2021 - minior adjustments
			----------------------------------------------------------------------------------------------
			v1.5 @18.05.2022 - convert to FS 22
			----------------------------------------------------------------------------------------------
			v1.6 @21.06.2022 - added hook function for the load function of the PlaceableBuyingStation.lua
			----------------------------------------------------------------------------------------------
			v1.7 @29.09.2022 - added hook function for the load function of the PlaceableSilo.lua
]]

LanguageChecker = {};
LanguageChecker.currentModName = g_currentModName;
LanguageChecker.currentModDirectory = g_currentModDirectory;

function LanguageChecker.prerequisitesPresent(specializations)
	return true;
end;

function LanguageChecker.registerEventListeners(vehicleType)
	local functionNames = {
		"onPostLoad"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, LanguageChecker);
	end;
end;

function LanguageChecker:onPostLoad(savegame)
	if RealisticSeederUtil == nil then
		return;
	end;
	
	if RealisticSeederUtil.languageShort ~= "de" then
		LanguageChecker.debugPriority = RealisticSeederUtil.getDebugPriority(self.xmlFile.handle, "vehicle.languageChecker#debugPriority");

		local materialNumber = 0;

		while true do
			local materialKey = "vehicle.languageChecker.material(" .. tostring(materialNumber) .. ")";

			if not self.xmlFile:hasProperty(materialKey) then
				break;
			end;

			local translateNode = I3DUtil.indexToObject(self.components, Utils.getNoNil(getXMLString(self.xmlFile.handle, materialKey .. "." .. RealisticSeederUtil.languageShort .. "#node"), getXMLString(self.xmlFile.handle, materialKey .. ".en#node")), self.i3dMappings);
			local materialNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, materialKey .. "#node"), self.i3dMappings);
			local visibillityMaterialNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, materialKey .. "#visibillityNode"), self.i3dMappings);
			local languageShort = getXMLString(self.xmlFile.handle, materialKey .. "#languageShort");

			if materialNode ~= nil and visibillityMaterialNode ~= nil and languageShort ~= nil then
				if RealisticSeederUtil.languageShort == languageShort then
					setVisibillity(visibillityMaterialNode, true);
					setVisibillity(materialNode, false);
				end;
			end;

			if materialNode ~= nil and translateNode ~= nil then
				RealisticSeederUtil.changeMaterial(self, materialNode, translateNode);
				
				RealisticSeederUtil.printDebug("Changed material for " .. getName(materialNode) .. " successfully.", LanguageChecker.debugPriority, true, "LanguageChecker");
			end;
			
			materialNumber = materialNumber + 1;
		end;
    end;
end;

function LanguageChecker:onLoadBuyingStation(savegame)
	if RealisticSeederUtil ~= nil and RealisticSeederUtil.languageShort ~= "de" then
		local debugPriority = RealisticSeederUtil.getDebugPriority(self.xmlFile.handle, "placeable.buyingStation.languageChecker#debugPriority");
		local materialNumber = 0;

		while true do
			local materialKey = "placeable.buyingStation.languageChecker.material(" .. tostring(materialNumber) .. ")";

			if not self.xmlFile:hasProperty(materialKey) then
				break;
			end;

			local translateNode = I3DUtil.indexToObject(self.components, Utils.getNoNil(getXMLString(self.xmlFile.handle, materialKey .. "." .. RealisticSeederUtil.languageShort .. "#node"), getXMLString(self.xmlFile.handle, materialKey .. ".en#node")), self.i3dMappings);
			local materialNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, materialKey .. "#node"), self.i3dMappings);

			if materialNode ~= nil and translateNode ~= nil then
				RealisticSeederUtil.changeMaterial(self, materialNode, translateNode);

				RealisticSeederUtil.printDebug("Changed material for " .. getName(materialNode) .. " successfully.", debugPriority, true, "LanguageChecker");
			end;

			materialNumber = materialNumber + 1;
		end;
	end;
end;

PlaceableBuyingStation.onLoad = Utils.appendedFunction(PlaceableBuyingStation.onLoad, LanguageChecker.onLoadBuyingStation);

function LanguageChecker:onLoadSilo(savegame)
	if RealisticSeederUtil ~= nil and RealisticSeederUtil.languageShort ~= "de" then
		local debugPriority = RealisticSeederUtil.getDebugPriority(self.xmlFile.handle, "placeable.silo.languageChecker#debugPriority");
		local materialNumber = 0;

		while true do
			local materialKey = "placeable.silo.languageChecker.material(" .. tostring(materialNumber) .. ")";

			if not self.xmlFile:hasProperty(materialKey) then
				break;
			end;

			local translateNode = I3DUtil.indexToObject(self.components, Utils.getNoNil(getXMLString(self.xmlFile.handle, materialKey .. "." .. RealisticSeederUtil.languageShort .. "#node"), getXMLString(self.xmlFile.handle, materialKey .. ".en#node")), self.i3dMappings);
			local materialNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, materialKey .. "#node"), self.i3dMappings);

			if materialNode ~= nil and translateNode ~= nil then
				RealisticSeederUtil.changeMaterial(self, materialNode, translateNode);

				RealisticSeederUtil.printDebug("Changed material for " .. getName(materialNode) .. " successfully.", debugPriority, true, "LanguageChecker");
			end;

			materialNumber = materialNumber + 1;
		end;
	end;
end;

PlaceableSilo.onLoad = Utils.appendedFunction(PlaceableSilo.onLoad, LanguageChecker.onLoadSilo);