--[[
BasegameFixes.lua
	
Author: 	Ifko[nator]
Date:		06.11.2022
Version:	1.3

History:	v1.0 @19.05.2022 - initial implementation in FS 22
			--------------------------------------------------
			v1.1 @19.06.2022 - added "showPalletInfo" fix
			--------------------------------------------------
			v1.2 @17.09.2022 - added "getSpecValueWeight" fix
			--------------------------------------------------
			v1.3 @06.11.2022 - compatibility for Patch 1.8.1.0
            
]]

BasegameFixes = {};
BasegameFixes.currentModName = g_currentModName;

if FillTypeManager.SEND_NUM_BITS < 16 then
	FillTypeManager.SEND_NUM_BITS = 16;
end;

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--## updateRaycastObject fix
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function BasegameFixes:updateRaycastObject(superFunc)
	self.isBale = false;
	self.isVehicle = false;
	self.isPallet = false;
	self.isSplitShape = false;
	self.isAnimal = false;
	self.object = nil;

	if self.currentRaycastTarget == nil then
		return;
	end;

	local object = g_currentMission:getNodeObject(self.currentRaycastTarget);

	if object == nil then
		if getHasClassId(self.currentRaycastTarget, ClassIds.MESH_SPLIT_SHAPE) then
			self.isSplitShape = true;
			self.object = self.currentRaycastTarget;

			return;
		end;

		local husbandryId, animalId = getAnimalFromCollisionNode(self.currentRaycastTarget);

		if husbandryId ~= nil and husbandryId ~= 0 then
			local clusterHusbandry = g_currentMission.husbandrySystem:getClusterHusbandyById(husbandryId);

			if clusterHusbandry ~= nil then
				local cluster = clusterHusbandry:getClusterByAnimalId(animalId);

				if cluster ~= nil then
					self.isAnimal = true;
					self.object = cluster;
				end;
			end;
		end;

		return;
	end;

	self.object = object;

	if object:isa(Vehicle) then
		local function getIsPallet(typeName)
			return typeName == "pallet" or typeName == "treeSaplingPallet" or typeName == "bigBag" or typeName == BasegameFixes.currentModName .. ".realisticSeederPallet";
		end;

		self.isPallet = getIsPallet(object.typeName);
		self.isVehicle = not getIsPallet(object.typeName);
	elseif object:isa(Bale) then
		self.isBale = true;
	end;
end;

PlayerHUDUpdater.updateRaycastObject = Utils.overwrittenFunction(PlayerHUDUpdater.updateRaycastObject, BasegameFixes.updateRaycastObject);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--## showPalletInfo fix
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function BasegameFixes:showPalletInfo(superFunc, pallet)
	local mass = pallet:getTotalMass();
	local farm = g_farmManager:getFarmById(pallet:getOwnerFarmId());
	local currentTitle = g_i18n:getText("infohud_pallet");

	local box = self.objectBox;

	box:clear();

	if SpecializationUtil.hasSpecialization(LanguageChecker, pallet.specializations) then
		currentTitle = pallet:getFullName();
	elseif SpecializationUtil.hasSpecialization(BigBag, pallet.specializations) then
		currentTitle = g_i18n:getText("shopItem_bigBag");
	end;

	box:setTitle(currentTitle);
	
	if farm ~= nil then
		box:addLine(g_i18n:getText("fieldInfo_ownedBy"), self:convertFarmToName(farm));
	end;

	box:addLine(g_i18n:getText("infohud_mass"), g_i18n:formatMass(mass));

	pallet:showInfo(box);

	box:showNextFrame();
end;

PlayerHUDUpdater.showPalletInfo = Utils.overwrittenFunction(PlayerHUDUpdater.showPalletInfo, BasegameFixes.showPalletInfo);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--## convertToDensityMapAngle fix
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function BasegameFixes.convertToDensityMapAngle(angle, superFunc, maxDensityValue)
	local lowProfile = Platform.id == PlatformId.XBOX_ONE or Platform.id == PlatformId.PS4;

	if lowProfile or maxDensityValue == nil then
		maxDensityValue = 3;
	end;

	local value = math.floor(angle / math.pi * (maxDensityValue + 1) + 0.5);

	while maxDensityValue < value do
		value = value - (maxDensityValue + 1);
	end;

	while value < 0 do
		value = value + maxDensityValue + 1;
	end;

	if lowProfile then
		value = value * 2;
	end;

	return value;
end;

FSDensityMapUtil.convertToDensityMapAngle = Utils.overwrittenFunction(FSDensityMapUtil.convertToDensityMapAngle, BasegameFixes.convertToDensityMapAngle);

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--## getSpecValueWeight fix
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function BasegameFixes.getSpecValueWeight(storeItem, superFunc, realItem, configurations, saleItem, returnValues, returnRange)
	if storeItem.specs.weight ~= nil then
		local vehicleMass, vehicleMassMax = nil;

		if realItem ~= nil then
			realItem:updateMass();

			vehicleMass = realItem:getTotalMass(true);
		elseif storeItem.specs.weight.storeDataMax ~= nil then
			vehicleMass = (storeItem.specs.weight.storeDataMin or 0) / 1000;
			vehicleMassMax = (storeItem.specs.weight.storeDataMax or 0) / 1000;

			return g_i18n:formatMass(vehicleMassMax);
		elseif storeItem.specs.weight.componentMass ~= nil then
			vehicleMass = storeItem.specs.weight.componentMass + (storeItem.specs.weight.wheelMassDefaultConfig or 0);
			vehicleMass = vehicleMass + FillUnit.getSpecValueStartFillUnitMassByMassData(storeItem.specs.weight.fillUnitMassData);
		end

		if vehicleMass ~= nil and vehicleMass ~= 0 then
			if returnValues then
				if returnRange then
					return vehicleMass, vehicleMassMax;
				else
					return vehicleMass;
				end
			elseif vehicleMassMax ~= nil and vehicleMassMax ~= 0 then
				return g_i18n:formatMass(vehicleMass, vehicleMassMax);
			else
				return g_i18n:formatMass(vehicleMass);
			end;
		end;
	end;

	return nil;
end;

Vehicle.getSpecValueWeight = Utils.overwrittenFunction(Vehicle.getSpecValueWeight, BasegameFixes.getSpecValueWeight);