-- by modelleicher ( Farming Agency )
-- adds animal grazing feature globally to all animal husbandries
-- compatible with MaizePlus 
-- Version 1.0.0.0 Initial Release 

realismAddon_animalGrazing = {}

realismAddon_animalGrazing.modDirectory = realismAddon_animalGrazing_register.modDirectory
realismAddon_animalGrazing.debug = false -- if you experience any issues set this to true and send me the log with description of your issue 

function realismAddon_animalGrazing.prerequisitesPresent(specializations)
    return true
end

function realismAddon_animalGrazing.registerFunctions(placeableType)
	SpecializationUtil.registerFunction(placeableType, "executeGrazing", realismAddon_animalGrazing.executeGrazing)
end

function realismAddon_animalGrazing.registerEventListeners(placeableType)
	SpecializationUtil.registerEventListener(placeableType, "onLoad", realismAddon_animalGrazing)
	SpecializationUtil.registerEventListener(placeableType, "onHourChanged", realismAddon_animalGrazing)	
	SpecializationUtil.registerEventListener(placeableType, "onDayChanged", realismAddon_animalGrazing)	
end

-- remove overwriting foliage areas on placeables each reload 
function realismAddon_animalGrazing.onPostFinalizePlacement(self, superFunc)
	-- if savegame table is nil this is freshly placed, call default function 
	if self.savegame == nil then
		return superFunc(self)
	end
	-- otherwise do nothing 
end
PlaceableFoliageAreas.onPostFinalizePlacement = Utils.overwrittenFunction(PlaceableFoliageAreas.onPostFinalizePlacement, realismAddon_animalGrazing.onPostFinalizePlacement)

-- load XML File settings
function realismAddon_animalGrazing.initSpecialization()

	local settings = {}
	settings.foliageAreaTypes = {}
	settings.fruitTypesEaten = {}	
	
	if fileExists(realismAddon_animalGrazing.modDirectory.."animalGrazing.xml") then
		local xml = loadXMLFile("animalGrazing", realismAddon_animalGrazing.modDirectory.."animalGrazing.xml")
		
		local i = 0
		while true do
			local area = {}
			area.type = getXMLString(xml, "animalGrazing.foliageAreaTypes.area("..i..")#type")
			area.foliage = getXMLString(xml, "animalGrazing.foliageAreaTypes.area("..i..")#foliage")
			if area.type ~= "" and area.type ~= nil then
				table.insert(settings.foliageAreaTypes, area)
			else
				break
			end
			i = i+1
		end
		
		i = 0
		while true do
			local fruitType = {}
			fruitType.name = getXMLString(xml, "animalGrazing.fruitTypesEaten.fruitType("..i..")#name")
			fruitType.minEatState = getXMLString(xml, "animalGrazing.fruitTypesEaten.fruitType("..i..")#minEatState")
			fruitType.maxEatState = getXMLString(xml, "animalGrazing.fruitTypesEaten.fruitType("..i..")#maxEatState")
			fruitType.outputFillType = getXMLString(xml, "animalGrazing.fruitTypesEaten.fruitType("..i..")#outputFillType")
			
			if fruitType.name ~= "" and fruitType.name ~= nil then
				fruitType.outputFillType = string.upper(fruitType.outputFillType)
				table.insert(settings.fruitTypesEaten, fruitType)
			else
				break
			end
			i = i+1
		end		
	end
	
	-- we need to connect the output fillTypes to their fruitTypes 
	settings.outputFillTypeToFruitType = {}
	for _, fruitType in pairs(settings.fruitTypesEaten) do
		if settings.outputFillTypeToFruitType[fruitType.outputFillType] == nil then
			settings.outputFillTypeToFruitType[fruitType.outputFillType] = {}
		end
		table.insert(settings.outputFillTypeToFruitType[fruitType.outputFillType], fruitType )
	end
	
	if realismAddon_animalGrazing.debug then
		print("settings.outputFillTypeToFruitType: ")
		DebugUtil.printTableRecursively(settings.outputFillTypeToFruitType, "-", 0, 2)
	end
	
	realismAddon_animalGrazing.settings = settings	
end


-- executeGrazing, this function sets the modifiers and checks for eatable growth states at the given fruitType 
-- if food is found it is added to the foodBuffer via the outputFillType
function realismAddon_animalGrazing:executeGrazing(fruitType, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	
	local settings = realismAddon_animalGrazing.settings
	
	-- create fruit DensityMapModifier 
	local desc = g_fruitTypeManager:getFruitTypeByName(fruitType.name)	
	
	local fruitModifier = DensityMapModifier.new(desc.terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels, g_currentMission.terrainRootNode)		
	
	-- create fruit density map filter 
	local fruitFilter = DensityMapFilter.new(desc.terrainDataPlaneId, desc.startStateChannel, desc.numStateChannels, terrainRootNode)	
	
	-- set the area Parallelogram
	fruitModifier:setParallelogramWorldCoords(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, DensityCoordType.POINT_POINT_POINT)
		
	local minState = math.max(fruitType.minEatState, 0)
	local maxState = math.min(fruitType.maxEatState, desc.maxHarvestingGrowthState)
	
	-- check for each growth state in reverse 
	for i = maxState, minState, -1 do	
		
		if realismAddon_animalGrazing.debug then
			print("State: "..tostring(i))
		end
		
		-- set the filter to specific growth stage 
		fruitFilter:setValueCompareParams(DensityValueCompareType.EQUAL, i)	
		
		-- if we remove the last state and it is below min state, make it to cutState 
		local setState = i - 1
		if setState < minState and desc.cutState ~= nil then
			setState = desc.cutState
		end
		
		-- execute modifier to state below currently found 
		local density, numPixels, totalNumPixels = fruitModifier:executeSet(setState, fruitFilter)
		
		if realismAddon_animalGrazing.debug then
			print("density, numPixels, totalNumPixels: "..tostring(density).."-"..tostring(numPixels).."-"..tostring(totalNumPixels).." (fruitType.name)")		
		end
		
		-- convert pixels to liter
		local adjustmentFactor = 1
		if numPixels > 0 then
			local pixelToSqm = g_currentMission:getFruitPixelsToSqm()
			local sqm = numPixels * pixelToSqm		
			local liters = sqm * desc.literPerSqm * adjustmentFactor
			
			-- add liters to food buffer 
			self.animalGrazing.outputFillTypes[fruitType.outputFillType].foodBuffer = self.animalGrazing.outputFillTypes[fruitType.outputFillType].foodBuffer + liters
			
			-- set grazing done for the day to true 
			self.animalGrazing.outputFillTypes[fruitType.outputFillType].grazingDoneToday = true
			
			-- since we found fruit in this stage, break out of the loop, keep further stages for next time 
			break
			
		end	
		if realismAddon_animalGrazing.debug then
			print("new food buffer: "..tostring(self.animalGrazing.outputFillTypes[fruitType.outputFillType].foodBuffer))	
		end
	end		

end

function realismAddon_animalGrazing:onLoad(savegame)
	
	-- check if it has foliage areas or decoFoliage areas that might count 
	local specAreas = self.spec_foliageAreas
	
	self.animalGrazing = {}
	self.animalGrazing.areas = {}
	self.animalGrazing.outputFillTypes = {}
	
	-- create a food buffer for each output fillType 
	for _, fruitType in pairs(realismAddon_animalGrazing.settings.fruitTypesEaten) do
		if self.animalGrazing.outputFillTypes[fruitType.outputFillType] == nil then
			self.animalGrazing.outputFillTypes[fruitType.outputFillType] = {foodBuffer = 0, grazingDoneToday = false}
		end
	end
	
	local settings = realismAddon_animalGrazing.settings
	
	if specAreas ~= nil then
		-- cycle through all foliage areas within the placeable
		for _, area in pairs(specAreas.areas) do
			for _, areaType in pairs(settings.foliageAreaTypes) do

				if area.decoFoliage ~= nil and areaType.type == "decoFoliage" and string.upper(area.decoFoliage) == string.upper(areaType.foliage) then
					-- found match, insert area to grazing areas 
					table.insert(self.animalGrazing.areas, area)
					
					if realismAddon_animalGrazing.debug then
						print("found matching decoFoliage: "..tostring(area.decoFoliage))
					end
				end
				
				if area.fruitType ~= nil and areaType.type == "fruitType" and area.fruitType.name == string.upper(areaType.foliage) then
					-- found match, insert area to grazing areas 
					table.insert(self.animalGrazing.areas, area)
					
					if realismAddon_animalGrazing.debug then
						print("found matching fruitType: "..tostring(area.fruitType.name))
					end
				end				
			end	
		end
	
	end		
	
end

function realismAddon_animalGrazing:saveToXMLFile(xmlFile, key, usedModNames)
	if self.animalGrazing ~= nil and self.animalGrazing.areas ~= nil then		
		for fillTypeName, _ in pairs(self.animalGrazing.outputFillTypes) do
			setXMLFloat(xmlFile.handle, key..".foodBuffer#"..fillTypeName, self.animalGrazing.outputFillTypes[fillTypeName].foodBuffer)		
			setXMLBool(xmlFile.handle, key..".grazingDoneToday#"..fillTypeName, self.animalGrazing.outputFillTypes[fillTypeName].grazingDoneToday)		
		end
	end
end

function realismAddon_animalGrazing:loadFromXMLFile(xmlFile, key)
	if self.animalGrazing ~= nil and self.animalGrazing.areas ~= nil then		
		for fillTypeName, _ in pairs(self.animalGrazing.outputFillTypes) do
			self.animalGrazing.outputFillTypes[fillTypeName].foodBuffer = Utils.getNoNil(getXMLFloat(xmlFile.handle, key..".foodBuffer#"..fillTypeName), 0)
			self.animalGrazing.outputFillTypes[fillTypeName].grazingDoneToday = Utils.getNoNil(getXMLBool(xmlFile.handle, key..".grazingDoneToday#"..fillTypeName), false)	
		end
	end
end

-- reset grazing at 24:00
function realismAddon_animalGrazing:onDayChanged()
	if self.animalGrazing ~= nil and self.animalGrazing.areas ~= nil and self.spec_husbandryFood ~= nil then
		for fillTypeName, outputFillType in pairs(self.animalGrazing.outputFillTypes) do
			if realismAddon_animalGrazing.debug then
				print("reset: "..tostring(fillTypeName))
			end
			outputFillType.grazingDoneToday = false
		end
	end
end

function realismAddon_animalGrazing:onHourChanged(currentHour)
	
	if self.animalGrazing ~= nil and self.animalGrazing.areas ~= nil and self.spec_husbandryFood ~= nil then
	
		-- we want the grazing to be slow, if the pasture has 100.000l capacity but only 2 animals we won't "eat" all the grass within the first day to fill the through
		
		-- I'm still not sure what the best/most realistic way is to do this. One way would be to actually calculate the usage of the husbandry and only feed as much. 
		-- but this would mean without additional feeding it would be always almost empty unless the amount of animals is high enough to be larger than the through capacity.
		-- Another way would be to limit the amount per day, either one layer of grass per day or a liter amount. But since number of animals, size of pasture and food usage depending on mods/maps used is extremly different,
		-- this might lead to animals going hungry.
		-- Also, if the output filltype is a mixture and not a single slider, calculation is almost impossible.. So.. There's always guesswork.
		-- The current plan is as follows:
		-- always fill through up to 25% (through, not slider) if it is less.
		-- after that, fill hourly rate of total food usage. If animals are only grass-fed this is exactly the amount they eat. But if there are other sliders in use this is more than they eat, so the through would fill up.
		-- thus, only add hourly rate up to 85% through capacity. So there's always some room left for additional feeding.
		
		-- also limit the grazing to once every 24 hours maybe?
				
		-- liters per hour are liters per hour at 1 day seasons, timeAdjusted is with seasons-days in mind 
		local litersPerHour = self.spec_husbandryFood.litersPerHour 
		local litersPerHourAdjusted = litersPerHour * g_currentMission.environment.timeAdjustment	
		
		local capacity = self:getFoodCapacity()
		
		-- cycle through food buffers, only if litersPerHour is not 0 -> only if there are animals in the pen 
		if litersPerHour > 0 then
			for fillTypeName , outputFillType in pairs(self.animalGrazing.outputFillTypes) do
				
				if realismAddon_animalGrazing.debug then
					print("Cycle FillType: "..tostring(fillTypeName))
				end
				
				-- get fillType
				local fillType = g_fillTypeManager:getFillTypeIndexByName(fillTypeName)
								
				-- capacity free for fillType
				local freeCapacity = self:getFreeFoodCapacity(fillType)
				
				-- filled %
				local percentFilled = 1 - (freeCapacity / capacity)
				
				-- if the foodBuffer is 0 and % filled is below 85%, we need grazing another layer for that fillType (or try at least), but only if we didn't graze this day 
				-- also if through is below 1% ignore grazing once a day 
				if (outputFillType.foodBuffer == 0 and percentFilled < 0.85 and not outputFillType.grazingDoneToday) or (outputFillType.foodBuffer == 0 and percentFilled < 0.01 and outputFillType.grazingDoneToday) then
					
					---------------- GRAZING 
					local list = realismAddon_animalGrazing.settings.outputFillTypeToFruitType[fillTypeName]
					
					for _, fruitType in pairs(list) do
						for _, area in pairs(self.animalGrazing.areas) do
						
							-- get the coordinates
							local startWorldX, _, startWorldZ = getWorldTranslation(area.start)
							local widthWorldX, _, widthWorldZ = getWorldTranslation(area.width)
							local heightWorldX, _, heightWorldZ = getWorldTranslation(area.height)	
								
							-- execute the grazing
							self:executeGrazing(fruitType, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
						end			
					end 
				end
				
				-- if it isn't 0, we want to add food to the through but only at a rate of the actual liters per hour 
				if outputFillType.foodBuffer > 0 then
					
					local foodAdd = 0
					
					-- if below 25% full, fill amount of 25% capacity - the currently filled percentage 
					if percentFilled < 0.25 then
						foodAdd = math.min(outputFillType.foodBuffer, math.max((capacity * 0.25) - (capacity * percentFilled), 0))
						
						if realismAddon_animalGrazing.debug then
							print("<25%")
						end
					elseif percentFilled >= 0.25 and percentFilled < 0.85 then
						foodAdd = math.min(litersPerHour, outputFillType.foodBuffer)
						if realismAddon_animalGrazing.debug then	
							print("<85%")
						end
					end

					local foodAdded = self:addFood(self:getOwnerFarmId(), foodAdd, fillType, nil)
					
					if realismAddon_animalGrazing.debug then
						print("food added: "..tostring(foodAdded).." fillType: "..tostring(fillTypeName))
					end
					
					outputFillType.foodBuffer = math.max(outputFillType.foodBuffer - foodAdded, 0)
					
					if realismAddon_animalGrazing.debug then
						print("foodBuffer: "..tostring(outputFillType.foodBuffer))
					end
				end			
			end
		end
	end
end


