----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

realDirtParticlesRegister = {};
realDirtParticlesRegister.modDirectory = g_currentModDirectory;

function realDirtParticlesRegister:loadMap(name)
    g_currentMission.wheelDirt = {};
    g_currentMission.wheelDirt.referencePS = {};
    local worldSpace = false;
    local psFile = Utils.getFilename("particleSystems/soilDry.i3d", realDirtParticlesRegister.modDirectory)
    local psRoot = loadI3DFile(psFile, false, false, false);
    local psNode = I3DUtil.indexToObject(psRoot, "0");
    local ps = {};
    ParticleUtil.loadParticleSystemFromNode(psNode, ps, false, worldSpace, false);
    g_currentMission.wheelDirt.referencePS["soilDry"] = ps;
    link(getRootNode(), g_currentMission.wheelDirt.referencePS["soilDry"].shape);
    local psFile = Utils.getFilename("particleSystems/soilWet.i3d", realDirtParticlesRegister.modDirectory)
    local psRoot = loadI3DFile(psFile, false, false, false)
    local psNode = I3DUtil.indexToObject(psRoot, "0");
    local ps = {};
    ParticleUtil.loadParticleSystemFromNode(psNode, ps, false, worldSpace, false);
    g_currentMission.wheelDirt.referencePS["soilWet"] = ps;
    link(getRootNode(), g_currentMission.wheelDirt.referencePS["soilWet"].shape);
    delete(psRoot);
    local shapeRoot = loadSharedI3DFile(realDirtParticlesRegister.modDirectory.."particleSystems/mudEmitShape.i3d", false, false);
    g_currentMission.wheelDirt.referenceShape = getChildAt(shapeRoot, 0);
    link(getRootNode(), g_currentMission.wheelDirt.referenceShape);
    delete(shapeRoot);
end;

function realDirtParticlesRegister:deleteMap()
    if g_currentMission.wheelDirt ~= nil then
        if g_currentMission.wheelDirt.referencePS ~= nil then
            ParticleUtil.deleteParticleSystems(g_currentMission.wheelDirt.referencePS);
        end;
        if g_currentMission.wheelDirt.referenceShape ~= nil then
            delete(g_currentMission.wheelDirt.referenceShape);
        end;
    end;
end;

source(Utils.getFilename("realDirtParticles.lua", g_currentModDirectory));
function installSpec()
	if g_specializationManager:getSpecializationByName("realDirtParticles") == nil then
		if realDirtParticles == nil then 
			print("ERROR: unable to find source file 'realDirtParticles.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;	
					local isAnimated = false;
					local hasWheels = false;
					for name, spec in pairs(typeDef.specializationsByName) do 
						if name == "washable" then 
							isWashable = true;
						elseif name == "wheels" then 
							hasWheels = true;
						elseif name == "animatedVehicle" then 
							isAnimated = true;
						end;
					end;
					if isWashable and isAnimated and hasWheels then
						 if typeDef.specializationsByName["realDirtParticles"] == nil then
							table.insert(typeDef.specializations, realDirtParticles);
							table.insert(typeDef.specializationNames, "realDirtParticles");
							typeDef.specializationsByName["realDirtParticles"] = realDirtParticles;
						end;
					end;
				end;
			end;
		end;
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);
addModEventListener(realDirtParticlesRegister)