----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

realDirtParticles = {};

local rC,gC,bC = (0.2/5),(0.14/5),(0.08/5);
realDirtParticles.defaultColor = {r=rC, g=gC, b=bC};
realDirtParticles.excludedToolTypes = { "PLANTERS", "SEEDERS", "WEEDERS", "TEDDERS", "WINDROWERS", "PLOWS", "SUBSOILERS", "CULTIVATORS", "DISCHARROWS", "POWERHARROWS", "SPADERS", "ROLLERS" };

function realDirtParticles.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations)
		and SpecializationUtil.hasSpecialization(Wheels, specializations)
		and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function realDirtParticles.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoadFinished", realDirtParticles);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", realDirtParticles);
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", realDirtParticles);
end;

function realDirtParticles.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "loadParticleSystemsForWheel", realDirtParticles.loadParticleSystemsForWheel);
	SpecializationUtil.registerFunction(vehicleType, "updateWheelDirtPS", realDirtParticles.updateWheelDirtPS);
	SpecializationUtil.registerFunction(vehicleType, "getDirtPSState", realDirtParticles.getDirtPSState);
	SpecializationUtil.registerFunction(vehicleType, "setPSColorRDC", realDirtParticles.setPSColorRDC);
	SpecializationUtil.registerFunction(vehicleType, "setParticleEmittingState", realDirtParticles.setParticleEmittingState);
end;

function realDirtParticles:onLoadFinished(savegame)
    self.enableRealDirtParticles = true;

	local storeCat = g_storeManager:getItemByXMLFilename(self.configFileName)
	if storeCat ~= nil and storeCat.categoryName ~= nil then
		storeCat = storeCat.categoryName;
		for _, type in pairs(realDirtParticles.excludedToolTypes) do
			if type == storeCat then
                self.enableRealDirtParticles = false;
			end;
		end;
	end;

    self.enableRealDirtParticles = Utils.getNoNil(getXMLBool(self.xmlFile.handle, "vehicle.realDirtParticles#enable"), self.enableRealDirtParticles);
	
	local dirtColor, _ = g_currentMission.environment:getDirtColors();
    if self.enableRealDirtParticles and g_currentMission.wheelDirt ~= nil and g_currentMission.wheelDirt.referenceShape ~= nil and g_currentMission.wheelDirt.referencePS["soilDry"] ~= nil and g_currentMission.wheelDirt.referencePS["soilWet"] ~= nil then
        if self.spec_wheels ~= nil and #self.spec_wheels.wheels > 0 then
            local numWheels = #self.spec_wheels.wheels;
            for iWheel=1,numWheels do
                local wheel = self.spec_wheels.wheels[iWheel];
                if wheel.hasParticles then
                    local refNode = wheel.node;
                    self:loadParticleSystemsForWheel(refNode, wheel, dirtColor)
                    if wheel.additionalWheels ~= nil then
                        for _,additionalWheel in pairs(wheel.additionalWheels) do
                            self:loadParticleSystemsForWheel(refNode, additionalWheel, dirtColor);
                        end;
                    end;
                end;
            end;
        end;
    end;
    self.dirtParticleSystemDirtyFlag = self:getNextDirtyFlag();
end;

function realDirtParticles:loadParticleSystemsForWheel(refNode, wheel, dirtColor)
    wheel.dirtPS = {};
    local psEmitterShape = clone(g_currentMission.wheelDirt.referenceShape, false, false, false);
    link(refNode, psEmitterShape);
    local x,y,z;
    if wheel.wheelTire == nil then
        x,y,z = localToLocal(wheel.driveNode, refNode, 0, 0, 0);
    else
        x,y,z = localToLocal(wheel.wheelTire, refNode, 0, 0, 0);
    end;
    setTranslation(psEmitterShape, x+wheel.xOffset,y,z);
    setRotation(psEmitterShape, 0, 0, 0);
    setScale(psEmitterShape, 2*wheel.width, 2*wheel.radius, 2*wheel.radius);
    for _,name in pairs( {"soilDry", "soilWet"} ) do
        if g_currentMission.wheelDirt.referencePS[name] ~= nil then
            wheel.dirtPS[name] = {};
            local psClone = clone(g_currentMission.wheelDirt.referencePS[name].shape, true, false, true);
            ParticleUtil.loadParticleSystemFromNode(psClone, wheel.dirtPS[name], false, g_currentMission.wheelDirt.referencePS[name].worldSpace, g_currentMission.wheelDirt.referencePS[name].forceFullLifespan);
            ParticleUtil.setEmitterShape(wheel.dirtPS[name], psEmitterShape);
            wheel.dirtPS[name].isActive = false;
            wheel.dirtPS[name].particleSpeed = ParticleUtil.getParticleSystemSpeed(wheel.dirtPS[name]);
            wheel.dirtPS[name].particleRandomSpeed = ParticleUtil.getParticleSystemSpeedRandom(wheel.dirtPS[name]);
			local particleColor = {r=dirtColor[1], g=dirtColor[2], b=dirtColor[3]};
			if particleColor.r == 0.2 then particleColor = realDirtParticles.defaultColor; end;
			wheel.dirtPS[name].rdcColor = {r=particleColor.r, g=particleColor.g, b=particleColor.b};
			setShaderParameter(wheel.dirtPS[name].shape, "psColor", particleColor.r, particleColor.g, particleColor.b, 1, false);
        end;
    end;
end;

function realDirtParticles:onDelete()
    if self.enableRealDirtParticles then
        for _,wheel in pairs(self.spec_wheels.wheels) do
            ParticleUtil.deleteParticleSystems(wheel.dirtPS);
            if wheel.additionalWheels ~= nil then
                for _,additionalWheel in pairs(wheel.additionalWheels) do
                    ParticleUtil.deleteParticleSystems(additionalWheel.dirtPS);
                end;
            end;
        end;
    end;
end;

function realDirtParticles:onUpdateTick(dt)
    if self.enableRealDirtParticles then
		local vehicleActive = self:getIsActive();

		if self.isServer then
			if vehicleActive then
				self.onDeactivateCalled = false;
				local groundWet = g_currentMission.environment.weather:getIsRaining();
				local rainFallScale = g_currentMission.environment.weather:getRainFallScale(true);
				groundWet = groundWet and rainFallScale > 0;
				for i,wheel in pairs(self.spec_wheels.wheels) do
					if wheel.dirtPS ~= nil then
						for name,ps in pairs(wheel.dirtPS) do
							local updateState = ps.isActive;
							ps.isActive = self:getDirtPSState(nil, wheel, ps, groundWet);
							ParticleUtil.setEmittingState(ps, ps.isActive);
							if updateState ~= ps.isActive then
								self:setParticleEmittingState(i,-1, name, ps.isActive);
							end;
							if wheel.additionalWheels ~= nil then
								for a,additionalWheel in pairs(wheel.additionalWheels) do
									if additionalWheel.dirtPS ~= nil then
										for name,ps in pairs(additionalWheel.dirtPS) do
											local updateState = ps.isActive;
											ps.isActive = self:getDirtPSState(wheel, additionalWheel, ps, groundWet);
											ParticleUtil.setEmittingState(ps, ps.isActive);
											if updateState ~= ps.isActive then
												self:setParticleEmittingState(i,a, name, ps.isActive);
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			elseif not self.onDeactivateCalled then
				self.onDeactivateCalled = true;
				realDirtParticles.onDeactivate(self);
			end;
		end;

		if self.isClient and vehicleActive then
            for i,wheel in pairs(self.spec_wheels.wheels) do
                if wheel.dirtPS ~= nil then
                    if wheel.netInfo.xDriveLast_rDP == nil then
                        wheel.netInfo.xDriveLast_rDP = wheel.netInfo.xDrive;
                    end;
                    local xDriveDiff = wheel.netInfo.xDrive - wheel.netInfo.xDriveLast_rDP;
                    if xDriveDiff > math.pi then
                        wheel.netInfo.xDriveLast_rDP = wheel.netInfo.xDriveLast_rDP + 2*math.pi;
                    elseif xDriveDiff < -math.pi then
                        wheel.netInfo.xDriveLast_rDP = wheel.netInfo.xDriveLast_rDP - 2*math.pi;
                    end;
                    xDriveDiff = wheel.netInfo.xDrive - wheel.netInfo.xDriveLast_rDP;
                    wheel.netInfo.xDriveLast_rDP = wheel.netInfo.xDrive;
                    local wheelRotSpeed = math.deg(xDriveDiff) / (0.001 * dt);
                    local maxWheelRotSpeed = 1080;
                    local wheelRotFactor = math.abs(wheelRotSpeed) / maxWheelRotSpeed;
                    wheelRotFactor = wheelRotFactor * wheel.radius;
                    self:updateWheelDirtPS(wheel, wheelRotFactor, wheel.steeringAngle);
                    if wheel.additionalWheels ~= nil then
                        for a,additionalWheel in pairs(wheel.additionalWheels) do
                            self:updateWheelDirtPS(additionalWheel, wheelRotFactor, wheel.steeringAngle, wheel);
                        end;
                    end;
                end;
            end;
		end;

    end;
end;

function realDirtParticles:onDeactivate()
    if self.enableRealDirtParticles and self.isServer then
        for i,wheel in pairs(self.spec_wheels.wheels) do
            if wheel.dirtPS ~= nil then
                for name, ps in pairs(wheel.dirtPS) do
					if ps.isActive then
						ParticleUtil.setEmittingState(ps, false);
						ps.isActive = false;
						self:setParticleEmittingState(i,-1, name, false);
					end;
                end;
                if wheel.additionalWheels ~= nil then
                    for a,additionalWheel in pairs(wheel.additionalWheels) do
                        for name, ps in pairs(additionalWheel.dirtPS) do
							if ps.isActive then
								ParticleUtil.setEmittingState(ps, false);
								ps.isActive = false;
								self:setParticleEmittingState(i,a, name, false);
							end;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;

function realDirtParticles:getDirtPSState(parent, wheel, ps, groundWet)
	local isActive = false;
	local spec = self.spec_wheels;
	local hasGroundContact = wheel.hasGroundContact ~= nil and wheel.hasGroundContact;
	local hasSnowContact = wheel.hasSnowContact ~= nil and wheel.hasSnowContact;
	if parent ~= nil then
		hasGroundContact = parent.hasGroundContact ~= nil and parent.hasGroundContact;
	end;
	if hasGroundContact then
		if wheel.densityType ~= nil then
			isActive = wheel.densityType ~= 0 and wheel.densityType ~= spec.tireTrackGroundGrassValue and wheel.densityType ~= spec.tireTrackGroundGrassCutValue and not hasSnowContact;
		elseif g_currentMission.terrainDetailId ~= nil then
			local x,y,z = getWorldTranslation(ps.emitterShape);
			y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode,x,y,z);
			local densityType = getDensityAtWorldPos(g_currentMission.terrainDetailId,x,y,z);
			if wheel.hasSnowContact == nil and parent ~= nil then
				hasSnowContact =  parent.hasSnowContact ~= nil and parent.hasSnowContact;
			end;
			isActive = densityType ~= 0 and densityType ~= spec.tireTrackGroundGrassValue and densityType ~= spec.tireTrackGroundGrassCutValue and not hasSnowContact;
		end;
		if isActive then
			if ps == wheel.dirtPS["soilDry"] then
				local activate = not groundWet;
				if self.spec_mudSystem ~= nil then
					local mfsu = g_currentMission.mudFieldSinkUpdater
					if mfsu ~= nil and mfsu.fieldSinkAmount ~= nil then
						if mfsu.fieldSinkAmount < 0.99 then activate = true; end;
					end;
				end;
				isActive = activate;
			elseif ps == wheel.dirtPS["soilWet"] then
				isActive = self.spec_mudSystem == nil and groundWet;
			end;
		end;
	end;
	return isActive;
end;

function realDirtParticles:setPSColorRDC(ps, wheel, parentWheel)
	if self.spec_realDirtColor ~= nil then
		local colorSouce = wheel;
		if parentWheel ~= nil then colorSouce = parentWheel; end; --additionalWheels use the main (parent) wheel's color in Real Dirt Color.
		if colorSouce.targetRDColor ~= nil then
			if getHasShaderParameter(ps.shape, "psColor") then
				local particleColor = {r=colorSouce.targetRDColor.r, g=colorSouce.targetRDColor.g, b=colorSouce.targetRDColor.b};
				if particleColor.r == 0.2 then particleColor = realDirtParticles.defaultColor; end;
				if not self:thresholdCompareColor(ps.rdcColor, particleColor, 0.0001) then
					ps.rdcColor.r, ps.rdcColor.g, ps.rdcColor.b= MathUtil.lerp3(ps.rdcColor.r, ps.rdcColor.g, ps.rdcColor.b, particleColor.r, particleColor.g, particleColor.b, 0.1);
					setShaderParameter(ps.shape, "psColor", ps.rdcColor.r, ps.rdcColor.g, ps.rdcColor.b, 1, false);
				end;
			end;
		end;
	end;
end;

function realDirtParticles:updateWheelDirtPS(wheel, wheelRotFactor, steeringAngle, parentWheel)
    if wheel.dirtPS ~= nil then
		local radius = wheel.radiusOriginal;
		if parentWheel ~= nil then radius = parentWheel.radiusOriginal; end;
        local sizeScale = 2 * wheel.width * radius;
		local groundWetness = 0; 
		if g_currentMission.environment.weather:getIsRaining() then groundWetness = 1; end;
        for name,ps in pairs(wheel.dirtPS) do
            if ps.isActive then
				local mudSysDryScale = 1;
				if self.spec_mudSystem ~= nil then
					local mfsu = g_currentMission.mudFieldSinkUpdater
					if mfsu ~= nil and mfsu.fieldSinkAmount ~= nil then
						mudSysDryScale = math.max((1-mfsu.fieldSinkAmount),0);
					end;
				end;
                -- emit count
                local speedEmitScale = wheelRotFactor * sizeScale;
                local speedEmitScaleWet = math.pow(2*wheelRotFactor*sizeScale*groundWetness, 2);
                local emitScale = 0.5 * (speedEmitScale + speedEmitScaleWet);
                ParticleUtil.setEmitCountScale(ps, emitScale*mudSysDryScale);
                -- speeds
                local speedFactor = 0.3 * wheelRotFactor;
                local speed = ps.particleSpeed * speedFactor;
                speed = math.min(speed, 0.001);
                ParticleUtil.setParticleSystemSpeed(ps, speed*mudSysDryScale);
                ParticleUtil.setParticleSystemSpeedRandom(ps, (ps.particleRandomSpeed * speedFactor)*mudSysDryScale);
                local x,y,z;
                if wheel.wheelTire == nil then
                    x,y,z = localToLocal(wheel.driveNode, getParent(ps.emitterShape), wheel.xOffset, 0, 0);
                else
                    x,y,z = localToLocal(wheel.wheelTire, getParent(ps.emitterShape), 0, 0, 0);
                end;
                setTranslation(ps.emitterShape, x,y,z);
                if self.movingDirection < 0 then
                    setRotation(ps.emitterShape, 0,math.pi+steeringAngle,0);
                else
                    setRotation(ps.emitterShape, 0,steeringAngle,0);
                end;
                self:setPSColorRDC(ps, wheel, parentWheel);
            end;
        end;
    end;
end;

 function realDirtParticles:setParticleEmittingState(i,a, psname, state, noEventSend)
	if g_currentMission.missionDynamicInfo.isMultiplayer then
		realDirtParticlesEvent.sendEvent(self, i,a, psname, state, noEventSend);
		local ps;
		if a < 0 then ps = self.spec_wheels.wheels[i].dirtPS[psname];
		else ps = self.spec_wheels.wheels[i].additionalWheels[a].dirtPS[psname]; end;
		ParticleUtil.setEmittingState(ps, state);
		ps.isActive = state;
	end;
end;

realDirtParticlesEvent = {};
realDirtParticlesEvent_mt = Class(realDirtParticlesEvent, Event);
InitEventClass(realDirtParticlesEvent,"realDirtParticlesEvent");

function realDirtParticlesEvent:emptyNew()
    local self = Event.new(realDirtParticlesEvent_mt);
    self.className = "realDirtParticlesEvent";
    return self;
end;
function realDirtParticlesEvent:new(vehicle,wheel,additionalWheel,psname,state)
	local self = realDirtParticlesEvent.emptyNew()
    self.vehicle = vehicle;
    self.wheel = wheel;
    self.additionalWheel = additionalWheel;
    self.psname = psname;
    self.state = state;
    return self;
end;
function realDirtParticlesEvent:readStream(streamId,connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId);
    self.wheel = streamReadInt8(streamId);
    self.additionalWheel = streamReadInt8(streamId);
    self.psname = streamReadString(streamId);
    self.state = streamReadBool(streamId);
    self:run(connection);
end;
function realDirtParticlesEvent:writeStream(streamId,connection)
    NetworkUtil.writeNodeObject(streamId,self.vehicle);
    streamWriteInt8(streamId,self.wheel);
    streamWriteInt8(streamId,self.additionalWheel);
    streamWriteString(streamId,self.psname);
    streamWriteBool(streamId,self.state);
end;
function realDirtParticlesEvent:run(connection)
    self.vehicle:setParticleEmittingState(self.wheel, self.additionalWheel, self.psname, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(realDirtParticlesEvent:new(self.vehicle,self.wheel,self.additionalWheel,self.psname,self.state),nil,connection,self.vehicle);
    end;
end;
function realDirtParticlesEvent.sendEvent(vehicle,wheel,additionalWheel,psname,state,noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(realDirtParticlesEvent:new(vehicle,wheel,additionalWheel,psname,state),nil,nil,vehicle);
        else
            g_client:getServerConnection():sendEvent(realDirtParticlesEvent:new(vehicle,wheel,additionalWheel,psname,state));
        end;
    end;
end;