--[[
	PipeCam.lua
	
	Autor: 		Ifko[nator]
	Datum: 		21.04.2022
	Version: 	2.3
	
	Changelog:	v1.0 @27.07.2020 - initial implementation in FS 19
				------------------------------------------------------------------------------------------------------------------------
				v1.5 @01.08.2020 - fix for attachable vehicles with pipe
				------------------------------------------------------------------------------------------------------------------------
				v2.0 @18.11.2021 - convert to FS 22
				------------------------------------------------------------------------------------------------------------------------
				v2.1 @13.12.2021 - a little code optimation
				------------------------------------------------------------------------------------------------------------------------
				v2.2 @21.12.2021 - fix for .../FS22_manualDischarge/PipeCam.lua:95: attempt to call global 'getSpecByName' (a nil value)
				------------------------------------------------------------------------------------------------------------------------
				v2.3 @21.04.2022 - fix for patch 1.4 and higher
]]

PipeCam = {};

function PipeCam.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Pipe, specializations);
end;

function PipeCam.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onRegisterActionEvents",
		"onUpdate"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, PipeCam);
	end;
end;

function PipeCam:onLoad(savegame)
	local specPipeCam = ManualDischargeUtil.getSpecByName(self, "pipeCam");
	
	specPipeCam.pipeCamIsActive = false;
	specPipeCam.needResetCamera = false;
	specPipeCam.inputButtonText = g_i18n:getText("input_PIPE_CAM_BUTTON", ManualDischargeUtil.currentModName);
end;

function PipeCam:onUpdate(dt, isActiveForInput, isActiveForInputIngnoreSelection, isSelected)
	local specPipeCam = ManualDischargeUtil.getSpecByName(self, "pipeCam");
	local specDischargeable = ManualDischargeUtil.getSpecByName(self, "dischargeable");
	local specPipe = ManualDischargeUtil.getSpecByName(self, "pipe");
	local specEnterable = ManualDischargeUtil.getSpecByName(self, "enterable");

	if specDischargeable == nil then
		return;
	end;
		
	local currentDischargeNode = specDischargeable.currentDischargeNode;

	if currentDischargeNode ~= nil then
		local pipeIsUnFolded = specPipe.targetState > 1 or specPipe.numStates == 1;

		if specPipe.animation.name ~= nil then
			pipeIsUnFolded = pipeIsUnFolded and not self:getIsAnimationPlaying(specPipe.animation.name);
		end;

		local pipeCamButton = specPipeCam.actionEvents[InputAction.PIPE_CAM_BUTTON];

		if self:getIsActive() and pipeIsUnFolded then
			if pipeCamButton ~= nil then
				g_inputBinding:setActionEventTextVisibility(pipeCamButton.actionEventId, true);
				g_inputBinding:setActionEventActive(pipeCamButton.actionEventId, true);
			end;

			if specPipeCam.pipeCam == nil or specPipeCam.pipeCam == 0 then
				specPipeCam.pipeCam = createCamera("pipeCam", 95, 0.02, 100);

				link(self:getDischargeNodeByIndex(self:getPipeDischargeNodeIndex()).node, specPipeCam.pipeCam);
				
				setRotation(specPipeCam.pipeCam, math.rad(-90), math.rad(-90), 0);
				setTranslation(specPipeCam.pipeCam, 0, 3, 0);			
			end;
			
			if specPipeCam.pipeCamIsActive then	
				setCamera(specPipeCam.pipeCam);
				
				if pipeCamButton ~= nil then
					g_inputBinding:setActionEventTextVisibility(pipeCamButton.actionEventId, false);
				end;

				specPipeCam.needResetCamera = true;
			else
				if specPipeCam.needResetCamera then	
					if specEnterable == nil then
						if self.getRootVehicle ~= nil then
							local controlledTractor = self:getRootVehicle();
				
							if controlledTractor ~= nil then
								specEnterable = ManualDischargeUtil.getSpecByName(controlledTractor, "enterable");
				
								if specEnterable == nil then
									return;
								end;

								controlledTractor:setActiveCameraIndex(specEnterable.camIndex);
							else
								return;
							end;
						else
							return;
						end;
					else
						self:setActiveCameraIndex(specEnterable.camIndex);
					end;
					
					specPipeCam.needResetCamera = false;
				end;
			end;

			specPipeCam.pipeCamIsActive = false;
		else
			if pipeCamButton ~= nil then
				g_inputBinding:setActionEventTextVisibility(pipeCamButton.actionEventId, false);
				g_inputBinding:setActionEventActive(pipeCamButton.actionEventId, false);
			end;

			if specPipeCam.pipeCamIsActive then	
				self:setActiveCameraIndex(specEnterable.camIndex);
				
				specPipeCam.needResetCamera = false;
				specPipeCam.pipeCamIsActive = false;
			end;
		end;
	end;	
end;

function PipeCam:onRegisterActionEvents(isActiveForInput)
	if self.isClient then
        local specPipeCam = ManualDischargeUtil.getSpecByName(self, "pipeCam");
		
		self:clearActionEventsTable(specPipeCam.actionEvents);
			
		if self:getIsActiveForInput(true) then
			local _, pipeCamButtonEventId = self:addActionEvent(specPipeCam.actionEvents, InputAction.PIPE_CAM_BUTTON, self, PipeCam.actionEventPipeCam, false, true, true, true, nil);

			g_inputBinding:setActionEventTextPriority(pipeCamButtonEventId, GS_PRIO_NORMAL);
			g_inputBinding:setActionEventTextVisibility(pipeCamButtonEventId, false);
			g_inputBinding:setActionEventText(pipeCamButtonEventId, specPipeCam.inputButtonText);
			g_inputBinding:setActionEventActive(pipeCamButtonEventId, false);
		end;
	end;
end;

function PipeCam.actionEventPipeCam(self, actionName, inputValue, callbackState, isAnalog)
	local specPipeCam = ManualDischargeUtil.getSpecByName(self, "pipeCam");

	specPipeCam.pipeCamIsActive = true;
end;