--[[
ManualDischargeUtil

Utility for my Manual Discharge

Author:		Ifko[nator]
Datum:		18.11.2021
Version:	v2.0

History:	v1.0 @06.10.2020 - initial implementation in FS 19
			--------------------------------------------------
			v2.0 @18.11.2021 - convert to FS 22
]]

ManualDischargeUtil = {};
ManualDischargeUtil.currentModName = g_currentModName;

function ManualDischargeUtil.getSpecByName(self, specName, currentModName)
    local spec = self["spec_" .. Utils.getNoNil(currentModName, ManualDischargeUtil.currentModName) .. "." .. specName];

	if spec ~= nil then
        return spec;
    end;

    return self["spec_" .. specName];
end;

function ManualDischargeUtil.getIsVehicleEmpty(self)
	local specManualDischarge = ManualDischargeUtil.getSpecByName(self, "manualDischarge");
	local specCombine = ManualDischargeUtil.getSpecByName(self, "combine");
	local specTrailer = ManualDischargeUtil.getSpecByName(self, "trailer");
	local specPipe = ManualDischargeUtil.getSpecByName(self, "pipe");

	local vehicleIsEmpty = false;

	if specCombine ~= nil then
		if self:getFillUnitFillLevel(specCombine.fillUnitIndex) < 0.0001 then
			vehicleIsEmpty = true;
		end;
	end;

	if specTrailer ~= nil and specPipe ~= nil then
		local specDischargeable = self.spec_dischargeable;
		local currentDischargeNode = specDischargeable.currentDischargeNode;

		if self:getFillUnitFillLevel(currentDischargeNode.fillUnitIndex) < 0.0001 then
			vehicleIsEmpty = true;
		end;
	end;

	return vehicleIsEmpty;
end;

function ManualDischargeUtil.getIsVehicleMotorStarted(self)
	local specManualDischarge = ManualDischargeUtil.getSpecByName(self, "manualDischarge");
	local specCombine = ManualDischargeUtil.getSpecByName(self, "combine");

	local vehicleIsMotorStarted = false;

	if specCombine ~= nil and self.getRootVehicle == nil then
		if self.getIsMotorStarted ~= nil then
			vehicleIsMotorStarted = self:getIsMotorStarted();
		end;
	end;

	if self.getRootVehicle ~= nil then
		local controlledTractor = self:getRootVehicle();
	
		if controlledTractor ~= nil and controlledTractor.getIsMotorStarted ~= nil then
			vehicleIsMotorStarted = controlledTractor:getIsMotorStarted();
		end;
	end;

	return vehicleIsMotorStarted;
end;