--[[
Script to add the manual discharge configuration to an vehicle

Author:		Ifko[nator]
Date:		13.12.2021
Version:	2.1

History:	v1.0 @01.04.2020 - initial release in FS 19
            -------------------------------------------------------
            v2.0 @18.11.2021 - convert for FS 22
            -------------------------------------------------------
            v2.1 @13.12.2021 - added compatibility with the GPS Mod 
]]

function registerConfiguration()
    if g_configurationManager.configurations["manualDischarge"] == nil then    
        g_configurationManager:addConfigurationType("manualDischarge", g_i18n:getText("configuration_manualDischarge"), "pipe", nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION);
    end;
    
	StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, addConfiguration);
end;

function addConfiguration(xmlFile, superFunc, key, baseDir, customEnvironment, isMod, storeItem)
	local configurations, defaultConfigurationIds = superFunc(xmlFile, key, baseDir, customEnvironment, isMod, storeItem);
    
    if configurations ~= nil then
        local specs = storeItem.specs;
        local manualDischargeKey = "manualDischarge";
        local vehicleXML = XMLFile.load("vehicle", storeItem.xmlFilename);
        local hasPipeAndFillVolume = vehicleXML:hasProperty("vehicle.pipe") and (vehicleXML:hasProperty("vehicle.fillVolume") and not vehicleXML:hasProperty("vehicle.woodCrusher"));

	    if g_configurationManager.configurations[manualDischargeKey] ~= nil then
            if hasPipeAndFillVolume then
                if configurations[manualDischargeKey] == nil then
                    local entryNoManualDischarge = {
                        price = 0,
                        dailyUpkeep = 0,
                        isDefault = false,
                        isSelectable = true,
                        index = 1,
                        name = g_i18n:getText("ui_no"),
                        enabled = true
	    			};
                
                    local entryManualDischarge = {
                        price = 0,
                        dailyUpkeep = 0,
                        isDefault = true,
                        isSelectable = true,
                        index = 2,
                        name = g_i18n:getText("ui_yes"),
                        enabled = false
                    };
	    			configurations[manualDischargeKey] = {};
                
                    table.insert(configurations[manualDischargeKey], entryNoManualDischarge);
                    table.insert(configurations[manualDischargeKey], entryManualDischarge);
                else
                    for id, configuration in pairs(configurations[manualDischargeKey]) do
                        configuration.enabled = id > 1;
                    end;
                end;
            end;
        end;

        vehicleXML:delete();
    end;

    return configurations, defaultConfigurationIds;
end;

Vehicle.init = Utils.appendedFunction(Vehicle.init, registerConfiguration);