--[[
	ManualCover.lua
	
	Autor: 		Ifko[nator]
	Datum: 		21.04.2022
	Version: 	2.1
	
	Changelog:	v1.0 @05.01.2020 - initial implementation in FS 19
				--------------------------------------------------
				v2.0 @09.12.2021 - convert to FS 22
				--------------------------------------------------
				v2.1 @21.04.2022 - fix for patch 1.4 and higher
]]

ManualCover = {};

function ManualCover.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cover, specializations);
end;

function ManualCover.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdate"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, ManualCover);
	end;
end;

function ManualCover:onLoad(savegame)
	local specCover = self.spec_cover
	
	specCover.actionEventRegistration = {};

	specCover.actionEventRegistration[InputAction.TOGGLE_COVER_MANUAL] = {
		eventId = "",
		callback = ManualCover.actionEventToggleCoverManual,
		triggerUp = false,
		triggerDown = true,
		triggerAlways = false,
		activeType = true,
		callbackState = nil,
		text = "",
		textVisibility = false
	};

	if g_currentMission.coverTrailers == nil then
		g_currentMission.coverTrailers = {};
	end;

	specCover.l10nTexts = {};

	local l10nTexts = {
		"action_nextCover",
		"action_closeCover",
		"action_openCover"
	};

	for _, l10nText in pairs(l10nTexts) do
		specCover.l10nTexts[l10nText] = g_i18n:getText("action_closeCover");
	end;
end;

function ManualCover:onUpdate(dt, isActiveForInput, isActiveForInputIngnoreSelection, isSelected)
	local specCover = self.spec_cover
	
	if g_currentMission.controlledVehicle == nil then
		self:raiseActive();

		local coverTrailer = ManualCover.getNearestVehicle();
	
		if coverTrailer ~= nil and coverTrailer.spec_cover ~= nil and coverTrailer.spec_cover.hasCovers then
			local playerX, playerY, playerZ = getWorldTranslation(g_currentMission.player.rootNode);
			local vehicleX, vehicleY, vehicleZ = getWorldTranslation(coverTrailer.rootNode);
			
			if specCover.actionEvent == nil then
				local actionEvent = specCover.actionEventRegistration;
			
				_, actionEvent[InputAction.TOGGLE_COVER_MANUAL].eventId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_COVER_MANUAL, self, ManualCover.actionEventToggleCoverManual, false, true, false, true, nil, true);
			
				specCover.actionEvent = actionEvent;
			end;

			if specCover.actionEvent ~= nil then
				local eventId = specCover.actionEvent[InputAction.TOGGLE_COVER_MANUAL].eventId;
				
				if eventId ~= nil then
					if MathUtil.vector3Length(playerX - vehicleX, playerY - vehicleY, playerZ - vehicleZ) < 4 then
						g_inputBinding:setActionEventActive(eventId, true);
    					g_inputBinding:setActionEventTextVisibility(eventId, true);
						
						local text = specCover.l10nTexts.action_nextCover;
						
						if coverTrailer.spec_cover.state == #specCover.covers then
    					    text = specCover.l10nTexts.action_closeCover;
    					elseif coverTrailer.spec_cover.state == 0 then
    					    text = specCover.l10nTexts.action_openCover;
						end;
						
						g_inputBinding:setActionEventText(eventId, text);
					else
						g_inputBinding:setActionEventActive(eventId, false);
						g_inputBinding:setActionEventTextVisibility(eventId, false);
					end;
				end;
			end;
		end;
	else
		specCover.actionEvent = nil;
	end;
end;

function ManualCover.getNearestVehicle()
	for _, vehicle in pairs(g_currentMission.vehicles) do
		if vehicle.spec_cover ~= nil and vehicle.rootNode ~= nil then
			local distanceToVehicle = calcDistanceFrom(vehicle.rootNode, getCamera());
			
			if g_currentMission.controlledVehicle ~= nil then
				distanceToVehicle = calcDistanceFrom(vehicle.rootNode, g_currentMission.controlledVehicle.rootNode);
			end;

			if distanceToVehicle < 4.5 then
				local insertVehicle = true;

				for _, rootNode in pairs(g_currentMission.coverTrailers) do
					if vehicle.rootNode == rootNode then
						insertVehicle = false;
					end;
				end;

				if insertVehicle then
					table.insert(g_currentMission.coverTrailers, vehicle.rootNode);
				end;

				return vehicle;
			end;
		end;
	end;

	return nil;
end;

function ManualCover.actionEventToggleCoverManual(self, actionName, inputValue, callbackState, isAnalog)
	local coverTrailer = ManualCover.getNearestVehicle();
	
	if coverTrailer ~= nil then
		local specCover = coverTrailer.spec_cover;
		local newState = specCover.state + 1;

    	if newState > #specCover.covers then
    	    newState = 0;
		end;

    	if coverTrailer:getIsNextCoverStateAllowed(newState) then
			coverTrailer:setCoverState(newState)

    	    specCover.isStateSetAutomatically = false;
		end;
	end;
end;