
correctHubandriesCapacities = {}
correctHubandriesCapacities.modDirectory = g_currentModDirectory;
correctHubandriesCapacities.xmlSchema = XMLSchema.new("animalDataOverride");

function correctHubandriesCapacities.loadAnimalData()

	-- Auslesen der Werte aus der maizePlus_animalDataOverride, wenn noch nicht geschehen
	local schema = correctHubandriesCapacities.xmlSchema
	local basePath = "animalDataOverride"

	schema:register(XMLValueType.STRING, basePath .. ".animalData(?)#type", "Type of Animal this Dataset overrides", nil)   
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?)#subType", "Sub-Type Animal for this Dataset", "COW_SWISS_BROWN")      
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs#overrideType", "The type of override, 'add' will only add/replace for this input-type while 'replace' will replace all the inputs with the new ones.", nil)
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs#overrideType", "The type of override, 'add' will only add/replace for this output-type while 'replace' will replace all the outputs with the new ones.", nil)
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs.input(?)#type", "Input-Type most likely Filltype", "STRAW")
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs.output(?)#type", "Output-Type most likely Filltype", "MILK")
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).inputs.input(?).key(?)#ageMonth", "Age-Month for this particular animation-key element", "0")
	schema:register(XMLValueType.INT, basePath .. ".animalData(?).inputs.input(?).key(?)#value", "Value this particular animation-key element", "0")
	schema:register(XMLValueType.STRING, basePath .. ".animalData(?).outputs.output(?).key(?)#ageMonth", "Age-Month for this particular animation-key element", "0")
	schema:register(XMLValueType.INT, basePath .. ".animalData(?).outputs.output(?).key(?)#value", "Value this particular animation-key element", "0")

	local path = correctHubandriesCapacities.modDirectory .. "maizePlus_animalDataOverride.xml";
	local xmlAnimalDataOverride = XMLFile.load("animalDataOverride",path , correctHubandriesCapacities.xmlSchema)

	-- auslesen der max werte pro tier
	correctHubandriesCapacities.Inputs = {}
	
	xmlAnimalDataOverride:iterate("animalDataOverride.animalData", function (_, key)
		local animalType =  xmlAnimalDataOverride:getValue(key .. "#type");
		-- Logging.info("animalType: %s", animalType);
		
		if correctHubandriesCapacities.Inputs[animalType] == nil then
			correctHubandriesCapacities.Inputs[animalType] = {};
		end
		
		xmlAnimalDataOverride:iterate(key .. ".inputs.input", function (_, keyInputs)
			local inputType = xmlAnimalDataOverride:getValue(keyInputs .. "#type"):upper();
			-- Logging.info("inputType: %s", inputType);
			
			if correctHubandriesCapacities.Inputs[animalType][inputType] == nil then
				correctHubandriesCapacities.Inputs[animalType][inputType] = 0;
			end
			
			xmlAnimalDataOverride:iterate(keyInputs .. ".key", function (_, keyInputsKeys)
				local inputValue = xmlAnimalDataOverride:getValue(keyInputsKeys .. "#value");
				-- Logging.info("inputValue: %s", inputValue);
				if inputValue >= correctHubandriesCapacities.Inputs[animalType][inputType] then
					correctHubandriesCapacities.Inputs[animalType][inputType] = inputValue;
				end
			end)
		end)
		
		xmlAnimalDataOverride:iterate(key .. ".outputs.output", function (_, keyOutputs)
			local outputType = xmlAnimalDataOverride:getValue(keyOutputs .. "#type"):upper();
			-- Logging.info("outputType: %s", outputType);
			
			if correctHubandriesCapacities.Inputs[animalType][outputType] == nil then
				correctHubandriesCapacities.Inputs[animalType][outputType] = 0;
			end
			
			xmlAnimalDataOverride:iterate(keyOutputs .. ".key", function (_, keyInputsKeys)
				local outputValue = xmlAnimalDataOverride:getValue(keyInputsKeys .. "#value");
				-- Logging.info("outputValue: %s", outputValue);
				if outputValue >= correctHubandriesCapacities.Inputs[animalType][outputType] then
					correctHubandriesCapacities.Inputs[animalType][outputType] = outputValue;
				end
			end)
		end)
	end)
	if g_isDevelopmentVersion then
		print("Max values read from maizePlus_animalDataOverride.xml");
		DebugUtil.printTableRecursively(correctHubandriesCapacities.Inputs);
	end
end

function correctHubandriesCapacities:onLoad(superFunc, savegame)
	local xmlFile = self.xmlFile;
	
	if correctHubandriesCapacities.Inputs == nil then
		correctHubandriesCapacities.loadAnimalData();
	end
	
	local animalTypeName = xmlFile:getValue("placeable.husbandry.animals#type")
	local animalAmount = xmlFile:getValue("placeable.husbandry.animals#maxNumAnimals", 16)
	local capacity = xmlFile:getValue("placeable.husbandry.food#capacity", 5000)
	
	-- correct Food values
	if correctHubandriesCapacities.Inputs[animalTypeName] ~= nil then
		if correctHubandriesCapacities.Inputs[animalTypeName]["FOOD"] ~= nil then
			local newCapacity = math.max(capacity, animalAmount * correctHubandriesCapacities.Inputs[animalTypeName]["FOOD"]);
			if newCapacity > capacity then 
				xmlFile:setValue("placeable.husbandry.food#capacity", math.max(capacity, newCapacity));
				Logging.xmlDevInfo(xmlFile, "Extend FOOD capacity for M+ from %s to %s", capacity, newCapacity);
			end
		end
	end
		
	-- correct other storage values
	xmlFile:iterate("placeable.husbandry.storage.capacity", function (_, capacityKey)
		local fillTypeName = xmlFile:getValue(capacityKey .. "#fillType")
		fillTypeName = fillTypeName:upper()
		local capacity = xmlFile:getValue(capacityKey .. "#capacity", 100000)
		
		if capacity ~= 0 and correctHubandriesCapacities.Inputs[animalTypeName] ~= nil then
			if correctHubandriesCapacities.Inputs[animalTypeName][fillTypeName] ~= nil then
				local newCapacity = math.max(capacity, animalAmount * correctHubandriesCapacities.Inputs[animalTypeName][fillTypeName]);
				if newCapacity > capacity then 
					xmlFile:setValue(capacityKey .. "#capacity", math.max(capacity, newCapacity))
					Logging.xmlDevInfo(xmlFile, "Extend %s capacity for M+ from %s to %s", fillTypeName, capacity, newCapacity);
				end
			end
		end
	end)
	
	return superFunc(self, savegame) 
end

PlaceableHusbandry.onLoad = Utils.overwrittenFunction(PlaceableHusbandry.onLoad, correctHubandriesCapacities.onLoad)