-- Register Specialization

-- add frontloaderAxleLockRemover spec
g_specializationManager:addSpecialization("frontloaderAxleLockRemover", "frontloaderAxleLockRemover", g_currentModDirectory.."frontloaderAxleLockRemover.lua")

registerFrontloaderAxleLockRemover = {}
registerFrontloaderAxleLockRemover.addingDone = false

function registerFrontloaderAxleLockRemover:register(name)

	if not registerFrontloaderAxleLockRemover.addingDone then -- use this to only run this once despite the typeManager being called twice (placeable and vehicles)
    
		for _, vehicle in pairs(g_vehicleTypeManager:getTypes()) do
			
			local frontloaderAttacher = false
			local frontloaderAxleLockRemover = false
			
			for _, spec in pairs(vehicle.specializationNames) do
			
				if spec == "frontloaderAttacher" then -- check for frontloaderAttacher, only insert into frontloaderAttacher
					frontloaderAttacher = true
				end
				if spec == "frontloaderAxleLockRemover" then -- don't insert if already inserted
					frontloaderAxleLockRemover = true
				end
				
			end    
			if frontloaderAttacher and not frontloaderAxleLockRemover then
				g_vehicleTypeManager:addSpecialization(vehicle.name, "FS22_frontloaderAxleLockRemover.frontloaderAxleLockRemover")
			end
		end
		
		print("FS22_frontloaderAxleLockRemover: Specialization added to all vehicles with frontloaderAttacher. Front-axles are not anymore limited by front-loaders :)")
		registerFrontloaderAxleLockRemover.addingDone = true
	end
end

TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, registerFrontloaderAxleLockRemover.register)