--[[--------------------------------------------------------------------------------------------------
MAIN
------------------------------------------------------------------------------------------------------
file: extendedFinances
author:	Team LTW
start project: 21.11.2017 
------------------------------------------------------------------------------------------------------
Farming Simulator 17
V1.0.0.0 - 08.01.2018

Farming Simulator 19
V1.0.0.0 - 16.05.2019 - converted to Farming Simulator 19
V1.1.0.0 - 14.08.2019 - seasons ready

Farming Simulator 22
V1.0.0.0 - 25.04.2022 - converted to Farming Simulator 22
------------------------------------------------------------------------------------------------------
copyright (c) Team LTW
----------------------------------------------------------------------------------------------------]]

financeExtent = {}
addModEventListener(financeExtent)

function financeExtent:loadMap(name)
	print("-- loading extendedFinances V1.1.0.0 -- (by Team LTW)")
	
	self.done = true	

--load settings	
	local savegameIndex = g_currentMission.missionInfo.savegameIndex
	local savegameFolderPath = getUserProfileAppPath().."savegame"..savegameIndex

	if fileExists(savegameFolderPath.."/extendedFinances.xml") then
		xml = loadXMLFile("extendedFinancesFile", savegameFolderPath.."/extendedFinances.xml")
		local key_activ = "extendedFinances.activModules"
			self.subventionModule = getXMLBool(xml, key_activ..".subvention")
			if self.subventionModule == true then
				local key_subvention = "extendedFinances.modules.subvention"
				self.subvention = getXMLFloat(xml, key_subvention..".lastSubvention")
				self.basicPremium = getXMLInt(xml, key_subvention..".basicPremium")
				self.greening = getXMLInt(xml, key_subvention..".greening")
				self.firstHa = getXMLInt(xml, key_subvention..".firstHa")
				self.furtherHa = getXMLInt(xml, key_subvention..".furtherHa")
				self.youngFarmer = getXMLInt(xml, key_subvention..".youngFarmer")
		end;
		self.exists = true
	else
		self.exists = false

		self.subventionModule = true
		self.subvention = 0
		self.basicPremium = 175
		self.greening = 85
		self.firstHa = 50			-- first 30ha
		self.furtherHa = 30			-- further 16ha
		self.youngFarmer = 44		-- first 5 years
	end
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, financeExtent.saveToXML)	
end

function financeExtent:deleteMap()
end

function financeExtent:mouseEvent(posX, posY, isDown, isUp, button)
end

function financeExtent:keyEvent(unicode, sym, modifier, isDown)
end

function financeExtent:update(dt)
	if g_server ~= nil then
		if self.subventionModule == true then
			if subvention:enablePayTime() == true and self.done == true then
				self.done = false;
			end;		
			if subvention:payTime() == true and self.done == false then
				local farms = g_farmManager.farmIdToFarm
				if farms ~= nil then
					self.farmId = 1	
					while self.farmId <= #farms do
						self.subvention = subvention:economicDifficulty()
						g_currentMission:addMoney(self.subvention, self.farmId, MoneyType.OTHER, true, true)
						self.farmId = self.farmId + 1
					end
				end
				self.done = true
			end
		end
	end	
end

function financeExtent:draw()
end
			

function financeExtent:saveToXML()
	local savegameIndex = g_currentMission.missionInfo.savegameIndex
	local savegameFolderPath = getUserProfileAppPath().."savegame"..savegameIndex

	if not fileExists(savegameFolderPath.."/extendedFinances.xml") then
		xml = createXMLFile("extendedFinancesFile", savegameFolderPath.."/extendedFinances.xml", "extendedFinances")
	end
	
	local key_activ = "extendedFinances.activModules"
	setXMLBool(xml, key_activ..".subvention", financeExtent.subventionModule)
	if financeExtent.subventionModule == true then
		local key_subvention = "extendedFinances.modules.subvention"
		setXMLFloat(xml, key_subvention..".lastSubvention", financeExtent.subvention)
		setXMLInt(xml, key_subvention..".basicPremium", financeExtent.basicPremium)
		setXMLInt(xml, key_subvention..".greening", financeExtent.greening)
		setXMLInt(xml, key_subvention..".firstHa", financeExtent.firstHa)
		setXMLInt(xml, key_subvention..".furtherHa", financeExtent.furtherHa)
		setXMLInt(xml, key_subvention..".youngFarmer", financeExtent.youngFarmer)
	end
	saveXMLFile(xml)
	delete(xml)	
end