--[[--------------------------------------------------------------------------------------------------
MAIN
------------------------------------------------------------------------------------------------------
file: enhancedBunkerSilo
author:	Team LTW
------------------------------------------------------------------------------------------------------
Farming Simulator 19,
V1.0.0.0 - 01.01.2021 - first realease

Farming Simulator 22
V1.0.0.0 - 12.12.2021 - converted to Farming Simulator 22
V1.1.0.0 - 08.01.2024 - add function to cover silo after openening
						add separate input for completely uncover the silo 
------------------------------------------------------------------------------------------------------
copyright (c) Team LTW
----------------------------------------------------------------------------------------------------]]

enhancedBunkerSilo = {}

-- load files
local directory = g_currentModDirectory
source(directory.."scripts/BunkerSiloFillAddEvent.lua")

-- New functions for BunkerSilo
------------------------------------------

function BunkerSilo:getCanRecloseSilo()
	return self.state == BunkerSilo.STATE_DRAIN and self.fillLevel > self.emptyThreshold
end

function BunkerSilo:setComplettOpen()
	if g_server ~= nil then
		self:setState(BunkerSilo.STATE_FILL, true)
	else
		g_client:getServerConnection():sendEvent(BunkerSiloFillAddEvent.new(self))
	end

	--if self.state == self.STATE_FILL then
		--self:removeActionEvents()
	--end
end

function BunkerSilo:registerActionEvents(bunkerSilo)
	local result, eventID = g_inputBinding:registerActionEvent(InputAction.enhancedBunkerSiloOpenComplete, bunkerSilo, bunkerSilo.setComplettOpen, false, true, false, true)
	if result then
		self.complettOpenEvent = eventID
		g_inputBinding:setActionEventTextVisibility(self.complettOpenEvent, true)
    end
end

function BunkerSilo:removeActionEvents()
	if self.complettOpenEvent ~= nil then
		g_inputBinding:removeActionEvent(self.complettOpenEvent)
		self.complettOpenEvent = nil
    end
end

-- Override functions
------------------------------------------

function enhancedBunkerSilo:BunkerSiloSetState(oldFunc, state, showNotification)
	if state ~= self.state then
		if state == BunkerSilo.STATE_FILL then
			-- new code +++
			if self.fillLevel > self.emptyThreshold then
				if self.isServer then
					local area = self.bunkerSiloArea
					local offsetFront = {self:getBunkerAreaOffset(true, 0, self.fermentingFillType),self:getBunkerAreaOffset(true, 0, self.outputFillType)}
					local offsetBack = {self:getBunkerAreaOffset(false, 0, self.fermentingFillType),self:getBunkerAreaOffset(false, 0, self.outputFillType)}
					local fillType = {self.fermentingFillType,self.outputFillType}
					for i=1, 2, 1 do
						local x0 = area.sx + offsetFront[i] * area.dhx_norm
						local z0 = area.sz + offsetFront[i] * area.dhz_norm
						local x1 = x0 + area.dwx
						local z1 = z0 + area.dwz
						local x2 = area.sx + area.dhx - offsetBack[i] * area.dhx_norm
						local z2 = area.sz + area.dhz - offsetBack[i] * area.dhz_norm
						local changed = DensityMapHeightUtil.changeFillTypeAtArea(x0, z0, x1, z1, x2, z2, fillType[i], self.inputFillType)
					end
				end
				self.compactedFillLevel = self.fillLevel
				self.compactedPercent = 100
				if showNotification then
					self:showBunkerMessage(g_i18n:getText("ingameNotification_bunkerSiloCompletelyUncovered"))
				end
				self:removeActionEvents()
			else
				self.compactedFillLevel = 0
				self.compactedPercent = 0
				if showNotification then
					self:showBunkerMessage(g_i18n:getText("ingameNotification_bunkerSiloIsEmpty"))
				end
			end			
			self.fermentingPercent = 0
			self.isOpenedAtFront = false
			self.isOpenedAtBack = false
			self.bunkerSiloArea.offsetFront = 0
			self.bunkerSiloArea.offsetBack = 0
			-- new code ---
			
			if self.isServer then
				g_densityMapHeightManager:removeFixedFillTypesArea(self.bunkerSiloArea)
				g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
			end

		elseif state == BunkerSilo.STATE_CLOSED then
			if self.isServer then
			-- new code +++
				local fillTypeFrom
				if self.fermentingPercent > 0.99 then
					self.isOpenedAtFront = false
					self.isOpenedAtBack = false
					state = BunkerSilo.STATE_FERMENTED
					fillTypeFrom = self.outputFillType
				else
					fillTypeFrom = self.inputFillType
				end

				local area = self.bunkerSiloArea
				local offsetFront = self:getBunkerAreaOffset(true, 0, fillTypeFrom)
				local offsetBack = self:getBunkerAreaOffset(false, 0, fillTypeFrom)
				local x0 = area.sx + offsetFront * area.dhx_norm
				local z0 = area.sz + offsetFront * area.dhz_norm
				local x1 = x0 + area.dwx
				local z1 = z0 + area.dwz
				local x2 = area.sx + area.dhx - offsetBack * area.dhx_norm
				local z2 = area.sz + area.dhz - offsetBack * area.dhz_norm
				local changed = DensityMapHeightUtil.changeFillTypeAtArea(x0, z0, x1, z1, x2, z2, fillTypeFrom, self.fermentingFillType)

				g_densityMapHeightManager:removeFixedFillTypesArea(self.bunkerSiloArea)
				g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
			-- new code ---
			end

			if showNotification then
				self:showBunkerMessage(g_i18n:getText("ingameNotification_bunkerSiloCovered"))
			end
		elseif state == BunkerSilo.STATE_FERMENTED then
			if showNotification then
				self:showBunkerMessage(g_i18n:getText("ingameNotification_bunkerSiloDoneFermenting"))
			end
		elseif state == BunkerSilo.STATE_DRAIN then
			self.bunkerSiloArea.offsetFront = 0
			self.bunkerSiloArea.offsetBack = 0

			if showNotification then
				self:showBunkerMessage(g_i18n:getText("ingameNotification_bunkerSiloOpened"))
			end

			if self.isServer then
				g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)

				local fillTypes = {
					[self.outputFillType] = true
				}

				g_densityMapHeightManager:setFixedFillTypesArea(self.bunkerSiloArea, fillTypes)
			end
		end

		self.state = state
		if self.isServer then
			self:raiseDirtyFlags(self.bunkerSiloDirtyFlag)
		end
	end
end

function enhancedBunkerSilo:BunkerSiloActivatableGetIsActivatable(oldFunc)
	if self.bunkerSilo:getCanInteract() and (self.bunkerSilo:getCanCloseSilo() or self.bunkerSilo:getCanOpenSilo() or self.bunkerSilo:getCanRecloseSilo()) then -- added function getCanRecloseSilo()
		self:updateActivateText()

		return true
	end

	return false
end

function enhancedBunkerSilo:BunkerSiloActivatableRun(oldFunc)
	if self.bunkerSilo:getCanCloseSilo() then
		if g_server ~= nil then
			self.bunkerSilo:setState(BunkerSilo.STATE_CLOSED, true)
		else
			g_client:getServerConnection():sendEvent(BunkerSiloCloseEvent.new(self.bunkerSilo))
		end
	elseif self.bunkerSilo:getCanOpenSilo() then
		local ix, iy, iz = self.bunkerSilo:getInteractionPosition()

		if ix ~= nil then
			if g_server ~= nil then
				self.bunkerSilo:openSilo(ix, iy, iz)
			else
				g_client:getServerConnection():sendEvent(BunkerSiloOpenEvent.new(self.bunkerSilo, ix, iy, iz))
			end
		end
	-- new code +++
	elseif self.bunkerSilo:getCanRecloseSilo() then
		if g_server ~= nil then
			self.bunkerSilo:setState(BunkerSilo.STATE_CLOSED, true)
		else
			g_client:getServerConnection():sendEvent(BunkerSiloCloseEvent.new(self.bunkerSilo))
		end
	-- new code ---
	end

	self:updateActivateText()
end

function enhancedBunkerSilo:BunkerSiloActivatableUpdateActivateText(oldFunc)
	self.activateText = "unknown"
	local ix, iy, iz = self.bunkerSilo:getInteractionPosition()
	local closerToFront = self.bunkerSilo:getIsCloserToFront(ix, iy, iz)

	if self.bunkerSilo.state == BunkerSilo.STATE_FILL then
		self.activateText = g_i18n:getText("action_blanketSilo")
	elseif self.bunkerSilo.state == BunkerSilo.STATE_FERMENTED then
		self.activateText = g_i18n:getText("action_openSilo")
	elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN and ((not self.bunkerSilo.isOpenedAtFront and closerToFront) or (not self.bunkerSilo.isOpenedAtBack and not closerToFront)) then
		self.activateText = g_i18n:getText("action_openSilo")
	-- new code +++
	elseif self.bunkerSilo.state == BunkerSilo.STATE_DRAIN and ((self.bunkerSilo.isOpenedAtFront and closerToFront) or (self.bunkerSilo.isOpenedAtBack and not closerToFront)) then
		self.activateText = g_i18n:getText("action_blanketSilo")
	-- new code ---
	end
end

function enhancedBunkerSilo:BunkerSiloInteractionTriggerCallback(oldFunc, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter or onLeave then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			if onEnter then
				self.playerInRange = true

				g_currentMission.activatableObjectsSystem:addActivatable(self.activatable)
				-- new code +++
				if self.state ~= BunkerSilo.STATE_FILL then
					self:registerActionEvents(self)
				end
				-- new code ---
			else
				self.playerInRange = false

				-- new code +++
				self:removeActionEvents()
				-- new code ---

				if self.numVehiclesInRange == 0 then
					g_currentMission.activatableObjectsSystem:removeActivatable(self.activatable)
				end
			end
		else
			local vehicle = g_currentMission.nodeToObject[otherShapeId]

			if vehicle ~= nil then
				if onEnter then
					if self.vehiclesInRange[vehicle] == nil then
						self.vehiclesInRange[vehicle] = true
						self.numVehiclesInRange = self.numVehiclesInRange + 1

						g_currentMission.activatableObjectsSystem:addActivatable(self.activatable)

						if vehicle.setBunkerSiloInteractorCallback ~= nil then
							vehicle:setBunkerSiloInteractorCallback(BunkerSilo.onChangedFillLevelCallback, self)
						end
					end
				elseif self.vehiclesInRange[vehicle] then
					self.vehiclesInRange[vehicle] = nil
					self.numVehiclesInRange = self.numVehiclesInRange - 1

					if self.numVehiclesInRange == 0 and not self.playerInRange then
						g_currentMission.activatableObjectsSystem:removeActivatable(self.activatable)
					end

					if vehicle.setBunkerSiloInteractorCallback ~= nil then
						vehicle:setBunkerSiloInteractorCallback(nil)
					end
				end
			end
		end
	end
end

--- Override functions on first load
------------------------------------------

local function init()
	BunkerSilo.setState = Utils.overwrittenFunction(BunkerSilo.setState, enhancedBunkerSilo.BunkerSiloSetState)
	BunkerSilo.interactionTriggerCallback = Utils.overwrittenFunction(BunkerSilo.interactionTriggerCallback, enhancedBunkerSilo.BunkerSiloInteractionTriggerCallback)
	BunkerSilo.complettOpenEvent = nil
	
	BunkerSiloActivatable.run = Utils.overwrittenFunction(BunkerSiloActivatable.run, enhancedBunkerSilo.BunkerSiloActivatableRun)
	BunkerSiloActivatable.getIsActivatable = Utils.overwrittenFunction(BunkerSiloActivatable.getIsActivatable, enhancedBunkerSilo.BunkerSiloActivatableGetIsActivatable)
	BunkerSiloActivatable.updateActivateText = Utils.overwrittenFunction(BunkerSiloActivatable.updateActivateText, enhancedBunkerSilo.BunkerSiloActivatableUpdateActivateText)
		
	print("Init enhanced Bunker Silo -- by Team LTW")
end

init()