--[[--------------------------------------------------------------------------------------------------
Event
------------------------------------------------------------------------------------------------------
file: enhancedBunkerSilo
author:	Team LTW
start project: 29.12.2020 
------------------------------------------------------------------------------------------------------
Farming Simulator 19,
V1.0.0.0 - 01.01.2021 - first realease

Farming Simulator 22
V1.0.0.0 - 12.12.2021 - converted to Farming Simulator 22
V1.1.0.0 - 08.01.2024 - add function to cover silo after openening
						add separate input for completely uncover the silo 
------------------------------------------------------------------------------------------------------
copyright (c) Team LTW
----------------------------------------------------------------------------------------------------]]

BunkerSiloFillAddEvent = {}
local BunkerSiloFillAddEvent_mt = Class(BunkerSiloFillAddEvent, Event)

InitEventClass(BunkerSiloFillAddEvent, "BunkerSiloFillAddEvent")

function BunkerSiloFillAddEvent.emptyNew()
	local self = Event.new(BunkerSiloFillAddEvent_mt)

	return self
end

function BunkerSiloFillAddEvent.new(bunkerSilo)
	local self = BunkerSiloFillAddEvent.emptyNew()
	self.bunkerSilo = bunkerSilo

	return self
end

function BunkerSiloFillAddEvent:readStream(streamId, connection)
	if not connection:getIsServer() then
		self.bunkerSilo = NetworkUtil.readNodeObject(streamId)
	end

	self:run(connection)
end

function BunkerSiloFillAddEvent:writeStream(streamId, connection)
	if connection:getIsServer() then
		NetworkUtil.writeNodeObject(streamId, self.bunkerSilo)
	end
end

function BunkerSiloFillAddEvent:run(connection)
	if not connection:getIsServer() then
		self.bunkerSilo:setState(BunkerSilo.STATE_FILL)
	end
end
