-- EasyChangeTransmissionType
-- Specialization to change transmission type via input action
-- Version 1.1.0.0
-- @author Vector Man
-- @date 2021-12-09, 2023-10-08
-- copyright (c) Vector Man, All Rights Reserved.

EasyChangeTransmissionType = {}
EasyChangeTransmissionType.MOD_NAME = g_currentModName
EasyChangeTransmissionType.MOD_DIRECTORY = g_currentModDirectory
EasyChangeTransmissionType.TYPES = {"Automatic", "Manual", "ManualClutch"}

function EasyChangeTransmissionType.prerequisitesPresent(specializations)
	return true
end

function EasyChangeTransmissionType:initSpecialization()
		local schemaSavegame = Vehicle.xmlSchemaSavegame

		schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).transmissionType#index", "1=automatic, 2=manual, 3=manualclutch", true)
end

function EasyChangeTransmissionType.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "setTransmissionType", EasyChangeTransmissionType.setTransmissionType)
	SpecializationUtil.registerFunction(vehicleType, "Input_NEXT_TYPE", EasyChangeTransmissionType.Input_NEXT_TYPE)
	SpecializationUtil.registerFunction(vehicleType, "Input_TYPE_AUTOMATIC", EasyChangeTransmissionType.Input_TYPE_AUTOMATIC)
	SpecializationUtil.registerFunction(vehicleType, "Input_TYPE_MANUAL", EasyChangeTransmissionType.Input_TYPE_MANUAL)
	SpecializationUtil.registerFunction(vehicleType, "Input_TYPE_MANUALCLUTCH", EasyChangeTransmissionType.Input_TYPE_MANUALCLUTCH)
	SpecializationUtil.registerFunction(vehicleType, "updateHUD", EasyChangeTransmissionType.updateHUD)
end

function EasyChangeTransmissionType.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", EasyChangeTransmissionType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", EasyChangeTransmissionType)
	SpecializationUtil.registerEventListener(vehicleType, "onEnterVehicle", EasyChangeTransmissionType)
end

function EasyChangeTransmissionType:onLoad(savegame)
	-- Create spec in self
	self.spec_easyChangeTransmissionType = self[("spec_%s.EasyChangeTransmissionType"):format(EasyChangeTransmissionType.MOD_NAME)]
	
	local spec = self.spec_easyChangeTransmissionType
	
	if savegame ~= nil then
		spec.transmissionType = savegame.xmlFile:getValue(savegame.key .. ".transmissionType#index", 1)
	else
		spec.transmissionType = 1
	end
end

function EasyChangeTransmissionType:onEnterVehicle()
	local spec = self.spec_easyChangeTransmissionType

	self:setTransmissionType(spec.transmissionType)
	self:updateHUD()
end

function EasyChangeTransmissionType:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	local spec = self.spec_easyChangeTransmissionType

	if self.isClient then
		self:clearActionEventsTable(spec.actionEvents)

		if isActiveForInputIgnoreSelection then
			local actionEventId
			-- NEXT_TYPE
			_, actionEventId = self:addActionEvent(spec.actionEvents, "NEXT_TYPE", self, EasyChangeTransmissionType.Input_NEXT_TYPE, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
			g_inputBinding:setActionEventTextVisibility(actionEventId, true)
			g_inputBinding:setActionEventText(actionEventId, string.format(g_i18n:getText("action_NEXT_TYPE", modName), g_i18n:getText("ui_gearShiftMode"..EasyChangeTransmissionType.TYPES[g_gameSettings:getValue("gearShiftMode")])))
			-- TYPE_AUTOMATIC
			_, actionEventId = self:addActionEvent(spec.actionEvents, "TYPE_AUTOMATIC", self, EasyChangeTransmissionType.Input_TYPE_AUTOMATIC, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
			-- TYPE_MANUAL
			_, actionEventId = self:addActionEvent(spec.actionEvents, "TYPE_MANUAL", self, EasyChangeTransmissionType.Input_TYPE_MANUAL, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
			-- TYPE_MANUALCLUTCH
			_, actionEventId = self:addActionEvent(spec.actionEvents, "TYPE_MANUALCLUTCH", self, EasyChangeTransmissionType.Input_TYPE_MANUALCLUTCH, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
		end
	end
end

function EasyChangeTransmissionType:updateHUD()
	local spec = self.spec_easyChangeTransmissionType
	
	local actionEvent = spec.actionEvents["NEXT_TYPE"]
	
	if actionEvent ~= nil then
		g_inputBinding:setActionEventText(actionEvent.actionEventId, string.format(g_i18n:getText("action_NEXT_TYPE", modName), g_i18n:getText("ui_gearShiftMode"..EasyChangeTransmissionType.TYPES[g_gameSettings:getValue("gearShiftMode")])))
	end
end

function EasyChangeTransmissionType:saveToXMLFile(xmlFile, key, usedModNames)
	local spec = self.spec_easyChangeTransmissionType

	local vehicleIndex = string.sub(key, 18, string.len(key) - 60)
	xmlFile:setValue(string.format("vehicles.vehicle(%s).transmissionType#index", vehicleIndex), spec.transmissionType)
end

function EasyChangeTransmissionType:Input_NEXT_TYPE(actionName, inputValue)
	local currentType = g_gameSettings:getValue("gearShiftMode")
	if currentType < 3 then
		self:setTransmissionType(currentType+1)
	else
		self:setTransmissionType(1)
	end
end

function EasyChangeTransmissionType:Input_TYPE_AUTOMATIC(actionName, inputValue)
	self:setTransmissionType(1)
end

function EasyChangeTransmissionType:Input_TYPE_MANUAL(actionName, inputValue)
	self:setTransmissionType(2)
end

function EasyChangeTransmissionType:Input_TYPE_MANUALCLUTCH(actionName, inputValue)
	self:setTransmissionType(3)
end

function EasyChangeTransmissionType:setTransmissionType(index) -- 1=Automatic, 2=Manual, 3=ManualClutch
	local spec = self.spec_easyChangeTransmissionType
	
	g_gameSettings:setValue("gearShiftMode", index)
	spec.transmissionType = index
	self:updateHUD()
end