-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 22
ExtendedCover = {} function ExtendedCover.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(Cover, specializations) end function ExtendedCover.registerEventListeners(vehicleType) SpecializationUtil.registerEventListener(vehicleType, "onUpdate", ExtendedCover) end function ExtendedCover.registerFunctions(vehicleType) SpecializationUtil.registerFunction(vehicleType, "getIsPlayerInCoverRange", ExtendedCover.getIsPlayerInCoverRange) end function ExtendedCover:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected) local spec = self.spec_cover if not spec.hasCovers or isActiveForInputIgnoreSelection then return elseif g_currentMission.accessHandler:canPlayerAccess(self, g_currentMission.player) then self:raiseActive() self:clearActionEventsTable(spec.actionEvents) if self:getIsPlayerInCoverRange() then local state, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_COVER, self, Cover.actionEventToggleCover, false, true, false, true, nil, nil, true, true) if not state then local _ = nil _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA4, self, Cover.actionEventToggleCover, false, true, false, true, nil, nil, true, true) end g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_NORMAL) ExtendedCover.updateActionText(self) end end end function ExtendedCover.updateActionText(self) local spec = self.spec_cover if next(spec.actionEvents) ~= nil then local actionEvent = spec.actionEvents[next(spec.actionEvents)] if actionEvent ~= nil then local text = string.format(g_i18n:getText("action_nextCover")..": "..self:getFullName()) if spec.state == #spec.covers then text = string.format(g_i18n:getText("action_closeCover")..": "..self:getFullName()) elseif spec.state == 0 then text = string.format(g_i18n:getText("action_openCover")..": "..self:getFullName()) end g_inputBinding:setActionEventText(actionEvent.actionEventId, text) end end end function ExtendedCover:getIsPlayerInCoverRange() if g_currentMission.player == nil then return false end if not g_currentMission.accessHandler:canPlayerAccess(self) then return false end local px, py, pz = getWorldTranslation(g_currentMission.player.rootNode) local vx, vy, vz = localToWorld(self.rootNode, 0, 0, 0) if MathUtil.vector3Length(px-vx, py-vy, pz-vz) < 6 then return true end return false end function ExtendedCover:updateDebugValues(values) table.insert(values, {name="getIsPlayerInCoverRange", value=self:getIsPlayerInCoverRange()}) end