--
-- Author: E.T.A La Marchoise
-- Date: 01-11-22
-- Version: 1.0.0.0
-- Copyright (C) E.T.A La Marchoise, All Rights Reserved
-- AttachablePanelsBaseVehicle.lua
--

AttachablePanelsBaseVehicle = {};
AttachablePanelsBaseVehicle.MOD_DIRECTORY = g_currentModDirectory;

local oldAttachablePanelsOnLoadFunction = AttachablePanels.onLoad;
AttachablePanels.onLoad = function(self, ...)
    if not g_vehicleBaseAttachablePanelsIntegration[self.xmlFile.filename] then
        oldAttachablePanelsOnLoadFunction(self, ...);
    end
end;

function AttachablePanelsBaseVehicle.prerequisitesPresent(specializations)
    return true;
end

function AttachablePanelsBaseVehicle.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AttachablePanelsBaseVehicle);
end

function AttachablePanelsBaseVehicle.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "concatCabinIndexAndChild", AttachablePanelsBaseVehicle.concatCabinIndexAndChild);
end

function AttachablePanelsBaseVehicle:onLoad(savegame)
    if g_isCabinPanelsDevMode then
        Logging.info("Load spec AttachablePanelsBaseVehicle for " .. tostring(self.xmlFile:getFilename()));
    end

    local attachablePanelData = g_vehicleBaseAttachablePanelsIntegration[self.xmlFile:getFilename()];

    for iAttachablePanel, attachablePanel in pairs(attachablePanelData.attachablePanels) do
        local parent = I3DUtil.indexToObject(self.components, attachablePanel.parentNode);

        if parent == nil or parent == 0 then
            Logging.xmlError(self.xmlFile, string.format("Invalid parent node (%s) for %s - vehicle base attachable panels integration", attachablePanel.parentNode, self.xmlFile.filename));
            return;
        end

        local attachablePanelTransformGroup = createTransformGroup("attachablePanel" .. tostring(iAttachablePanel));
        setTranslation(attachablePanelTransformGroup, unpack(attachablePanel.translation));
        setRotation(attachablePanelTransformGroup, unpack(attachablePanel.rotation));

        link(parent, attachablePanelTransformGroup);

        local numOfChildren = getNumOfChildren(parent) - 1;
        local key = string.format("vehicle.attachablePanels.attachablePanel(%d)", iAttachablePanel - 1);

        self.xmlFile:setString(key .. "#detachedNode", self:concatCabinIndexAndChild(attachablePanel.parentNode, numOfChildren));
        self.xmlFile:setString(key .. "#filename", attachablePanel.filename);
        self.xmlFile:setString(key .. ".rotation", attachablePanel.detachedRotation);
    end

    for iPanelConnectionHose, panelConnectionHose in pairs(attachablePanelData.panelConnectionHoses) do
        local parent = I3DUtil.indexToObject(self.components, panelConnectionHose.parentNode);

        if parent == nil or parent == 0 then
            Logging.xmlError(self.xmlFile, string.format("Invalid parent node (%s) for %s - vehicle base attachable panels integration", panelConnectionHose.parentNode, self.xmlFile.filename));
            return;
        end

        local panelConnectionHoseTransformGroup = createTransformGroup("panelConnectionHose" .. tostring(iPanelConnectionHose));
        setTranslation(panelConnectionHoseTransformGroup, unpack(panelConnectionHose.translation));
        setRotation(panelConnectionHoseTransformGroup, unpack(panelConnectionHose.rotation));

        link(parent, panelConnectionHoseTransformGroup);

        local numOfChildren = getNumOfChildren(parent) - 1;
        local key = string.format("vehicle.attachablePanels.panelConnectionHoses.hose(%d)", iPanelConnectionHose - 1);

        self.xmlFile:setString(key .. "#node", self:concatCabinIndexAndChild(panelConnectionHose.parentNode, numOfChildren));
        self.xmlFile:setString(key .. "#type", panelConnectionHose.type);
        self.xmlFile:setString(key .. "#inputAttacherJointIndices", panelConnectionHose.inputAttacherJointIndices);

        self.xmlFile:setFloat(key .. "#straighteningFactor", panelConnectionHose.straighteningFactor);
        self.xmlFile:setFloat(key .. "#length", panelConnectionHose.length);
    end

    if oldAttachablePanelsOnLoadFunction ~= nil then
        oldAttachablePanelsOnLoadFunction(self, savegame, AttachablePanelsBaseVehicle.MOD_DIRECTORY);
    end
end

function AttachablePanelsBaseVehicle:concatCabinIndexAndChild(cabinIndex, childIndex)
    local ending = ">";

    if cabinIndex == nil or childIndex == nil then
        return nil;
    end

    if cabinIndex:sub(-#ending) == ending then
        return cabinIndex .. childIndex;
    end

    return cabinIndex .. "|" .. childIndex;
end