--
-- Author: E.T.A La Marchoise
-- Date: 01-11-22
-- Version: 1.0.0.0
-- Copyright (C) E.T.A La Marchoise, All Rights Reserved
-- vehicleBaseAttachablePanelsIntegration.lua
--

g_vehicleBaseAttachablePanelsIntegration = {};

-- Create file schema
local schema = XMLSchema.new("vehicleBaseAttachablePanelsIntegration");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).storeItem", "Filename to storeItem", nil, true);
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).newVehicleType", "New vehicle type name", nil, true);

schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?)#translation", "Translation of attachable panel node", "0 0 0");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?)#rotation", "Rotation of attachable panel node", "0 0 0");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).rotation", "Detached rotation", "0 0 0");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?)#filename", "Filename of panel", nil);
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?)#parentNode", "Node of parent", "0>");

schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#translation", "Translation of indoor hose connector node", "0 0 0");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#rotation", "Rotation of indoor hose connector node", "0 0 0");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#type", "Type of hose connector", "cabinPanel_indoor");
schema:register(XMLValueType.FLOAT, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#straighteningFactor", "Straightening Factor", 1);
schema:register(XMLValueType.FLOAT, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#length", "Hose length", 2);
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#inputAttacherJointIndices", "List of corresponding input attacher joint indices");
schema:register(XMLValueType.STRING, "vehicleBaseIntegration.vehicleBase(?).etaLaMarchoise.attachablePanels.attachablePanel(?).panelConnectionHoses.hose(?)#parentNode", "Node of parent", "0>");

local xmlFile = XMLFile.load("vehicleBaseIntegration", Utils.getFilename(g_vehicleBaseAttachablePanelsIntegrationXmlFilename, g_currentModDirectory), schema);

xmlFile:iterate("vehicleBaseIntegration.vehicleBase", function(index, key)
    local entry = {
        xml = xmlFile:getValue(key .. ".storeItem"),
        newVehicleType = g_currentModName .. "." .. xmlFile:getString(key .. ".newVehicleType"),
        attachablePanels = {},
        panelConnectionHoses = {},
    };

    xmlFile:iterate(key .. ".etaLaMarchoise.attachablePanels.attachablePanel", function(_, cabinPanelKey)
        table.insert(entry.attachablePanels, {
            translation = string.getVectorN(xmlFile:getString(cabinPanelKey .. "#translation", "0 0 0")),
            rotation = string.getRadiansNoNil(xmlFile:getString(cabinPanelKey .. "#rotation", "0 0 0")),
            detachedRotation = xmlFile:getString(cabinPanelKey .. ".rotation", "0 0 0"),
            filename = xmlFile:getString(cabinPanelKey .. "#filename"),
            parentNode = xmlFile:getString(cabinPanelKey .. "#parentNode")
        })
    end);

    xmlFile:iterate(key .. ".etaLaMarchoise.attachablePanels.panelConnectionHoses.hose", function(_, hoseConnectorKey)
        table.insert(entry.panelConnectionHoses, {
            translation = string.getVectorN(xmlFile:getString(hoseConnectorKey .. "#translation", "0 0 0")),
            rotation = string.getRadiansNoNil(xmlFile:getString(hoseConnectorKey .. "#rotation", "0 0 0")),
            type = xmlFile:getString(hoseConnectorKey .. "#type", "cabinPanel_indoor"),
            straighteningFactor = xmlFile:getFloat(hoseConnectorKey .. "#straighteningFactor", 1),
            length = xmlFile:getFloat(hoseConnectorKey .. "#length", 2),
            inputAttacherJointIndices = xmlFile:getString(hoseConnectorKey .. "#inputAttacherJointIndices"),
            parentNode = xmlFile:getString(hoseConnectorKey .. "#parentNode")
        });
    end);

    g_vehicleBaseAttachablePanelsIntegration[entry.xml] = entry;
end);

xmlFile:delete();

local function loadVehicle(self, superFunc, vehicleData, ...)
    local xmlFilename = vehicleData.filename;
    local data = g_vehicleBaseAttachablePanelsIntegration[xmlFilename];

    if data ~= nil then
        local newVehicleType = data.newVehicleType;
        local typeEntry = g_vehicleTypeManager:getTypeByName(newVehicleType);

        if typeEntry ~= nil then
            vehicleData.typeName = newVehicleType;
            self.typeName = newVehicleType;
        end
    end

    return superFunc(self, vehicleData, ...);
end

Vehicle.load = Utils.overwrittenFunction(Vehicle.load, loadVehicle);