--
-- CabinPanels
--
-- @author E.T.A La Marchoise
-- @date 18/01/2021
-- @version 1.0.0.0
--
-- Copyright (C) E.T.A La Marchoise, Confidential, All Rights Reserved.

g_isCabinPanelsDevMode = false;

local MOD_DIRECTORY = g_currentModDirectory;

if g_isCabinPanelsDevMode then
	Logging.info("Load cabin panels as developper mode - not recommanded for a standard usage in the game !");
end

source(MOD_DIRECTORY .. "scripts/utils/string.lua"); -- Fix Giants Software bad logic
source(MOD_DIRECTORY .. "scripts/enum/buttonActions.lua"); -- Load button actions enum

-- Add specializations to vehicles
g_specializationManager:addSpecialization("cabinPanels", 'CabinPanels', Utils.getFilename("scripts/cabinPanels.lua", MOD_DIRECTORY), "")
g_specializationManager:addSpecialization("attachablePanels", "AttachablePanels", Utils.getFilename("scripts/attachablePanels.lua", MOD_DIRECTORY), "");

for vehTypeName, vehTypeObj in pairs(g_vehicleTypeManager.types) do
	-- drivable and can attach smthg
  	if SpecializationUtil.hasSpecialization(Enterable, vehTypeObj.specializations) and SpecializationUtil.hasSpecialization(AttacherJoints, vehTypeObj.specializations) and SpecializationUtil.hasSpecialization(Drivable, vehTypeObj.specializations) and SpecializationUtil.hasSpecialization(ConnectionHoses, vehTypeObj.specializations) then
    	g_vehicleTypeManager:addSpecialization(vehTypeName, "cabinPanels");
  	end

  	-- attachable
  	if SpecializationUtil.hasSpecialization(Attachable, vehTypeObj.specializations) and SpecializationUtil.hasSpecialization(ConnectionHoses, vehTypeObj.specializations) then
    	g_vehicleTypeManager:addSpecialization(vehTypeName, "attachablePanels");
  	end
end

-- Load modDesc custom data
local modDesc = XMLFile.load("modDesc", Utils.getFilename("modDesc.xml", MOD_DIRECTORY));

g_markerFilename = Utils.getFilename(modDesc:getString("modDesc.cabinPanels#markerFilename"), MOD_DIRECTORY);
g_vehicleBaseCabinPanelsIntegrationXmlFilename = modDesc ~= nil and modDesc:getString("modDesc.cabinPanels.vehicleBaseCabinPanelsIntegration");
g_vehicleBaseAttachablePanelsIntegrationXmlFilename = modDesc ~= nil and modDesc:getString("modDesc.cabinPanels.vehicleAttachableCabinPanelsIntegration");

g_defaultActionLabels = {};

modDesc:iterate("modDesc.defaultActionLabels.defaultActionLabel", function(_, key)
	local action = modDesc:getString(key .. "#action");

	if action ~= nil then
		g_defaultActionLabels[action] = {activated = modDesc:getString(key .. ".activated"), deactivated = modDesc:getString(key .. ".deactivated")}
	end
end);

modDesc:delete();