TrailerHUD = {
	specEntryName = string.format("spec_%s.trailerHUD", g_currentModName)
}

function TrailerHUD.prerequisitesPresent(specializations)
	return true
end

function TrailerHUD.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", TrailerHUD)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", TrailerHUD)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", TrailerHUD)
	SpecializationUtil.registerEventListener(vehicleType, "onChangedFillType", TrailerHUD)
	SpecializationUtil.registerEventListener(vehicleType, "onFillUnitFillLevelChanged", TrailerHUD)
end

function TrailerHUD:onLoad(savegame)
	local spec = self[TrailerHUD.specEntryName]
	local hudSettings = g_additionalSettingsManager:getSettingByName("trailerHUD")

	if hudSettings ~= nil and hudSettings.loadHUD ~= nil then
		local hud = hudSettings:loadHUD()

		if hud ~= nil then
			spec.hud = hud
			spec.lastFillUnitIndex = 1
			spec.fillLevelHUDEnabled = 0
			spec.maxDrawDistance = 35
		end
	end
end

function TrailerHUD:onDelete()
	local spec = self[TrailerHUD.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local hudSettings = g_additionalSettingsManager:getSettingByName("trailerHUD")

		if hudSettings ~= nil and hudSettings.deleteHUD ~= nil then
			hudSettings:deleteHUD(hud)
		end
	end
end

function TrailerHUD:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self[TrailerHUD.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local isVisible = false

		if g_additionalSettingsManager:getSettingStateByName("trailerHUD") ~= 0 and not isActiveForInputIgnoreSelection then
			spec.fillLevelHUDEnabled = math.max(spec.fillLevelHUDEnabled - dt, 0)

			if spec.fillLevelHUDEnabled > 0 then
				local canFarmAccess = g_currentMission.accessHandler:canFarmAccess(g_currentMission:getFarmId(), self)
				local fillType = self:getFillUnitLastValidFillType(spec.lastFillUnitIndex)

				if canFarmAccess and fillType ~= nil and fillType ~= FillType.UNKNOWN then
					local x, y, z = getWorldTranslation(self.rootNode)
					y = y + 3.5

					local sx, sy, sz = project(x, y, z)

					if sx > -1 and sx < 2 and sy > -1 and sy < 2 and sz <= 1 then
						local vx, vy, vz = getWorldTranslation(getCamera())
						local distance = MathUtil.vector3Length(x - vx, y - vy, z - vz)

						if distance <= spec.maxDrawDistance then
							local scale = 1 / distance * 10

							local fillType = g_fillTypeManager:getFillTypeByIndex(fillType)
							local fillLevel = self:getFillUnitFillLevel(spec.lastFillUnitIndex)
							local fillLevelPercentage = self:getFillUnitFillLevelPercentage(spec.lastFillUnitIndex)
							local fillLevelText = string.format("%d%s (%d%%)", MathUtil.round(fillLevel), fillType.unitShort or "", 100 * fillLevelPercentage)

							hud:updateData(sx, sy, scale, fillLevelPercentage, fillLevelText, fillType.title)
							isVisible = true
						end
					end
				end

				self:raiseActive()
			end
		end

		hud:setVisible(isVisible)
	end
end

function TrailerHUD:onChangedFillType(fillUnitIndex, fillTypeIndex, oldFillTypeIndex)
	local spec = self[TrailerHUD.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local fillType = self:getFillUnitFillType(fillUnitIndex)

		if fillType ~= nil and fillType ~= FillType.UNKNOWN then
			hud:updateFillTypeIcon(g_fillTypeManager:getFillTypeByIndex(fillType).hudOverlayFilename)
		end
	end
end

function TrailerHUD:onFillUnitFillLevelChanged(fillUnitIndex, fillLevelDelta, fillTypeIndex, toolType, fillPositionData, appliedDelta)
	local spec = self[TrailerHUD.specEntryName]
	local hud = spec.hud

	if hud ~= nil then
		local setting = g_additionalSettingsManager:getSettingByName("trailerHUD")

		if setting.state ~= 0 and fillLevelDelta > 0 then
			local fillUnit = self:getFillUnitByIndex(fillUnitIndex)

			if fillUnit.showOnHud then
				spec.fillLevelHUDEnabled = setting.hudEnableTime
				spec.lastFillUnitIndex = fillUnitIndex
			end
		end
	end
end