--
-- TrailerFillLevelHUD
--
-- @author Rockstar
-- @date 27/03/2021
--

--
-- @fs22 24/11/2021
--


TrailerFillLevelHUD = {}

local TrailerFillLevelHUD_mt = Class(TrailerFillLevelHUD, HUDElement)

function TrailerFillLevelHUD.new()
	local hudAtlasPath = g_baseHUDFilename
	local backgroundOverlay = TrailerFillLevelHUD.createBackground(hudAtlasPath)
	local self = TrailerFillLevelHUD:superClass().new(backgroundOverlay, nil, TrailerFillLevelHUD_mt)

	self.uiScale = 1
	self.fillLevelText = ""
	self.fillTypeText = ""

	self:createComponents(hudAtlasPath)

	return self
end

function TrailerFillLevelHUD:setScale(uiScale)
	TrailerFillLevelHUD:superClass().setScale(self, uiScale, uiScale)
	self.uiScale = uiScale
end

function TrailerFillLevelHUD.createBackground()
	local width, height = getNormalizedScreenValues(unpack(TrailerFillLevelHUD.SIZE.BACKGROUND))
	local backgroundOverlay = Overlay.new(nil, 0.5, 0.5, width, height)

	backgroundOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_CENTER)

	return backgroundOverlay
end

function TrailerFillLevelHUD:createComponents(hudAtlasPath)
	local width = self:getWidth()
	local height = self:getHeight()
	local posX, posY = self:getPosition()
	local frame = HUDFrameElement.new(hudAtlasPath, posX - width / 2, posY - height / 2, width, height)

	frame.topLine:setVisible(false)
	frame.leftLine:setVisible(false)
	frame.rightLine:setVisible(false)
	frame:setColor(unpack(TrailerFillLevelHUD.COLOR.FRAME))
	frame.bottomBar:setColor(unpack(FillLevelsDisplay.COLOR.BAR_FILLED))

	self:addChild(frame)

	self:createFillTypeFrame(hudAtlasPath, frame, posX, posY)
end

function TrailerFillLevelHUD:createFillTypeFrame(hudAtlasPath, frame, basePosX, basePosY)
	local iconWidth, iconHeight = getNormalizedScreenValues(unpack(FillLevelsDisplay.SIZE.FILL_TYPE_ICON))
	local width, height = getNormalizedScreenValues(unpack(FillLevelsDisplay.SIZE.BAR))
	local posX, posY = basePosX  + iconWidth / 2, basePosY

	local bgOverlay = Overlay.new(hudAtlasPath, posX, posY, width, height)
	bgOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_CENTER)
	bgOverlay:setUVs(GuiUtils.getUVs(HUDElement.UV.FILL))
	bgOverlay:setColor(unpack(TrailerFillLevelHUD.COLOR.BAR_BACKGROUND))
	frame:addChild(HUDElement.new(bgOverlay))

	local fillOverlay = Overlay.new(hudAtlasPath, posX - width / 2, posY - height / 2, width, height)
	fillOverlay:setUVs(GuiUtils.getUVs(HUDElement.UV.FILL))
	fillOverlay:setColor(unpack(FillLevelsDisplay.COLOR.BAR_FILLED))

	local fillBarElement = HUDElement.new(fillOverlay)
	frame:addChild(fillBarElement)

	local offsetX, _ = getNormalizedScreenValues(unpack(TrailerFillLevelHUD.POSITION.ICON_OFFSET))
	local iconOverlay = Overlay.new(nil, posX - offsetX - width / 2, posY, iconWidth, iconHeight)
	iconOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_RIGHT)
	iconOverlay:setColor(unpack(FillLevelsDisplay.COLOR.FILL_TYPE_ICON))

	local fillTypeIcon = HUDElement.new(iconOverlay)
	frame:addChild(fillTypeIcon)

	self.bgOverlay = bgOverlay
	self.fillTypeIcon = fillTypeIcon
	self.fillLevelBar = fillBarElement
end

function TrailerFillLevelHUD:draw()
	TrailerFillLevelHUD:superClass().draw(self)

	if self:getVisible() then
		local posX, posY = self.bgOverlay:getPosition()
		local width = self.bgOverlay.width
		local fillLevelTextSize = self:scalePixelToScreenHeight(HUDElement.TEXT_SIZE.DEFAULT_TEXT)
		local fillLevelTextOffsetY = self:scalePixelToScreenHeight(TrailerFillLevelHUD.POSITION.FILLLEVEL_TEXT_OFFSET_Y)
		local fillTypeTextOffsetY = self:scalePixelToScreenHeight(TrailerFillLevelHUD.POSITION.FILLTYPE_TEXT_OFFSET_Y)

		setTextColor(unpack(FillLevelsDisplay.COLOR.FILL_LEVEL_TEXT))
		setTextBold(false)
		setTextAlignment(RenderText.ALIGN_RIGHT)
		renderText(posX + width / 2, posY + fillLevelTextOffsetY, fillLevelTextSize, self.fillLevelText)
		renderText(posX + width / 2, posY + fillTypeTextOffsetY, fillLevelTextSize, self.fillTypeText)
	end
end

function TrailerFillLevelHUD:updateFillLevelBar(value)
	local fillLevelBar = self.fillLevelBar
	local _, yScale = fillLevelBar:getScale()

	fillLevelBar:setScale(value * self.uiScale, yScale)
end

function TrailerFillLevelHUD:updateFillTypeIcon(overlayFilename)
	if self.fillTypeIcon.overlay ~= nil then
		self.fillTypeIcon:setImage(overlayFilename)
	end
end

function TrailerFillLevelHUD:updateFillTypeText(fillLevelText, fillTypeText)
	self.fillLevelText = fillLevelText
	self.fillTypeText = fillTypeText
end

function TrailerFillLevelHUD:updateData(posX, posY, scale, fillLevelPercentage, fillLevelText, fillLevelName)
	self:setPosition(posX, posY)
	self:setScale(scale, scale)
	self:updateFillLevelBar(fillLevelPercentage)
	self:updateFillTypeText(fillLevelText, fillLevelName)
end

TrailerFillLevelHUD.SIZE = {
	BACKGROUND = {
		200,
		70
	}
}

TrailerFillLevelHUD.POSITION = {
	FILLLEVEL_TEXT_OFFSET_Y = 11,
	FILLTYPE_TEXT_OFFSET_Y = -23,
	ICON_OFFSET = {
		5,
		0
	}
}

TrailerFillLevelHUD.COLOR = {
	BAR_BACKGROUND = {
		1,
		1,
		1,
		0.2
	},
	FRAME = {
		0,
		0,
		0,
		0.75
	}
}