--
-- FS22 - Workplan - SelectFrame
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--      - Release
--

SelectFrame = {
	CONTROLS = {
		DIALOG_TITLE = "dialogTitleElement",
		CLOSE_BUTTON = "closeButton",
        TABLE = "dataTable",
        TABLE_TEMPLATE = "dataTableRowTemplate"
	}
}
local SelectFrame_mt = Class(SelectFrame, MessageDialog)

SelectFrame.FIELDS = 1
SelectFrame.FRUITS = 2
SelectFrame.DATA_STATE = 3
SelectFrame.DATA_YESNO = 4
SelectFrame.SPRAY = 5

function SelectFrame.new(target, custom_mt)
	local self = MessageDialog.new(target, custom_mt or SelectFrame_mt)

	self:registerControls(SelectFrame.CONTROLS)

	return self
end

function SelectFrame:onCreate()
	SelectFrame:superClass().onCreate(self)    
end

function SelectFrame:onGuiSetupFinished()
	SelectFrame:superClass().onGuiSetupFinished(self)
	self.dataTable:setDataSource(self)
	self.dataTable:setDelegate(self)
end

function SelectFrame:onOpen()
	SelectFrame:superClass().onOpen(self)
	FocusManager:setFocus(self.dataTable)
end

function SelectFrame:setData(window, target, data, headerKey)   
	if self.dialogTitleElement ~= nil and headerKey ~= nil then		
		self.dialogTitleElement:setText(g_i18n:getText(headerKey))
	else		
		self.dialogTitleElement:setText(g_i18n:getText("ui_choose"))
	end

    self.data = {
		{
			entries = {}
		}
	}

	self.targetWindow = window
	self.targetRef = target

	if data == SelectFrame.FIELDS then
		for _,field in pairs(g_fieldManager.fields) do		
			table.insert(self.data[1].entries, {index = field.fieldId, header = field.fieldId})
		end
	elseif data == SelectFrame.FRUITS then
		for _,fruit in pairs(g_fruitTypeManager:getFruitTypes()) do		
			table.insert(self.data[1].entries, {index = fruit.index, header = fruit.fillType.title})
		end
	elseif data == SelectFrame.DATA_STATE then
		table.insert(self.data[1].entries, {index = FieldEntry.DATA.REQUIRED, header = g_i18n:getText("data_required")})
		table.insert(self.data[1].entries, {index = FieldEntry.DATA.NOT_REQUIRED, header = g_i18n:getText("data_notRequired")})
		table.insert(self.data[1].entries, {index = FieldEntry.DATA.COMPLETE, header = g_i18n:getText("data_complete")})
	elseif data == SelectFrame.DATA_YESNO then
		table.insert(self.data[1].entries, {index = FieldEntry.DATA.Yes, header = g_i18n:getText("data_yes")})
		table.insert(self.data[1].entries, {index = FieldEntry.DATA.NO, header = g_i18n:getText("data_no")})
	elseif data == SelectFrame.SPRAY then
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_ARTIFICIAL_FERTILIZER, header = g_i18n:getText("spray_artificialFertilizer")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_LIQUID, header = g_i18n:getText("spray_liquide")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_SAWINGFERT, header = g_i18n:getText("spray_sawingFert")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_MANURE, header = g_i18n:getText("spray_manure")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_LIQUIDMANURE, header = g_i18n:getText("spray_liquidmanure")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_DIGASTE, header = g_i18n:getText("spray_digaste")})
		table.insert(self.data[1].entries, {index = FieldEntry.SPRAY.SPRAY_INTERCROP, header = g_i18n:getText("spray_intercrop")})	
	end
    
	self.dataTable:reloadData()    
end

function SelectFrame:getNumberOfSections()
	return #self.data
end

function SelectFrame:getNumberOfItemsInSection(list, section)
	return #self.data[section].entries
end

function SelectFrame:populateCellForItemInSection(list, section, index, cell)
	local entry = self.data[section].entries[index]    
	cell:getAttribute("data"):setText(entry.header)
end

function SelectFrame:onListSelectionChanged(list, section, index)
	local data = self.data[section]    
	if data ~= nil and data.entries[index] ~= nil then        
        self.currentValue = data.entries[index].index
    end
end

function SelectFrame:onClose()
	SelectFrame:superClass().onClose(self)
end

function SelectFrame:onClickBack(sender)
	self:close()
end

function SelectFrame:onDoubleClick(list, section, index, element)
	local data = self.data[section]    
	if data ~= nil and data.entries[index] ~= nil then    
		self.targetWindow:changeInput(self.targetRef, data.entries[index].index)
    end
	self:close()
end

function SelectFrame:onClickSelect(sender)
	self.targetWindow:changeInput(self.targetRef, self.currentValue)
	self:close()
end