--
-- FS22 - Workplan - AddEditFrame
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--      - Release
--

AddEditFrame = {
	CONTROLS = {
		DIALOG_TITLE = "dialogTitleElement",
		CLOSE_BUTTON = "closeButton",  
		BTN_FIELD = "btnField",        
		BTN_CURRENTFRUIT = "btnCurrentFruit",        
		BTN_PLANNEDFRUIT = "btnPlannedFruit",        
		BTN_LIME = "btnLime",              
		BTN_MULCHING = "btnMulching",        
		BTN_PLOW = "btnPlow",        
		BTN_ROLLER = "btnRoller",        
		BTN_FERT1_TYP = "btnFert1Typ",        
		BTN_FERT1_STATE = "btnFert1State",        
		BTN_FERT2_TYP = "btnFert2Typ",        
		BTN_FERT2_STATE = "btnFert2State",        
		BTN_WEED_GROOMING = "btnWeedGrooming",        
		BTN_WEED_SPRAY = "btnWeedSpray",        
		BTN_STONE = "btnStone",           
		BTN_SAVE = "btnSave",           
	}
}
local AddEditFrame_mt = Class(AddEditFrame, MessageDialog)

AddEditFrame.FIELD = 1
AddEditFrame.CURRENTFRUIT = 2
AddEditFrame.PLANNEDFRUIT = 3
AddEditFrame.LIME = 4
AddEditFrame.MULCHING = 5
AddEditFrame.PLOW = 6
AddEditFrame.ROLLER = 7
AddEditFrame.FERT_1_TYP = 8
AddEditFrame.FERT_1_STATE = 9
AddEditFrame.FERT_2_TYP = 10
AddEditFrame.FERT_3_STATE = 11
AddEditFrame.WEED_GROOMING = 12
AddEditFrame.WEED_SPRAY = 13
AddEditFrame.STONE = 14

function AddEditFrame.new(target, custom_mt)
	local self = MessageDialog.new(target, custom_mt or AddEditFrame_mt)

	self:registerControls(AddEditFrame.CONTROLS)

	return self
end

function AddEditFrame:onCreate()
	AddEditFrame:superClass().onCreate(self)    
end

function AddEditFrame:onGuiSetupFinished()
	AddEditFrame:superClass().onGuiSetupFinished(self)
    
end

function AddEditFrame:onOpen()
	AddEditFrame:superClass().onOpen(self)
	FocusManager:setFocus(self.fieldCalculatorSeedTable)
end

function AddEditFrame:addRow()  
    self.isEdit = false
	self.currentEntry = FieldEntry.new()
    self.dialogTitleElement:setText(g_i18n:getText("ui_addEditFrame_add"))
    self.btnSave:setText(g_i18n:getText("ui_btn_add"))
    self:setUiData()
end

function AddEditFrame:editRow(entry) 
    self.isEdit = true
	self.currentEntry = entry:makeCopy()    
    self.dialogTitleElement:setText(g_i18n:getText("ui_addEditFrame_edit"))
    self.btnSave:setText(g_i18n:getText("ui_btn_addEdit"))
    self:setUiData()
end

function AddEditFrame:setUiData()
    if self.currentEntry.fieldId > 0 then
        self.btnField:setText(self.currentEntry.fieldId)
    else
        self.btnField:setText(g_i18n:getText("ui_noEntry"))
    end
    
    if self.currentEntry.currentFruit > 0 then
        self.btnCurrentFruit:setText(g_fruitTypeManager:getFruitTypeByIndex(self.currentEntry.currentFruit).fillType.title)
    else
        self.btnCurrentFruit:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.plannedFruit > 0 then
        self.btnPlannedFruit:setText(g_fruitTypeManager:getFruitTypeByIndex(self.currentEntry.plannedFruit).fillType.title)
    else
        self.btnPlannedFruit:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateLime > 0 then
        self.btnLime:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateLime))
    else
        self.btnLime:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateMulching > 0 then
        self.btnMulching:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateMulching))
    else
        self.btnMulching:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.statePlow > 0 then
        self.btnPlow:setText(g_currentMission.workplan:getDataText(self.currentEntry.statePlow))
    else
        self.btnPlow:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateRoller > 0 then
        self.btnRoller:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateRoller))
    else
        self.btnRoller:setText(g_i18n:getText("ui_noEntry"))
    end
    
    if self.currentEntry.stateFert1_type > 0 then
        self.btnFert1Typ:setText(g_currentMission.workplan:getSprayText(self.currentEntry.stateFert1_type))
    else
        self.btnFert1Typ:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateFert1_state > 0 then
        self.btnFert1State:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateFert1_state))
    else
        self.btnFert1State:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateFert2_type > 0 then
        self.btnFert2Typ:setText(g_currentMission.workplan:getSprayText(self.currentEntry.stateFert2_type))
    else
        self.btnFert2Typ:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateFert2_state > 0 then
        self.btnFert2State:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateFert2_state))
    else
        self.btnFert2State:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateWeed_grooming > 0 then
        self.btnWeedGrooming:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateWeed_grooming))
    else
        self.btnWeedGrooming:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateWeed_spray > 0 then
        self.btnWeedSpray:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateWeed_spray))
    else
        self.btnWeedSpray:setText(g_i18n:getText("ui_noEntry"))
    end

    if self.currentEntry.stateStone > 0 then
        self.btnStone:setText(g_currentMission.workplan:getDataText(self.currentEntry.stateStone))
    else
        self.btnStone:setText(g_i18n:getText("ui_noEntry"))
    end  
end

function AddEditFrame:changeInput(target, value)    
    if target == AddEditFrame.FIELD then
        self.currentEntry.fieldId = value
    elseif target == AddEditFrame.CURRENTFRUIT then
        self.currentEntry.currentFruit = value
    elseif target == AddEditFrame.PLANNEDFRUIT then
        self.currentEntry.plannedFruit = value
    elseif target == AddEditFrame.LIME then
        self.currentEntry.stateLime = value
    elseif target == AddEditFrame.MULCHING then
        self.currentEntry.stateMulching = value
    elseif target == AddEditFrame.PLOW then
        self.currentEntry.statePlow = value
    elseif target == AddEditFrame.ROLLER then
        self.currentEntry.stateRoller = value
    elseif target == AddEditFrame.FERT_1_TYP then
        self.currentEntry.stateFert1_type = value
    elseif target == AddEditFrame.FERT_1_STATE then
        self.currentEntry.stateFert1_state = value
    elseif target == AddEditFrame.FERT_2_TYP then
        self.currentEntry.stateFert2_type = value
    elseif target == AddEditFrame.FERT_2_STATE then
        self.currentEntry.stateFert2_state = value
    elseif target == AddEditFrame.WEED_GROOMING then
        self.currentEntry.stateWeed_grooming = value
    elseif target == AddEditFrame.WEED_SPRAY then
        self.currentEntry.stateWeed_spray = value
    elseif target == AddEditFrame.STONE then
        self.currentEntry.stateStone = value   
    end
    self:setUiData()
end

function AddEditFrame:onClose()
	AddEditFrame:superClass().onClose(self)
end

function AddEditFrame:onClickBack(sender)
	self:close()
end

function AddEditFrame:onClickSave(sender)
    if not self.isEdit then     
        local currentFarmId = -1
        local farm = g_farmManager:getFarmByUserId(g_currentMission.playerUserId)
        if farm ~= nil then
            currentFarmId = farm.farmId
        end

        self.currentEntry.farmId = currentFarmId 
    end

    g_client:getServerConnection():sendEvent(FieldEntryAddEditEvent.new(self.currentEntry, self.isEdit))  
	self:close()
end

function AddEditFrame:onClickSetField()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.FIELD, SelectFrame.FIELDS, "ui_header_field")
    end
end

function AddEditFrame:onClickSetCurrentFruit()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.CURRENTFRUIT, SelectFrame.FRUITS, "ui_header_currentFruit")
    end
end

function AddEditFrame:onClickSetPlannedFruit()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.PLANNEDFRUIT, SelectFrame.FRUITS, "ui_header_planedFruit")
    end
end

function AddEditFrame:onClickSetLime()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.LIME, SelectFrame.DATA_STATE, "ui_header_lime")
    end
end

function AddEditFrame:onClickSetMulching()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.MULCHING, SelectFrame.DATA_STATE, "ui_header_mulching")
    end
end

function AddEditFrame:onClickSetPlow()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.PLOW, SelectFrame.DATA_STATE, "ui_header_plow")
    end
end

function AddEditFrame:onClickSetRoller()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.ROLLER, SelectFrame.DATA_STATE, "ui_header_roller")
    end
end

function AddEditFrame:onClickSetFert1Typ()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.FERT_1_TYP, SelectFrame.SPRAY, "ui_header_fert1_typ")
    end
end

function AddEditFrame:onClickSetFert1State()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.FERT_1_STATE, SelectFrame.DATA_YESNO, "ui_header_fert1_state")
    end
end

function AddEditFrame:onClickSetFert2Typ()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.FERT_2_TYP, SelectFrame.SPRAY, "ui_header_fert2_typ")
    end
end

function AddEditFrame:onClickSetFert2State()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.FERT_2_STATE, SelectFrame.DATA_YESNO, "ui_header_fert2_state")
    end
end

function AddEditFrame:onClickSetWeedGrooming()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.WEED_GROOMING, SelectFrame.DATA_STATE, "ui_header_weed_grooming")
    end
end

function AddEditFrame:onClickSetWeedSpray()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.WEED_SPRAY, SelectFrame.DATA_STATE, "ui_header_weed_spray")
    end
end

function AddEditFrame:onClickSetStone()
    local dialog = g_gui:showDialog("SelectFrame")
    if dialog ~= nil then
        dialog.target:setData(self, AddEditFrame.STONE, SelectFrame.DATA_STATE, "ui_header_stone")
    end
end