--
-- FS22 - InitialWorkplanEvent
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--		Release fs22
--

InitialWorkplanEvent = {}
local InitialWorkplanEvent_mt = Class(InitialWorkplanEvent, Event)

InitEventClass(InitialWorkplanEvent, "InitialWorkplanEvent")

function InitialWorkplanEvent.emptyNew()
	return Event.new(InitialWorkplanEvent_mt)
end

function InitialWorkplanEvent.new()
	return InitialWorkplanEvent.emptyNew()
end

function InitialWorkplanEvent:writeStream(streamId, connection)    
	streamWriteInt32(streamId, #g_currentMission.workplan.fieldEntries)
	for _,entry in pairs(g_currentMission.workplan.fieldEntries) do
        entry:writeStream(streamId, connection)
	end
end

function InitialWorkplanEvent:readStream(streamId, connection)
	local num = streamReadInt32(streamId)
	for i = 0, num-1 do
        local entry = FieldEntry.new()	
        entry:readStream(streamId, connection)
        table.insert(g_currentMission.workplan.fieldEntries, entry)
	end
    
	self:run(connection)
end

function InitialWorkplanEvent:run(connection)
	if connection:getIsServer() then
        if g_currentMission.workplanFieldsUi ~= nil then
            g_currentMission.workplanFieldsUi:updateContent()
        end
	end
end