--
-- FS22 - FieldLease - FieldEntryDeleteEvent
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--		Release fs22
--

FieldEntryDeleteEvent = {}
local FieldEntryDeleteEvent_mt = Class(FieldEntryDeleteEvent, Event)

InitEventClass(FieldEntryDeleteEvent, "FieldEntryDeleteEvent")

function FieldEntryDeleteEvent.emptyNew()
	local self = Event.new(FieldEntryDeleteEvent_mt)

	return self
end

function FieldEntryDeleteEvent.new(id)
	local self = FieldEntryDeleteEvent.emptyNew()
	self.deleteId = id

	return self
end

function FieldEntryDeleteEvent:readStream(streamId, connection)
	self.deleteId = streamReadInt32(streamId)
	self:run(connection)
end

function FieldEntryDeleteEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.deleteId)
end

function FieldEntryDeleteEvent:run(connection)
    for id, entry in pairs(g_currentMission.workplan.fieldEntries) do  
        if entry.id == self.deleteId then
            table.remove(g_currentMission.workplan.fieldEntries, id)
            break
        end
    end

    if not connection:getIsServer() then        
        g_server:broadcastEvent(self, true)
    else            
        if g_currentMission.workplanFieldsUi ~= nil then
            g_currentMission.workplanFieldsUi:updateContent()
        end
    end
end