--
-- FS22 - FieldEntryAddEditEvent
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--		Release fs22
--

FieldEntryAddEditEvent = {}
local FieldEntryAddEditEvent_mt = Class(FieldEntryAddEditEvent, Event)

InitEventClass(FieldEntryAddEditEvent, "FieldEntryAddEditEvent")

function FieldEntryAddEditEvent.emptyNew()
	return Event.new(FieldEntryAddEditEvent_mt)
end

function FieldEntryAddEditEvent.new(entry, isEdit)
	local self = FieldEntryAddEditEvent.emptyNew()
	self.entry = entry
	self.isEdit = isEdit
	return self
end

function FieldEntryAddEditEvent:writeStream(streamId, connection)    
    streamWriteBool(streamId, self.isEdit)

	self.entry:writeStream(streamId, connection)    
end

function FieldEntryAddEditEvent:readStream(streamId, connection)
    self.isEdit = streamReadBool(streamId)

	self.entry = FieldEntry.new()
	self.entry:readStream(streamId, connection) 

	self:run(connection)
end

function FieldEntryAddEditEvent:run(connection)	
	if not connection:getIsServer() then	
        if not self.isEdit then
		    self.entry.id = g_currentMission.workplan:getNextId()	
        end
		g_server:broadcastEvent(FieldEntryAddEditEvent.new(self.entry, self.isEdit))
	end   

    if self.isEdit then
        for _,e in pairs(g_currentMission.workplan.fieldEntries) do
            if e.id == self.entry.id then                
                e.fieldId = self.entry.fieldId
                e.currentFruit = self.entry.currentFruit
                e.plannedFruit = self.entry.plannedFruit
                e.stateLime = self.entry.stateLime
                e.stateMulching = self.entry.stateMulching
                e.statePlow = self.entry.statePlow
                e.stateRoller = self.entry.stateRoller
                e.stateFert1_type = self.entry.stateFert1_type
                e.stateFert1_state = self.entry.stateFert1_state
                e.stateFert2_type = self.entry.stateFert2_type
                e.stateFert2_state = self.entry.stateFert2_state
                e.stateWeed_grooming = self.entry.stateWeed_grooming
                e.stateWeed_spray = self.entry.stateWeed_spray
                e.stateStone = self.entry.stateStone   
                break
            end
        end
    else
        table.insert(g_currentMission.workplan.fieldEntries, self.entry)
    end	

    if g_currentMission.workplanFieldsUi ~= nil then
        g_currentMission.workplanFieldsUi:updateContent()
    end
end