--
-- FS22 - Workplan
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
-- 		- Release
--

Workplan = {}
Workplan.dir = g_currentModDirectory
Workplan.modName = g_currentModName

source(Workplan.dir .. "KrSoftwareUtils.lua")
source(Workplan.dir .. "FieldEntry.lua")
source(Workplan.dir .. "gui/InGameMenuFieldplan.lua")
source(Workplan.dir .. "gui/AddEditFrame.lua")
source(Workplan.dir .. "gui/SelectFrame.lua")

source(Workplan.dir .. "events/FieldEntryAddEditEvent.lua")
source(Workplan.dir .. "events/FieldEntryDeleteEvent.lua")
source(Workplan.dir .. "events/InitialWorkplanEvent.lua")

function Workplan:loadMap()
	KrSoftwareUtils.loadTextFromMod(Workplan.modName, Workplan.dir)
	KrSoftwareUtils.mergeModTranslations(g_i18n)

	local ui = g_currentMission.inGameMenu

    g_gui:loadProfiles(Workplan.dir .. "gui/guiProfiles.xml")

	local guiFieldplan = InGameMenuFieldplan.new(g_i18n) 
	g_gui:loadGui(Workplan.dir .. "gui/InGameMenuFieldplan.xml", "ingameMenuFieldplan", guiFieldplan, true)
	
	local addEditFrame = AddEditFrame.new(g_i18n) 
	g_gui:loadGui(Workplan.dir .. "gui/AddEditFrame.xml", "AddEditFrame", addEditFrame)	

	local selectFrame = SelectFrame.new(g_i18n) 
	g_gui:loadGui(Workplan.dir .. "gui/SelectFrame.xml", "SelectFrame", selectFrame)

	Workplan.fixInGameMenu(guiFieldplan,"ingameMenuFieldplan", {0,0,1024,1024}, 2, Workplan:makeIsFieldplanEnabledPredicate())

	g_currentMission.workplan = self
	
	self.fieldEntryId = 0
	self.fieldEntries = {}
	
	FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, Workplan.saveToXmlFile)
	self:loadFromXMLFile()

	guiFieldplan:initialize()	
end

function Workplan:makeIsFieldplanEnabledPredicate()
	return function () return true end
end

function Workplan:hasFieldEntryWithId(searchId)
	for _,e in pairs(g_currentMission.workplan.fieldEntries) do
		if id == searchId then
			return true
		end
	end
	
	return false
end

function Workplan:getNextId()
	self.fieldEntryId = self.fieldEntryId + 1
	return self.fieldEntryId
end

function Workplan:saveToXmlFile()
	if(not g_currentMission:getIsServer()) then return end

	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory.."/"
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), g_currentMission.missionInfo.savegameIndex.."/")
	end

	local key = "workplan";
	local xmlFile = createXMLFile(key, savegameFolderPath.."workplan.xml", key);

	local i = 0	
	for _,e in pairs(g_currentMission.workplan.fieldEntries) do
        local keyE = string.format("%s.fields.field(%d)", key, i)
		e:saveToXmlFile(xmlFile, keyE)		
		i = i + 1
	end
    
	saveXMLFile(xmlFile);
	delete(xmlFile);
end

function Workplan:loadFromXMLFile()
	if(not g_currentMission:getIsServer()) then return end
	
	local savegameFolderPath = g_currentMission.missionInfo.savegameDirectory;
	if savegameFolderPath == nil then
		savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), g_currentMission.missionInfo.savegameIndex)
	end
	savegameFolderPath = savegameFolderPath.."/"
	local key = "workplan"

	if fileExists(savegameFolderPath.."workplan.xml") then
		local xmlFile = loadXMLFile(key, savegameFolderPath.."workplan.xml");
		
		local i = 0	
		while true do
			local keyE = string.format(key .. ".fields.field(%d)", i)

			if not hasXMLProperty(xmlFile, keyE) then
				break
			end

			local newE = FieldEntry.new()
			newE.id = g_currentMission.workplan:getNextId()
			newE:loadFromXMLFile(xmlFile, keyE)
		
			table.insert(g_currentMission.workplan.fieldEntries, newE)
			
			i = i + 1
		end

		delete(xmlFile)
	end
end

function Workplan:getDataText(stateId)
    if stateId == FieldEntry.DATA.REQUIRED then
        return g_i18n:getText("data_required")
    elseif stateId == FieldEntry.DATA.NOT_REQUIRED then
        return g_i18n:getText("data_notRequired")
    elseif stateId == FieldEntry.DATA.COMPLETE then
        return g_i18n:getText("data_complete")
    elseif stateId == FieldEntry.DATA.Yes then
        return g_i18n:getText("data_yes")
    elseif stateId == FieldEntry.DATA.NO then
        return g_i18n:getText("data_no")        
    end
end

function Workplan:getSprayText(sprayId)
    if sprayId == FieldEntry.SPRAY.SPRAY_ARTIFICIAL_FERTILIZER then
        return g_i18n:getText("spray_artificialFertilizer")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_LIQUID then
        return g_i18n:getText("spray_liquide")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_SAWINGFERT then
        return g_i18n:getText("spray_sawingFert")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_MANURE then
        return g_i18n:getText("spray_manure")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_LIQUIDMANURE then
        return g_i18n:getText("spray_liquidmanure")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_DIGASTE then
        return g_i18n:getText("spray_digaste")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_INTERCROP then
        return g_i18n:getText("spray_intercrop")        
    end
end

function Workplan:getDataTextShort(stateId)
    if stateId == FieldEntry.DATA.REQUIRED then
        return g_i18n:getText("data_required_short")
    elseif stateId == FieldEntry.DATA.NOT_REQUIRED then
        return g_i18n:getText("data_notRequired_short")
    elseif stateId == FieldEntry.DATA.COMPLETE then
        return g_i18n:getText("data_complete_short")
    elseif stateId == FieldEntry.DATA.Yes then
        return g_i18n:getText("data_yes")
    elseif stateId == FieldEntry.DATA.NO then
        return g_i18n:getText("data_no")        
    end
end

function Workplan:getSprayTextShort(sprayId)
    if sprayId == FieldEntry.SPRAY.SPRAY_ARTIFICIAL_FERTILIZER then
        return g_i18n:getText("spray_artificialFertilizer_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_LIQUID then
        return g_i18n:getText("spray_liquide_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_SAWINGFERT then
        return g_i18n:getText("spray_sawingFert_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_MANURE then
        return g_i18n:getText("spray_manure_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_LIQUIDMANURE then
        return g_i18n:getText("spray_liquidmanure_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_DIGASTE then
        return g_i18n:getText("spray_digaste_short")
    elseif sprayId == FieldEntry.SPRAY.SPRAY_INTERCROP then
        return g_i18n:getText("spray_intercrop_short")        
    end
end

-- from Courseplay
function Workplan.fixInGameMenu(frame,pageName,uvs,position,predicateFunc)
	local inGameMenu = g_gui.screenControllers[InGameMenu]

	-- remove all to avoid warnings
	for k, v in pairs({pageName}) do
		inGameMenu.controlIDs[v] = nil
	end

	inGameMenu:registerControls({pageName})

	
	inGameMenu[pageName] = frame
	inGameMenu.pagingElement:addElement(inGameMenu[pageName])

	inGameMenu:exposeControlsAsFields(pageName)

	for i = 1, #inGameMenu.pagingElement.elements do
		local child = inGameMenu.pagingElement.elements[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.elements, i)
			table.insert(inGameMenu.pagingElement.elements, position, child)
			break
		end
	end

	for i = 1, #inGameMenu.pagingElement.pages do
		local child = inGameMenu.pagingElement.pages[i]
		if child.element == inGameMenu[pageName] then
			table.remove(inGameMenu.pagingElement.pages, i)
			table.insert(inGameMenu.pagingElement.pages, position, child)
			break
		end
	end

	inGameMenu.pagingElement:updateAbsolutePosition()
	inGameMenu.pagingElement:updatePageMapping()
	
	inGameMenu:registerPage(inGameMenu[pageName], position, predicateFunc)
	local iconFileName = Utils.getFilename('images/menuIcon.dds', Workplan.dir)
	inGameMenu:addPageTab(inGameMenu[pageName],iconFileName, GuiUtils.getUVs(uvs))
	inGameMenu[pageName]:applyScreenAlignment()
	inGameMenu[pageName]:updateAbsolutePosition()

	for i = 1, #inGameMenu.pageFrames do
		local child = inGameMenu.pageFrames[i]
		if child == inGameMenu[pageName] then
			table.remove(inGameMenu.pageFrames, i)
			table.insert(inGameMenu.pageFrames, position, child)
			break
		end
	end

	inGameMenu:rebuildTabList()
end

addModEventListener(Workplan)


function Workplan:sendInitialClientState(connection, user, farm)
	connection:sendEvent(InitialWorkplanEvent.new())
end

FSBaseMission.sendInitialClientState = Utils.appendedFunction(FSBaseMission.sendInitialClientState, Workplan.sendInitialClientState)

