--
-- FS22 - FieldEntry
--
-- @Interface: 1.2.0.0 b14651
-- @Author: KR-Softwares
-- @Date: 26.02.2022
-- @Version: 1.0.0.0
--
-- @Support: kr-softwares.com
--
-- Changelog:
-- 	v1.0.0.0 (26.02.2022):
--


FieldEntry = {}
local FieldEntry_mt = Class(FieldEntry)

FieldEntry.DATA = {
	REQUIRED = 1,
	NOT_REQUIRED = 2,
	COMPLETE = 3,
	Yes = 4,
	NO = 5,
}

FieldEntry.SPRAY = {
	SPRAY_ARTIFICIAL_FERTILIZER = 1,
	SPRAY_LIQUID = 2,
	SPRAY_SAWINGFERT = 3,
	SPRAY_MANURE = 4,
	SPRAY_LIQUIDMANURE = 5,
	SPRAY_DIGASTE = 6,
	SPRAY_INTERCROP = 7,
}

function FieldEntry.new(customMt)
	local self = {}

	setmetatable(self, customMt or FieldEntry_mt)

    self.id = 0
    self.fieldId = 0
    self.farmId = 0
    self.currentFruit = 0
    self.plannedFruit = 0
    self.stateLime = FieldEntry.DATA.NOT_REQUIRED
    self.stateMulching = FieldEntry.DATA.NOT_REQUIRED
    self.statePlow = FieldEntry.DATA.NOT_REQUIRED
    self.stateRoller = FieldEntry.DATA.NOT_REQUIRED
    self.stateFert1_type = FieldEntry.SPRAY.SPRAY_ARTIFICIAL_FERTILIZER
    self.stateFert1_state = FieldEntry.DATA.NO
    self.stateFert2_type = FieldEntry.SPRAY.SPRAY_ARTIFICIAL_FERTILIZER
    self.stateFert2_state = FieldEntry.DATA.NO
    self.stateWeed_grooming = FieldEntry.DATA.NOT_REQUIRED
    self.stateWeed_spray = FieldEntry.DATA.NOT_REQUIRED
    self.stateStone = FieldEntry.DATA.NOT_REQUIRED 

    return self
end

function FieldEntry:makeCopy()
    local copy = FieldEntry.new()
    copy.id = self.id
    copy.fieldId = self.fieldId
    copy.farmId = self.farmId
    copy.currentFruit = self.currentFruit
    copy.plannedFruit = self.plannedFruit
    copy.stateLime = self.stateLime
    copy.stateMulching = self.stateMulching
    copy.statePlow = self.statePlow
    copy.stateRoller = self.stateRoller
    copy.stateFert1_type = self.stateFert1_type
    copy.stateFert1_state = self.stateFert1_state
    copy.stateFert2_type = self.stateFert2_type
    copy.stateFert2_state = self.stateFert2_state
    copy.stateWeed_grooming = self.stateWeed_grooming
    copy.stateWeed_spray = self.stateWeed_spray
    copy.stateStone = self.stateStone
    return copy
end

function FieldEntry:delete()
    
end

function FieldEntry:saveToXmlFile(xmlFile, key)      
	setXMLInt(xmlFile, key.."#fieldId", self.fieldId)
	setXMLInt(xmlFile, key.."#farmId", self.farmId)
	setXMLInt(xmlFile, key.."#currentFruit", self.currentFruit)
	setXMLInt(xmlFile, key.."#plannedFruit", self.plannedFruit)
	setXMLInt(xmlFile, key.."#stateLime", self.stateLime)
	setXMLInt(xmlFile, key.."#stateMulching", self.stateMulching)
	setXMLInt(xmlFile, key.."#statePlow", self.statePlow)
	setXMLInt(xmlFile, key.."#stateRoller", self.stateRoller)
	setXMLInt(xmlFile, key.."#stateFert1_type", self.stateFert1_type)
	setXMLInt(xmlFile, key.."#stateFert1_state", self.stateFert1_state)
	setXMLInt(xmlFile, key.."#stateFert2_type", self.stateFert2_type)
	setXMLInt(xmlFile, key.."#stateFert2_state", self.stateFert2_state)
	setXMLInt(xmlFile, key.."#stateWeed_grooming", self.stateWeed_grooming)
	setXMLInt(xmlFile, key.."#stateWeed_spray", self.stateWeed_spray)
	setXMLInt(xmlFile, key.."#stateStone", self.stateStone)    
end

function FieldEntry:loadFromXMLFile(xmlFile, key)
    self.fieldId = getXMLInt(xmlFile, key.."#fieldId")
    self.farmId = getXMLInt(xmlFile, key.."#farmId")
    self.currentFruit = getXMLInt(xmlFile, key.."#currentFruit")
    self.plannedFruit = getXMLInt(xmlFile, key.."#plannedFruit")
    self.stateLime = getXMLInt(xmlFile, key.."#stateLime")
    self.stateMulching = getXMLInt(xmlFile, key.."#stateMulching")
    self.statePlow = getXMLInt(xmlFile, key.."#statePlow")
    self.stateRoller = getXMLInt(xmlFile, key.."#stateRoller")
    self.stateFert1_type = getXMLInt(xmlFile, key.."#stateFert1_type")
    self.stateFert1_state = getXMLInt(xmlFile, key.."#stateFert1_state")
    self.stateFert2_type = getXMLInt(xmlFile, key.."#stateFert2_type")
    self.stateFert2_state = getXMLInt(xmlFile, key.."#stateFert2_state")
    self.stateWeed_grooming = getXMLInt(xmlFile, key.."#stateWeed_grooming")
    self.stateWeed_spray = getXMLInt(xmlFile, key.."#stateWeed_spray")
    self.stateStone = Utils.getNoNil(getXMLInt(xmlFile, key.."#stateStone"), FieldEntry.DATA.NOT_REQUIRED)
end

function FieldEntry:writeStream(streamId, connection) 
    streamWriteInt32(streamId, self.id)
    streamWriteInt32(streamId, self.fieldId)
    streamWriteInt32(streamId, self.farmId)
    streamWriteInt32(streamId, self.currentFruit)
    streamWriteInt32(streamId, self.plannedFruit)
    streamWriteInt8(streamId, self.stateLime)
    streamWriteInt8(streamId, self.stateMulching)
    streamWriteInt8(streamId, self.statePlow)
    streamWriteInt8(streamId, self.stateRoller)
    streamWriteInt8(streamId, self.stateFert1_type)
    streamWriteInt8(streamId, self.stateFert1_state)
    streamWriteInt8(streamId, self.stateFert2_type)
    streamWriteInt8(streamId, self.stateFert2_state)
    streamWriteInt8(streamId, self.stateWeed_grooming)
    streamWriteInt8(streamId, self.stateWeed_spray)
    streamWriteInt8(streamId, self.stateStone)
end

function FieldEntry:readStream(streamId, connection)
    self.id = streamReadInt32(streamId)
    self.fieldId = streamReadInt32(streamId)
    self.farmId = streamReadInt32(streamId)
    self.currentFruit = streamReadInt32(streamId)
    self.plannedFruit = streamReadInt32(streamId)
    self.stateLime = streamReadInt8(streamId)
    self.stateMulching = streamReadInt8(streamId)
    self.statePlow = streamReadInt8(streamId)
    self.stateRoller = streamReadInt8(streamId)
    self.stateFert1_type = streamReadInt8(streamId)
    self.stateFert1_state = streamReadInt8(streamId)
    self.stateFert2_type = streamReadInt8(streamId)
    self.stateFert2_state = streamReadInt8(streamId)
    self.stateWeed_grooming = streamReadInt8(streamId)
    self.stateWeed_spray = streamReadInt8(streamId)
    self.stateStone = streamReadInt8(streamId)
end