WorkCameraTabbedMenu = {}
local WorkCameraTabbedMenu_mt = Class(WorkCameraTabbedMenu, TabbedMenu)

WorkCameraTabbedMenu.CONTROLS = {"generalSettingsFrame", "cameraSettingsFrame"}

WorkCameraTabbedMenu.TAB_UV = {
    GENERAL_SETTINGS = {64, 0, 64, 64},
    CAMERA_SETTINGS = {0, 0, 64, 64}
}

function WorkCameraTabbedMenu:new(messageCenter, l10n, inputManager, workCameraMain, modName)
    local self = TabbedMenu.new(nil, WorkCameraTabbedMenu_mt, messageCenter, l10n, inputManager)

    self:registerControls(WorkCameraTabbedMenu.CONTROLS)

    self.workCameraMain = workCameraMain
    self.selectedItem = nil
    self.i18n = g_i18n.modEnvironments[modName]

    self.defaultMenuButtonInfo = {}

    return self
end

function WorkCameraTabbedMenu:onGuiSetupFinished()
    WorkCameraTabbedMenu:superClass().onGuiSetupFinished(self)
    self:setupMenuPages()
end

function WorkCameraTabbedMenu:setupMenuPages()
    local ICONS_PATH = Utils.getFilename("ui/ui_icons.dds", self.workCameraMain.modDirectory)

    local orderedDefaultPages = {{self.generalSettingsFrame, self:makeIsGeneralSettingsVisiblePredicate(),
                                  WorkCameraTabbedMenu.TAB_UV.GENERAL_SETTINGS},
                                 {self.cameraSettingsFrame, self:makeIsCameraSettingsVisiblePredicate(),
                                  WorkCameraTabbedMenu.TAB_UV.CAMERA_SETTINGS}}

    for i, pageDef in ipairs(orderedDefaultPages) do
        local page, predicate, iconUVs = unpack(pageDef)

        if page ~= nil then
            self:registerPage(page, i, predicate)

            local normalizedUVs = GuiUtils.getUVs(iconUVs)

            self:addPageTab(page, ICONS_PATH, normalizedUVs)
        end
    end
end

function WorkCameraTabbedMenu:makeIsGeneralSettingsVisiblePredicate()
    return function()
        return true
    end
end

function WorkCameraTabbedMenu:makeIsCameraSettingsVisiblePredicate()
    return function()
        return true
    end
end

function WorkCameraTabbedMenu:onClose()
    self.generalSettingsFrame:onSave()
    self.cameraSettingsFrame:onSave()
    WorkCameraTabbedMenu:superClass().onClose(self)
end

function WorkCameraTabbedMenu:setupMenuButtonInfo()
    self.clickBackCallback = self:makeSelfCallback(self.onButtonBack)
    self.clickResetCallback = self:makeSelfCallback(self.onButtonReset)

    self.backButtonInfo = {
        inputAction = InputAction.MENU_BACK,
        text = self.i18n:getText("button_back"),
        callback = self.clickBackCallback
    }

    self.resetButtonInfo = {
        inputAction = InputAction.MENU_EXTRA_1,
        text = self.i18n:getText("button_reset"),
        callback = self.clickResetCallback
    }

    self.defaultMenuButtonInfo = {self.backButtonInfo, self.resetButtonInfo}

    self.defaultMenuButtonInfoByActions = {
        [InputAction.MENU_BACK] = self.defaultMenuButtonInfo[1],
        [InputAction.MENU_EXTRA_1] = self.defaultMenuButtonInfo[2]
    }

    self.defaultButtonActionCallbacks = {
        [InputAction.MENU_BACK] = self.clickBackCallback,
        [InputAction.MENU_EXTRA_1] = self.clickResetCallback
    }
end

function WorkCameraTabbedMenu:onButtonReset()
    if self.currentPage == nil then
        return
    end

    local function dialogCallback(yes, _)
        if yes then
            self.currentPage:onReset()
        end
    end

    g_gui:showYesNoDialog({
        text = self.i18n:getText("ui_WorkCamera_reset_msg"),
        callback = dialogCallback
    })
end
