WorkCameraCameraSettingsFrame = {}
local WorkCameraCameraSettingsFrame_mt = Class(WorkCameraCameraSettingsFrame, TabbedMenuFrameElement)

WorkCameraCameraSettingsFrame.MIN_FOV = 20
WorkCameraCameraSettingsFrame.MAX_FOV = 120
WorkCameraCameraSettingsFrame.MIN_CLIP = 0.01
WorkCameraCameraSettingsFrame.MAX_CLIP = 1000

WorkCameraCameraSettingsFrame.CONTROLS = {"fovValue", "nearClipValue", "farClipValue", "flipSetting",
                                          "settingsContainer", "boxLayout"}

function WorkCameraCameraSettingsFrame.new(workCameraMain, modName)
    local self = TabbedMenuFrameElement.new(nil, WorkCameraCameraSettingsFrame_mt)
    self:registerControls(WorkCameraCameraSettingsFrame.CONTROLS)

    self.workCameraMain = workCameraMain
    self.modName = modName
    self.selectedItem = nil
    self.i18n = g_i18n.modEnvironments[modName]

    return self
end

function WorkCameraCameraSettingsFrame:copyAttributes(src)
    WorkCameraCameraSettingsFrame:superClass().copyAttributes(self, src)

    self.workCameraMain = src.workCameraMain
    self.modName = src.modName
    self.i18n = g_i18n.modEnvironments[self.modName]
end

function WorkCameraCameraSettingsFrame:onFrameOpen()
    self.flipSetting:setTexts({self.i18n:getText("ui_no"), self.i18n:getText("ui_yes")})

    self:updateValues()

    WorkCameraCameraSettingsFrame:superClass().onFrameOpen(self)
end

function WorkCameraCameraSettingsFrame:updateValues()
    self.selectedItem = self.workCameraMain:getSelectedCameraItem()
    local cameraSettings = self.selectedItem:getCurrentWorkCamera()

    if cameraSettings ~= nil then
        self.fovValue:setText(tostring(MathUtil.round(math.deg(cameraSettings.fov, 2))))
        self.nearClipValue:setText(tostring(MathUtil.round(cameraSettings.nearClip, 2)))
        self.farClipValue:setText(tostring(MathUtil.round(cameraSettings.farClip, 2)))
        self.flipSetting:setState(cameraSettings.flip and 2 or 1)
    else
        self.fovValue:setText("")
        self.nearClipValue:setText("")
        self.farClipValue:setText("")
    end
end

function WorkCameraCameraSettingsFrame:onFrameClose()
    WorkCameraCameraSettingsFrame:superClass().onFrameClose(self)
end

function WorkCameraCameraSettingsFrame:onSave()
    if self.selectedItem ~= nil and self.selectedItem:getCurrentWorkCamera() ~= nil then
        local fov = tonumber(self.fovValue:getText())
        fov = MathUtil.clamp(fov, WorkCameraCameraSettingsFrame.MIN_FOV, WorkCameraCameraSettingsFrame.MAX_FOV)
        self.selectedItem:setCurrentWorkCameraFov(math.rad(fov))
        local nearClip = tonumber(self.nearClipValue:getText())
        local farClip = tonumber(self.farClipValue:getText())
        nearClip = MathUtil.clamp(nearClip, WorkCameraCameraSettingsFrame.MIN_CLIP,
            math.min(WorkCameraCameraSettingsFrame.MAX_CLIP, farClip))
        self.selectedItem:setCurrentWorkCameraNearClip(nearClip)
        farClip = MathUtil.clamp(farClip, math.max(WorkCameraCameraSettingsFrame.MIN_CLIP, nearClip),
            WorkCameraCameraSettingsFrame.MAX_CLIP)
        self.selectedItem:setCurrentWorkCameraFarClip(farClip)
        self.selectedItem:setCurrentWorkCameraFlip(self.flipSetting:getState() == 2)
        self.workCameraMain:updateCameraElement()
    end
end

function WorkCameraCameraSettingsFrame:onReset()
    self.selectedItem:resetCurrentWorkCamera()
    self:updateValues()
end

function WorkCameraCameraSettingsFrame:onFovChanged(element)
    local fov = tonumber(self.fovValue:getText())

    if fov == nil then
        self:onFovEsc(element)
        return
    end

    fov = MathUtil.clamp(fov, WorkCameraCameraSettingsFrame.MIN_FOV, WorkCameraCameraSettingsFrame.MAX_FOV)
    element:setText(tostring(fov))
    self.selectedItem:setCurrentWorkCameraFov(math.rad(fov))
end

function WorkCameraCameraSettingsFrame:onFovEsc(element)
    local cameraSettings = self.selectedItem:getCurrentWorkCamera()
    element:setText(tostring(math.deg(cameraSettings.fov)))
end

function WorkCameraCameraSettingsFrame:onNearClipChanged(element)
    local nearClip = tonumber(self.nearClipValue:getText())

    if nearClip == nil then
        self:onNearClipEsc(element)
        return
    end

    local farClip = tonumber(self.farClipValue:getText())
    nearClip = MathUtil.clamp(nearClip, WorkCameraCameraSettingsFrame.MIN_CLIP,
        math.min(WorkCameraCameraSettingsFrame.MAX_CLIP, farClip))
    element:setText(tostring(nearClip))
    self.selectedItem:setCurrentWorkCameraNearClip(nearClip)
end

function WorkCameraCameraSettingsFrame:onNearClipEsc(element)
    local cameraSettings = self.selectedItem:getCurrentWorkCamera()
    element:setText(tostring(cameraSettings.nearClip))
end

function WorkCameraCameraSettingsFrame:onFarClipChanged(element)
    local farClip = tonumber(self.farClipValue:getText())

    if farClip == nil then
        self:onFarClipEsc(element)
        return
    end

    local nearClip = tonumber(self.nearClipValue:getText())
    farClip = MathUtil.clamp(farClip, math.max(WorkCameraCameraSettingsFrame.MIN_CLIP, nearClip),
        WorkCameraCameraSettingsFrame.MAX_CLIP)
    element:setText(tostring(farClip))
    self.selectedItem:setCurrentWorkCameraFarClip(farClip)
end

function WorkCameraCameraSettingsFrame:onFarClipEsc(element)
    local cameraSettings = self.selectedItem:getCurrentWorkCamera()
    element:setText(tostring(cameraSettings.farClip))
end

-- fix input text 
function WorkCameraCameraSettingsFrame:onTextChanged(element, text)
    element:setText(text)
end
