-- Author:Oscar_8599, PixelFarm
-- Name:exportCameras(WorkCamera)
-- Description:
-- Icon:iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAIBJREFUOI3dUkEOgCAMK8aL3rz4Ex/Ql/cBPsgjXiAR3AQ92oSEbN3WUYD/gmS07jWCVySpO9ec8sQde0juVACD1yDGuEoKqXB5JYvkZuXzaSqQtFsu5DWuOXcFSYHk7D3uLd5NrOKu1wkHgKlSVfyHwkbPKktF5poFrSbeoE84ASx4TFl1rQZ7AAAAAElFTkSuQmCCAAAAAAAAAAAAAAAAAAAA+CsW8yAHAIC4zWLv/H8AADDOYu/8fwAAwMxi7/x/AACQzGLv/H8AAGjMYu/8fwAAAM1i7/x/AADoy2Lv/H8AAAjMYu/8fwAAKMxi7/x/AABIzGLv/H8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABUKQAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADqKwTzIAgAgBQAH1DgT9Ag6jppEKLYCAArMDCdGQAvQzpcAAAAAAAAAAAAAAAAAAAAAAAAAFAAMQAAAAAAAAAAABAAVXNlcnMAPAAJAAQA774AAAAAAAAAAC4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFUAcwBlAHIAcwAAABQAUAAxAAAAAAAAAAAAEAB0OG9zZQA8AAkABADvvgAAAAAAAAAALgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdAA4AG8AcwBlAAAAFAAAAAAAAAAAAAAAAOQr8vMgCQCAuM1i7/x/AAAwzmLv/H8AAMDMYu/8fwAAkMxi7/x/AABozGLv/H8AAADNYu/8fwAA6Mti7/x/AAAIzGLv/H8AACjMYu/8fwAASMxi7/x/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVCkAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA1ivg8yAKAIAUAB9Q4E/QIOo6aRCi2AgAKzAwnRkAL0M6XAAAAAAAAAAAAAAAAAAAAAAAAABQADEAAAAAAAAAAAAQAFVzZXJzADwACQAEAO++AAAAAAAAAAAuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABVAHMAZQByAHMAAAAUAFAAMQ==
-- Hide: no
local nNumSelectedNodes = getNumSelected()

function math.round(x, decimals)
    return math.floor(x * math.pow(10, decimals or 0) + 0.5) / math.pow(10, decimals or 0)
end

local function getIndexPath(node)
    local name = getName(node)
    local index = getChildIndex(node)
    local parent = getParent(node)
    local grandParent = getParent(parent)
    if grandParent == getChildAt(getRootNode(), 0) then
        local p_name, p_index = getIndexPath(parent)
        name = p_name .. name
        index = p_index .. index
    elseif parent ~= 0 and parent ~= getChildAt(getRootNode(), 0) then
        local p_name, p_index = getIndexPath(parent)
        name = p_name .. "|" .. name
        index = p_index .. "|" .. index
    else
        name = name .. ">"
        index = index .. ">"

    end
    return name, index
end

local xmlFile = openFileDialog("", "*.xml")
if xmlFile == "" then
    return
end
xmlFile = string.sub(xmlFile, 1, #xmlFile - 1)
local splitPatternMods = "FarmingSimulator2022\\mods\\(.+)"
local splitPatternDataSteam = "Farming Simulator 22\\(.+)"
local splitPatternData = "Farming Simulator 2022\\(.+)"
local itemXml = ""

if xmlFile ~= nil then
    itemXml = string.match(xmlFile, splitPatternMods) or string.match(xmlFile, splitPatternDataSteam) or
                  string.match(xmlFile, splitPatternData) or ""
end

itemXml = string.gsub(itemXml, "\\", "/")

if nNumSelectedNodes <= 0 then
    print("Nothing selected. Please select at least 1 camera.")
    return
end

local nSelectedRootNodeID = getSelection(0)
for i = 0, nNumSelectedNodes - 1 do
    local selectedNodeID = getSelection(i)
    if not getHasClassId(selectedNodeID, ClassIds.CAMERA) == true then
        print("Please select cameras only")
        return
    end
    if getParent(selectedNodeID) == getChildAt(getRootNode(), 0) then
        print(string.format("'%s' does not have a parent node", getName(selectedNodeID)))
        return
    end
end

print("\n==[COPY TEXT BELOW]=================")
print(string.format("\n    <workCameras itemXml=\"%s\">", itemXml))
for i = 0, nNumSelectedNodes - 1, 1 do
    local selectedNodeID = getSelection(i)
    local parent = getParent(selectedNodeID)
    local _, parentIndexPath = getIndexPath(parent)
    local transXraw, transYraw, transZraw = getTranslation(selectedNodeID)
    local rotXraw, rotYraw, rotZraw = getRotation(selectedNodeID)
    local fovRaw = math.deg(getFovY(selectedNodeID))
    local fov = math.round(fovRaw, 0)
    local transX = math.round(transXraw, 3)
    local transY = math.round(transYraw, 3)
    local transZ = math.round(transZraw, 3)
    local rotXdeg = math.deg(rotXraw)
    local rotYdeg = math.deg(rotYraw)
    local rotZdeg = math.deg(rotZraw)
    local rotX = math.round(rotXdeg, 3)
    local rotY = math.round(rotYdeg, 3)
    local rotZ = math.round(rotZdeg, 3)
    print(string.format("        <workCamera translation=\"%s %s %s\" rotation=\"%s %s %s\" node=\"%s\" fov=\"%s\" />",
        transX, transY, transZ, rotX, rotY, rotZ, parentIndexPath, fov));
end
print("    </workCameras>")
print("\n====================================")

