--
-- @author: Ziuta (DC: ja_pizgam)
-- @date: 11.11.2018
-- @version: 1.0.0.0 FS17
-- @edit: 08.04.2019 - v1.0.0.0 convert to FS19
-- @edit2: 19.11.2019 - v1.0.0.1 fix FPS drop
-- @edit3: 16.06.2022 - v1.0.0.0 convert to FS22: clean, fix and improve code
-- @edit4: 04.03.2023 - v1.0.1.0 code rewriting, better adaptation to tools
-- @edit5: 11.03.2023 - v1.1.0.0 code fixes (thx Wopster), better adaptation for small tools, support for headers/adapters
-- @edit6: 14.10.2023 - v1.2.0.0 fixed game crash issue (eg. OXBO DLC), 

local isOnlyUpDown = false -- true - only up-down rocking ***** false - right-left and up-down rocking
local cutterAlso = true -- true - activates rocking herers/adapters ***** false - deactivates rocking herers/adapters

local function loadInputAttacherJoint(self, superFunc, xmlFile, key, inputAttacherJoint, index)
    superFunc(self, xmlFile, key, inputAttacherJoint, index)
    local specSprayer = self.spec_sprayer
    local specMotorized = self.spec_motorized
    local specFC = self.spec_fertilizingCultivator
    local isImplement = inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_IMPLEMENT or false
    local isCutter = inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTER or inputAttacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTERHARVESTER or false

    if cutterAlso and isCutter then
        local data = {
            weight = self:getTotalMass(true),
            limitSpringZ = 700,
            limitDampingZ = 5,
            multiplier = self:getTotalMass(true)*2}
        
        data.limitSpringZ = data.limitSpringZ * data.multiplier
        data.limitDampingZ = data.limitDampingZ * data.multiplier
        inputAttacherJoint.rotLimitSpring = {0,0,data.limitSpringZ}
        inputAttacherJoint.rotLimitDamping = {0,0,data.limitDampingZ}
        return true
    end

    if isImplement then
        local isTPA = inputAttacherJoint.topReferenceNode ~= nil or false -- check it is three or two point attacher
        local haveStiffTPA = specMotorized ~= nil
        local isFertilizerSprayer =  specSprayer ~= nil and specFC == nil or false -- loaded spreader must have a stronger spring
        local data = {
            weight = self:getTotalMass(true),
            limitSpringYFront = 400,
            limitSpringYBack = 50,
            limitSpringZ = 50,
            limitDampingY = 5,
            limitDampingZ = 1,
            multiplier = self:getTotalMass(true)*10}

        data.limitSpringYBack = data.limitSpringYBack * data.multiplier
        data.limitSpringZ = data.limitSpringZ * data.multiplier
        if isFertilizerSprayer then
            data.limitSpringYBack = data.limitSpringYBack * data.multiplier * 2
            data.limitSpringZ = data.limitSpringZ * data.multiplier * 2
        end

        if isOnlyUpDown then
            data.limitSpringZ = 0
        else
            if isTPA then
                if data.weight > 0.5 then
                    data.limitDampingZ = data.limitDampingZ + 4
                end
            else
                data.limitDampingZ = data.limitDampingZ + 30
            end
        end
        inputAttacherJoint.transLimitSpring = {0,data.limitSpringYBack,data.limitSpringZ}
        inputAttacherJoint.transLimitDamping = {0,data.limitDampingY,data.limitDampingZ}
        return true
    end
    return superFunc(self, xmlFile, key, inputAttacherJoint, index)
end
Attachable.loadInputAttacherJoint = Utils.overwrittenFunction(Attachable.loadInputAttacherJoint, loadInputAttacherJoint)

local function createAttachmentJoint(self, implement, noSmoothAttach)
    local specMotorized = self.spec_motorized
    local specCultivator = self.spec_cultivator
    local spec = self.spec_attacherJoints
	local jointDesc = spec.attacherJoints[implement.jointDescIndex]
    local objectAttacherJoint = implement.object.spec_attachable.attacherJoint
    local wx, wy, wz = getWorldTranslation(jointDesc.jointTransform)
	local lx, ly, lz = worldToLocal(self.components[1].node, wx, wy, wz)
    local isFrontAttacher = lz > 0 or false

    if implement.object ~= nil then
        local spec = self.spec_attacherJoints
        local jointDesc = spec.attacherJoints[implement.jointDescIndex]
        local isTPA = jointDesc.bottomArm ~= nil
        if objectAttacherJoint ~= nil and specMotorized == nil then
            if specCultivator ~= nil then
                if isTPA then
                    objectAttacherJoint.transLimitSpring[3] = 0
                    objectAttacherJoint.transLimitDamping[3] = 0
                else
                    objectAttacherJoint.transLimitSpring[2] = 0
                    objectAttacherJoint.transLimitSpring[3] = 0
                    objectAttacherJoint.transLimitDamping[2] = 0
                    objectAttacherJoint.transLimitDamping[3] = 0
                end
            end            
        end
        if isFrontAttacher then
            objectAttacherJoint.transLimitSpring[3] = 0
            objectAttacherJoint.transLimitDamping[3] = 0
        end
     end
end
AttacherJoints.createAttachmentJoint = Utils.appendedFunction(AttacherJoints.createAttachmentJoint, createAttachmentJoint)

-- local function createAttachmentJoint(self, superFunc, implement, noSmoothAttach)
--     superFunc(self, implement, noSmoothAttach)
--     local specMotorized = self.spec_motorized
--     local specCultivator = self.spec_cultivator
--     local spec = self.spec_attacherJoints
-- 	local jointDesc = spec.attacherJoints[implement.jointDescIndex]
--     local objectAttacherJoint = implement.object.spec_attachable.attacherJoint
--     local wx, wy, wz = getWorldTranslation(jointDesc.jointTransform)
-- 	local lx, ly, lz = worldToLocal(self.components[1].node, wx, wy, wz)
--     local isFrontAttacher = lz > 0 or false

--     if implement.object ~= nil then
--         local spec = self.spec_attacherJoints
--         local jointDesc = spec.attacherJoints[implement.jointDescIndex]
--         local isTPA = jointDesc.bottomArm ~= nil
--         if objectAttacherJoint ~= nil and specMotorized == nil then
--             if specCultivator ~= nil then
--                 if isTPA then
--                     objectAttacherJoint.transLimitSpring[3] = 0
--                     objectAttacherJoint.transLimitDamping[3] = 0
--                 else
--                     objectAttacherJoint.transLimitSpring[2] = 0
--                     objectAttacherJoint.transLimitSpring[3] = 0
--                     objectAttacherJoint.transLimitDamping[2] = 0
--                     objectAttacherJoint.transLimitDamping[3] = 0
--                 end
--             end            
--         end
--         if isFrontAttacher then
--             objectAttacherJoint.transLimitSpring[3] = 0
--             objectAttacherJoint.transLimitDamping[3] = 0
--         end
--     end
--     return superFunc(self, implement, noSmoothAttach)
-- end
-- AttacherJoints.createAttachmentJoint = Utils.overwrittenFunction(AttacherJoints.createAttachmentJoint, createAttachmentJoint)

if not isOnlyUpDown then    
    local function updateAttacherJointGraphics(self, implement, dt, forceUpdate)
        if implement.object ~= nil then
            local spec = self.spec_attacherJoints
            local jointDesc = spec.attacherJoints[implement.jointDescIndex]

			if jointDesc.bottomArm ~= nil and self.spec_cultivator == nil then
                if jointDesc.bottomArm.rotationNode ~= nil and jointDesc.bottomArm.translationNode ~= nil then
					local attacherJoint = implement.object:getActiveInputAttacherJoint()
                    if jointDesc.bottomArm.rotationNode ~= jointDesc.bottomArm.translationNode then
                        -- ▼▼▼▼▼▼▼▼▼ Wopster ▼▼▼▼▼▼▼▼▼
                        if jointDesc.bottomArm.realTranslationNode == nil then
                            jointDesc.bottomArm.realTranslationNode = createTransformGroup("realTranslationNode")
                            -- Wopster: we only need to tell the scenegraph to link it once.
                            link(jointDesc.bottomArm.rotationNode, jointDesc.bottomArm.realTranslationNode)
                            link(jointDesc.bottomArm.realTranslationNode, jointDesc.bottomArm.translationNode)
                        end
                        -- ▲▲▲▲▲▲▲▲▲ Wopster ▲▲▲▲▲▲▲▲▲
                        local x, _, _ = worldToLocal(jointDesc.bottomArm.rotationNode, getWorldTranslation(attacherJoint.node))
                        setTranslation(jointDesc.bottomArm.realTranslationNode, x, 0, 0)
                    else
                        local x, _, _ = worldToLocal(jointDesc.bottomArm.rotationNode, getWorldTranslation(attacherJoint.node))
                        setTranslation(jointDesc.bottomArm.translationNode, x, 0, 0)
                    end
                end
            end
        end
    end

    AttacherJoints.updateAttacherJointGraphics = Utils.appendedFunction(AttacherJoints.updateAttacherJointGraphics, updateAttacherJointGraphics)
end