﻿--
-- REA Script
-- author: 900Hasse
-- date: 10.08.2022
--
-- V1.0.0.0
--
-----------------------------------------
-- TO DO
---------------
-- 
-- 

-----------------------------------------
-- KNOWN ISSUES
---------------
-- 
-- 

print("---------------------------")
print("----- REA by 900Hasse -----")
print("---------------------------")
READistantMotorSound = {};

function READistantMotorSound.prerequisitesPresent(specializations)
    return true
end;

function READistantMotorSound:loadMap(name)
end

function READistantMotorSound:deleteMap()
end


function READistantMotorSound:update(dt)
end;


function SoundManager:updateSampleAttributes(sample, force)
    if sample ~= nil then
        if sample.isIndoor ~= self.isIndoor or force then
            self:setCurrentSampleAttributes(sample, self.isIndoor)
            sample.isIndoor = self.isIndoor
        end

        local volumeFactor = self:getModifierFactor(sample, "volume")
        local pitchFactor = self:getModifierFactor(sample, "pitch")
        local lowpassGainFactor = self:getModifierFactor(sample, "lowpassGain")

		-------------------------------------------------------
		-- Added REA functionality
		if sample.IsMotor or sample.IsGearbox or sample.IsRetarder then
			local Volume, Pitch, Lowpass = READistantMotorSound:GetVolumePitchLowpassFactor(sample);
			volumeFactor = volumeFactor * Volume;
			pitchFactor = pitchFactor * Pitch;
			lowpassGainFactor = lowpassGainFactor * Lowpass;
		end;
		-------------------------------------------------------

        setSampleVolume(sample.soundSample, volumeFactor * self:getCurrentSampleVolume(sample))
        setSamplePitch(sample.soundSample, pitchFactor * self:getCurrentSamplePitch(sample))
        setSampleFrequencyFilter(sample.soundSample, 1.0, lowpassGainFactor * self:getCurrentSampleLowpassGain(sample), 0.0, sample.current.lowpassCutoffFrequency, 0.0, sample.current.lowpassResonance)
    end
end


function SoundManager:createAudioSource(sample, filename)
    if sample.soundNode ~= nil then
        delete(sample.soundNode)
    end

	-------------------------------------------------------
	-- REA check if sample should be affected by this mod
	-- DEBUG
	READistantMotorSound:PrintDebug("sample name= " .. sample.sampleName);
	-- Is motor
	sample.IsMotor = false;
	if 
		sample.sampleName == "motor(0)" or
		sample.sampleName == "motor(1)" or
		sample.sampleName == "motor(2)" or
		sample.sampleName == "motor(3)" or
		sample.sampleName == "motor(4)" or
		sample.sampleName == "motor(5)" or
		sample.sampleName == "motor(6)" or
		sample.sampleName == "motor(7)" or
		sample.sampleName == "motor(8)" or
		sample.sampleName == "motor(9)" or
		sample.sampleName == "motor(10)" 
		then
		-- Set is motor
		sample.IsMotor = true;
		-- Set sound distance
		sample.outerRadius = 300;
		-- DEBUG
		READistantMotorSound:PrintDebug("Is a motor sample");
	end;
	-- Is gearbox
	sample.IsGearbox = false;
	if 
		sample.sampleName == "gearbox(0)" or
		sample.sampleName == "gearbox(1)" or
		sample.sampleName == "gearbox(2)" or
		sample.sampleName == "gearbox(3)" or
		sample.sampleName == "gearbox(4)" or
		sample.sampleName == "gearbox(5)" or
		sample.sampleName == "gearbox(6)" or
		sample.sampleName == "gearbox(7)" or
		sample.sampleName == "gearbox(8)" or
		sample.sampleName == "gearbox(9)" or
		sample.sampleName == "gearbox(10)" 
		then
		sample.IsGearbox = true;
		-- Set sound distance
		sample.outerRadius = 150;
		-- DEBUG
		READistantMotorSound:PrintDebug("Is a gearbox sample");
	end;
	-- Is retarder
	sample.IsRetarder = false;
	if 
		sample.sampleName == "retarder(0)" or
		sample.sampleName == "retarder(1)" or
		sample.sampleName == "retarder(2)" or
		sample.sampleName == "retarder(3)" or
		sample.sampleName == "retarder(4)" or
		sample.sampleName == "retarder(5)" or
		sample.sampleName == "retarder(6)" or
		sample.sampleName == "retarder(7)" or
		sample.sampleName == "retarder(8)" or
		sample.sampleName == "retarder(9)" or
		sample.sampleName == "retarder(10)" 
		then
		sample.IsRetarder = true;
		-- Set sound distance
		sample.outerRadius = 150;
		-- DEBUG
		READistantMotorSound:PrintDebug("Is a retarder sample");
	end;
	-------------------------------------------------------

    sample.soundNode = createAudioSource(sample.sampleName, filename, sample.outerRadius, sample.innerRadius, sample.current.volume, sample.loops)
    sample.soundSample = getAudioSourceSample(sample.soundNode)

    self:onCreateAudioSource(sample)
end


-----------------------------------------------------------------------------------	
-- Get if object blocks the view of soundnode
-----------------------------------------------------------------------------------
function READistantMotorSound:GetVolumePitchLowpassFactor(sample)

	-- Status values
	local ObjectBlock = false;
	local Speed = 0;

	-- make sure sound is above ground level
	local MinHeight = 0;
	if sample.IsMotor then
		MinHeight = 1.5;
	elseif sample.IsGearbox then
		MinHeight = 1.0;
	elseif sample.IsRetarder then
		MinHeight = 1.0;
	end;

	local SampleX, SampleY, SampleZ= getWorldTranslation(sample.soundNode);
	local TerrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, SampleX, SampleY, SampleZ);
	SampleY = math.max(TerrainHeight+MinHeight,SampleY);

	-- Get distance
	local CamX, CamY, CamZ = getWorldTranslation(getCamera());
	local diffX = CamX - SampleX;
	local diffY = CamY - SampleY;
	local diffZ = CamZ - SampleZ;
	local Distance = MathUtil.vector3Length(diffX, diffY, diffZ);

	-----------------------------------------
	-- Check if object blocks the path from sound source and player
	if Distance > 10 and Distance < sample.outerRadius * 1.1 then
		-- Initialize racast node
		if sample.RaycastNode == nil then
			sample.RaycastNode = READistantMotorSound:CreateNode(g_currentMission.terrainRootNode,0, 0, 0,"RaycastNode")
		end;
		local Volume = 1;
		local Lowpass = 1;

		-- Max distance for raycast
		local MaxDistance = Distance - 6;

		-- Calculate rotation
		local targetRotationX = math.atan2(diffY, MathUtil.vector3Length(diffX, 0, diffZ)) + math.pi;
		local targetRotationY = math.atan2(diffX, diffZ);
		local targetRotationZ = 0;

		-------------- DEBUG --------------
		if READistantMotorSound.Debug then
			renderText(0.2, 0.20, 0.03,"Dist: " .. Distance);
			renderText(0.2, 0.40, 0.03,"Diff X: " .. diffX);
			renderText(0.2, 0.45, 0.03,"Diff Y: " .. diffY);
			renderText(0.2, 0.50, 0.03,"Diff Z: " .. diffZ);
			renderText(0.2, 0.55, 0.03,"Rot X: " .. targetRotationX);
			renderText(0.2, 0.60, 0.03,"Rot Y: " .. targetRotationY);
		end;
		-------------- DEBUG --------------

		-- Set position of raycast node
		setTranslation(sample.RaycastNode,CamX, CamY, CamZ);
		setRotation(sample.RaycastNode,-targetRotationX,targetRotationY,targetRotationZ);
		-- Get direction
		local dirX, dirY, dirZ = localDirectionToWorld(sample.RaycastNode, 0, 0, 1);

		-- Check if there is another object 
		local raycastMask = 32+64+128+256+4096;
		local NumberOfOjects = raycastAll(CamX, CamY, CamZ, dirX, dirY, dirZ, "ObjectRaycastCallback", MaxDistance, nil, raycastMask, true);
		-- Object found, adjust
		if NumberOfOjects ~= nil then
			if NumberOfOjects > 0 then
				ObjectBlock = true;
				Volume = Volume - 0.50;
				Lowpass = Lowpass - 0.50;
			end;
		end;
		-- Smoothe value
		sample.VolumeFactor = READistantMotorSound:SmootheValue(sample.VolumeFactor,Volume);
		sample.LowpassFactor = READistantMotorSound:SmootheValue(sample.LowpassFactor,Lowpass);
	else
		sample.VolumeFactor = 1;
		sample.LowpassFactor = 1;
	end;

	-----------------------------------------
	-- Get speed differance of sound source and player to add doppler effect
	if Distance > 1 and Distance < sample.outerRadius * 1.1  then
		-- Initialize distance
		if sample.LastDistance == nil then
			sample.LastDistance = Distance;
			sample.LastTime = 0;
		end;

		-- Read current time
		local currentTime = g_currentMission.environment.dayTime;
		-- Get in game time differance since last update
		local TimeDiff = math.max(0,currentTime - sample.LastTime);

		-- Get differance in distance from last call
		local DistanceDiff = Distance - sample.LastDistance;

		-- calculate speed differance
		if TimeDiff > 0 and sample.LastTime ~= 0 then
			Speed = DistanceDiff / (TimeDiff / 1000);
		end;

		-- Save for next call
		sample.LastDistance = Distance;
		sample.LastTime = currentTime;

		-- Calculate effect on pitch
		-- Smoothe value
		sample.PitchFactor = READistantMotorSound:SmootheValueFast(sample.PitchFactor,1 - (Speed / 300))
	else
		sample.PitchFactor = 1;
	end;

	-------------- DEBUG --------------
	if READistantMotorSound.Debug then
		local Status = "No Block"
		if ObjectBlock then
			Status = "Block"
		end;
		if sample.DistDebugNode == nil then
			sample.DistDebugNode = READistantMotorSound:CreateNode(g_currentMission.terrainRootNode,0, 0, 0,"SampleDebug")
		end;
		setTranslation(sample.DistDebugNode,SampleX, SampleY, SampleZ);
		DebugUtil.drawDebugNode(sample.DistDebugNode,Status .. " D=" .. READistantMotorSound:RoundValue(Distance) .. " S=" .. READistantMotorSound:RoundValue(Speed), false)
		if sample.RaycastNode ~= nil then
			setTranslation(sample.RaycastNode,CamX, CamY-0.5, CamZ+1);
			DebugUtil.drawDebugNode(sample.RaycastNode,"XR", false)
		end;
	end;
	-------------- DEBUG --------------

	-- Return volume and pitch factors
	return sample.VolumeFactor,sample.PitchFactor,sample.LowpassFactor;
end;


-----------------------------------------------------------------------------------	
-- Function to smoothe value
-----------------------------------------------------------------------------------
function READistantMotorSound:SmootheValue(SmoothedValue,RealValue)
	-- If no smoothevalue use the real value
	if SmoothedValue == nil then
		ActValue = RealValue;
	else
		ActValue = SmoothedValue;
	end;
	-- Return the smoothed value
	return (ActValue*0.8)+(RealValue*0.2);
end


-----------------------------------------------------------------------------------	
-- Function to smoothe value
-----------------------------------------------------------------------------------
function READistantMotorSound:SmootheValueFast(SmoothedValue,RealValue)
	-- If no smoothevalue use the real value
	if SmoothedValue == nil then
		ActValue = RealValue;
	else
		ActValue = SmoothedValue;
	end;
	-- Return the smoothed value
	return (ActValue*0.6)+(RealValue*0.4);
end


-----------------------------------------------------------------------------------	
-- Raycast callback function
-----------------------------------------------------------------------------------
function READistantMotorSound:ObjectRaycastCallback(hitObjectId, x, y, z, distance)
	return false
end


-----------------------------------------------------------------------------------	
-- Function to create node
-----------------------------------------------------------------------------------
function READistantMotorSound:CreateNode(ParentNode,x,y,z,Name)
	-- Create groundtype node
	local Node = createTransformGroup(Name)
	link(ParentNode, Node);
	setTranslation(Node,x,y,z);
	setRotation(Node,0,0,0);
	setScale(Node, 1, 1, 1);
	return Node;
end


-----------------------------------------------------------------------------------	
-- Function to round value, delete decimals
-----------------------------------------------------------------------------------
function READistantMotorSound:RoundValue(x)
	return x>=0 and math.floor(x+0.5) or math.ceil(x-0.5)
end


-----------------------------------------------------------------------------------	
-- Function to print debug values
-----------------------------------------------------------------------------------
function READistantMotorSound:PrintDebug(text)
	if READistantMotorSound.Debug then
		print(text);
	end;
end


if READistantMotorSound.ModActivated == nil then

	addModEventListener(READistantMotorSound);
	READistantMotorSound.ModActivated = true;
	READistantMotorSound.Debug = false;
	READistantMotorSound.FilePath = g_currentModDirectory;
	print("mod activated")

end;
