PushRoundBales = {}

source(g_currentModDirectory.."PushBaleEvent.lua");

local CurrentBale = nil
local PushEventId = nil
local PullEventId = nil

function PushRoundBales:update()

    CurrentBale = nil

    local x, y, z = localToWorld(g_currentMission.player.cameraNode, 0, 0, 1.0)
    local dx, dy, dz = localDirectionToWorld(g_currentMission.player.cameraNode, 0, 0, -1)
    raycastAll(x, y, z, dx, dy, dz, "raycastCallback", 3, self)

    if CurrentBale ~= nil then

        if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT) or getInputButton(Input.BUTTON_11,0) == 1 then
            g_client:getServerConnection():sendEvent(PushBaleEvent.new(true));
        end
        
        if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) or getInputButton(Input.BUTTON_12,0) == 1 then
            g_client:getServerConnection():sendEvent(PushBaleEvent.new(false));
        end

    end
end

function PushRoundBales:raycastCallback(hitObjectId)
    local ObjectName = getName(hitObjectId)
    if ObjectName == "roundbale125" then
        CurrentBale = hitObjectId
        return false
    end
    if ObjectName == "roundbale150" then
        CurrentBale = hitObjectId
        return false
    end
    if ObjectName == "roundbale180" then
        CurrentBale = hitObjectId
        return false
    end
    return true
end

function PushRoundBales:loadMap(savegame)
    if g_currentMission:getIsClient() then
        Player.registerActionEvents =
            Utils.appendedFunction(Player.registerActionEvents, PushRoundBales.registerActionEvents)
        Player.updateActionEvents = Utils.appendedFunction(Player.updateActionEvents, PushRoundBales.updateActionEvents)
    end
end

function PushRoundBales:registerActionEvents() 
    if self.isClient then
        PushRoundBales.events = {}
		local valid1, eventId1 = g_inputBinding:registerActionEvent(InputAction.PUSHACTION,"PUSHACTION",PushRoundBales.PushPalletEvent,false,true,false,true)
        if valid1 then
            table.insert(PushRoundBales.events, eventId1);
            g_inputBinding:setActionEventTextVisibility(eventId1, true);
            PushEventId = eventId1;
        end
        local valid2, eventId2 = g_inputBinding:registerActionEvent(InputAction.PULLACTION,"PULLACTION",PushRoundBales.PushPalletEvent,false,true,false,true)
        if valid2 then
            table.insert(PushRoundBales.events, eventId2);
            g_inputBinding:setActionEventTextVisibility(eventId2, true);
            PullEventId = eventId2;
        end
    end
end

function PushRoundBales:updateActionEvents()
	if PushEventId ~= nil and PullEventId ~= nil then
    g_inputBinding:setActionEventActive(PushEventId, CurrentBale ~= nil)
	g_inputBinding:setActionEventActive(PullEventId, CurrentBale ~= nil)
	end;
end

function PushRoundBales:PushPalletEvent(actionName, keyStatus, arg3, arg4, arg5)
end

function PushRoundBales:PullPalletEvent(actionName, keyStatus, arg3, arg4, arg5)
end

addModEventListener(PushRoundBales)
