PushBaleEvent = {}

local PushBaleEvent_mt = Class(PushBaleEvent, Event)
InitEventClass(PushBaleEvent, "PushBaleEvent")

function PushBaleEvent.emptyNew()
    local self = Event.new(PushBaleEvent_mt)

    return self
end

function PushBaleEvent.new(Direction)
    local self = PushBaleEvent.emptyNew()
    self.Direction = Direction
    return self
end

function PushBaleEvent:readStream(streamId, connection)
    self.Direction = streamReadBool(streamId)
    self:run(connection)
end

function PushBaleEvent:writeStream(streamId, connection)
    streamWriteBool(streamId, self.Direction)
end

function PushBaleEvent:run(connection)
    if not connection:getIsServer() then
        local RemotePlayer = g_currentMission:getPlayerByConnection(connection)

        local x, y, z = localToWorld(RemotePlayer.cameraNode, 0, 0, 1.0)
        local dx, dy, dz = localDirectionToWorld(RemotePlayer.cameraNode, 0, 0, -1)
        raycastAll(x, y, z, dx, dy, dz, "raycastCallback", 3, self)


if self.CurrentBale ~= nil then

    local vdir = 0

    if self.Direction == true then 
        vdir = 1;
    end;

    if self.Direction == false then 
        vdir = -1;
    end;

    local ObjectName = getName(self.CurrentBale)

    if ObjectName == "roundbale125" then
        Velocity = 2;
    end
    if ObjectName == "roundbale150" then
        Velocity = 1.5;
    end
    if ObjectName == "roundbale180" then
        Velocity = 1;
    end


        local Rx, Ry, Rz = localDirectionToWorld(self.CurrentBale, 0, 0, Velocity * vdir);
        setAngularVelocity(self.CurrentBale, Rx, Ry, Rz);
end
    end
end

function PushBaleEvent:raycastCallback(hitObjectId)
    local ObjectName = getName(hitObjectId)
    if ObjectName == "roundbale125" then
        self.CurrentBale = hitObjectId
        return false
    end
    if ObjectName == "roundbale150" then
        self.CurrentBale = hitObjectId
        return false
    end
    if ObjectName == "roundbale180" then
        self.CurrentBale = hitObjectId
        return false
    end
    return true
end