OnlySleepAtNight = {}

-- 1 hour is 3600000 ms
MORNING_MS = 25200000 -- 7 hours 
EVENING_MS = 72000000 -- 20 hours

-- Override SleepManager.getCanSleep with our own function
function OnlySleepAtNight:loadMap()
	SleepManager.getCanSleep = Utils.overwrittenFunction(SleepManager.getCanSleep, OnlySleepAtNight.getCanSleep)
end


-- Override
function OnlySleepAtNight:getCanSleep()
	local currentTime = g_currentMission.environment.dayTime
	
	if currentTime > MORNING_MS and currentTime < EVENING_MS  then
		return false
	else
		return true
	end
end

addModEventListener(OnlySleepAtNight)
