-- Measure Script for FarmingSimulator 2022
-- @author      Danielmodding
-- @version     v1.0.0.0 Release Giants FarmingSimulator Modhub
-- @version		v1.0.0.2 Bug Fixing, Cleanup
-- @date        12/02/2022
-- @info		Measure Script for FarmingSimulator 2022


measure = {
	active = nil,
}
addModEventListener(measure);

function measure:update(dt)
	if measure.active then
	local player = nil;
		if g_currentMission.player ~= nil then
			player = g_currentMission.player.rootNode;
		end;
		if g_currentMission.controlledVehicle ~= nil then
			player = g_currentMission.controlledVehicle.rootNode;
		end;
		if player ~= nil then
			local bX, bY, bZ = getWorldTranslation(player);
			local c2 = ( math.pow( (aX1 - bX), 2 ) + math.pow( (aZ1 - bZ), 2 ) );
			distance = math.sqrt( ( c2 + math.abs( (aY1 - bY), 2 ) ) );
			if measure.unitMetric == false then
				distance = distance * 3.28;
			end
			distance = math.floor(distance * 100 + 0.5) / 100;
		else
			measure.active = false;
		end;
	end;
end

function measure.prerequisitesPresent(specializations)
	return true;
end

function measure:loadMap(name)
	if (measure.active == nil) then
		measure.active = false;
	end;
	measure.unitMetric = true
end;

function measure:mouseEvent(posX, posY, isDown, isUp, button)
	if isDown and button == 3 and Input.isKeyPressed(Input.KEY_lalt) then
		if(not measure.active) then
			local player = nil;
			if g_currentMission.player ~= nil then
				player = g_currentMission.player.rootNode;
			end;
			if g_currentMission.controlledVehicle ~= nil then
				player = g_currentMission.controlledVehicle.rootNode;
			end;
			if player ~= nil then
				aX1, aY1, aZ1 = getWorldTranslation(player);
				measure.active = true;
			else
				print("Measure Mod Error");
			end;
		else
			measure.active = false;
		end;
	end;
		-- MouseWheelClick
		if isDown and button == 2 then
			if measure.active then
				measure.unitMetric = not measure.unitMetric
			end
		end
end

function measure:draw()
	if measure.active then
		drawDebugLine(aX1, aY1 - 1, aZ1, 0, 0, 0, aX1, aY1 + 2, aZ1, 0, 0, 0);
		drawDebugLine(aX1-0.1, aY1, aZ1, 1, 0, 0, aX1+0.1, aY1, aZ1, 1, 0, 0);
		drawDebugLine(aX1, aY1, aZ1-0.1, 1, 0, 0, aX1, aY1, aZ1+0.1, 1, 0, 0);
		
		if measure.unitMetric == false then
			g_currentMission:addExtraPrintText(distance .. " ft");
		else
			g_currentMission:addExtraPrintText(distance .. " m");
		end
	end;
end

function measure:keyEvent(unicode, sym, modifier, isDown)
end

function measure:deleteMap()
end
