-- by Frvetz
-- Contact: https://github.com/Frvetz/FS22_ManualWipers
-- Date 30.10.2022


registerManualWipers = {}
registerManualWipers.specName = "ManualWipers"
registerManualWipers.className = "ManualWipers"
registerManualWipers.fileName = g_currentModDirectory.."ManualWipers.lua"
registerManualWipers.ModDir = g_currentModDirectory

function registerManualWipers.registerSpecialization()

	local specName = registerManualWipers.specName

	if g_specializationManager:getSpecializationByName(specName) == nil then
		g_specializationManager:addSpecialization(registerManualWipers.specName, registerManualWipers.className, registerManualWipers.fileName, "")

		for vehicleType, vehicle in pairs(g_vehicleTypeManager.types) do

			if vehicle ~= nil and vehicleType ~= "locomotive" and vehicleType ~= "ConveyorBelt" and vehicleType ~= "woodCrusherTrailerDrivable" then

				local isDrivable = false;
				--local hasTBO = false;
				local hasNotEVM = true;

				for name, spec in pairs(vehicle.specializationsByName) do
					if name == "drivable" then
						isDrivable = true;
					--elseif name == "tensionBeltObject" then
					--	hasTBO = true;
					elseif name == "ManualWipers" then
						hasNotEVM = false;
					end
				end
										-- or hasTBO
				if hasNotEVM and isDrivable then
					print("  adding ManualWipers to vehicleType '"..tostring(vehicleType).."'")

					local specObject = g_specializationManager:getSpecializationObjectByName(specName);

					vehicle.specializationsByName[specName] = specObject;
					table.insert(vehicle.specializationNames, specName);
					table.insert(vehicle.specializations, specObject);
				end
			end
		end
	end
end
TypeManager.finalizeTypes = Utils.appendedFunction(TypeManager.finalizeTypes, registerManualWipers.registerSpecialization)

-- make localizations available
local i18nTable = getfenv(0).g_i18n
for l18nId,l18nText in pairs(g_i18n.texts) do
  i18nTable:setText(l18nId, l18nText)
end