-- by Frvetz
-- Contact: https://github.com/Frvetz/FS22_ManualWipers
-- Date 30.10.2022

source(registerManualWipers.ModDir.."events/SyncClientServerEvent.lua")

ManualWipers = {};
ManualWipers.l10nEnv = "FS22_ManualWipers";

function ManualWipers.prerequisitesPresent(specializations)
	return true;
end;

function ManualWipers.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", ManualWipers);
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", ManualWipers);
	SpecializationUtil.registerEventListener(vehicleType, "onReadStream", ManualWipers);
	SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", ManualWipers);
	SpecializationUtil.registerEventListener(vehicleType, "onReadUpdateStream", ManualWipers);
	SpecializationUtil.registerEventListener(vehicleType, "onWriteUpdateStream", ManualWipers);
end;

function ManualWipers:onRegisterActionEvents()
    if self.getIsEntered ~= nil and self:getIsEntered() then
		ManualWipers.actionEvents = {}
		self:clearActionEventsTable(ManualWipers.actionEvents)
		if self:getIsActiveForInput(true) then
			_, ManualWipers.wiperEvent = self:addActionEvent(ManualWipers.actionEvents, 'TOGGLE_WIPER', self, ManualWipers.ToggleWiper, false, true, false, true, nil)
			g_inputBinding:setActionEventTextPriority(ManualWipers.wiperEvent, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(ManualWipers.wiperEvent, false)
		end
	end
end

function ManualWipers:onLoad(savegame)
	local spec = self.spec_ManualWipers
	
	spec.ButtonHit = 0
	
	spec.dirtyFlag = self:getNextDirtyFlag()
end

function ManualWipers:onReadStream(streamId, connection)
	local spec = self.spec_ManualWipers
	
	spec.ButtonHit = streamReadInt32(streamId)
end

function ManualWipers:onWriteStream(streamId, connection)
	local spec = self.spec_ManualWipers
	
	streamWriteInt32(streamId, spec.ButtonHit)
end

function ManualWipers:onReadUpdateStream(streamId, timestamp, connection)
	if not connection:getIsServer() then
		local spec = self.spec_ManualWipers
		
		if streamReadBool(streamId) then
			if spec ~= nil then
				spec.ButtonHit = streamReadInt32(streamId)
			end
		end
	end
end

function ManualWipers:onWriteUpdateStream(streamId, connection, dirtyMask)
	if connection:getIsServer() then
		local spec = self.spec_ManualWipers
		if spec ~= nil then
			if spec.dirtyFlag ~= nil then
				if streamWriteBool(streamId, bitAND(dirtyMask, spec.dirtyFlag) ~= 0) then
					streamWriteInt32(streamId, spec.ButtonHit)
				end
			else 
				streamWriteBool(streamId, false)
			end
		end
	end
end

function ManualWipers.ToggleWiper(self, actionName)
	local spec = self.spec_ManualWipers
	
	if actionName == "TOGGLE_WIPER" then
		spec.ButtonHit = spec.ButtonHit + 1
		if spec.ButtonHit > 3 then
			spec.ButtonHit = 0
		end

		for _, wiper in pairs(self.spec_wipers.wipers) do
			if self.spec_ManualWipers.ButtonHit == 2 then
				wiper.nextStartTime = wiper.nextStartTime - 1400
			elseif self.spec_ManualWipers.ButtonHit == 3 then
				wiper.nextStartTime = wiper.nextStartTime - 599
			end
		end
		
		self:raiseDirtyFlags(spec.dirtyFlag)
		
		if g_server ~= nil then
			g_server:broadcastEvent(SyncClientServerEvent.new(self, spec.ButtonHit), nil, nil, self)
		else
			g_client:getServerConnection():sendEvent(SyncClientServerEvent.new(self, spec.ButtonHit))
		end
	end
end

function ManualWipers:onUpdateTick(superFunc, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_wipers
    if self:getIsControlled() then
       -- spec.lastRainScale = g_currentMission.environment.weather:getRainFallScale()
        for _, wiper in pairs(spec.wipers) do
            local stateIdToUse = 0
            if self:getIsActiveForWipers() then
              --  if spec.lastRainScale > 0 then
				if self.spec_ManualWipers ~= nil then
					if self.spec_ManualWipers.ButtonHit ~= 0 then
						for stateIndex,state in ipairs(wiper.states) do
						   -- if spec.lastRainScale <= state.maxRainValue then
								stateIdToUse = stateIndex
								break
						   -- end
						end
					end
				elseif spec.lastRainScale > 0 then
					for stateIndex,state in ipairs(wiper.states) do
						if spec.lastRainScale <= state.maxRainValue then
							stateIdToUse = stateIndex
							break
						end
					end
				end
            end

            if Wipers.forcedState ~= -1 then
                stateIdToUse = MathUtil.clamp(Wipers.forcedState, 0, #wiper.states)
            end
            if stateIdToUse > 0 then
                local currentState = wiper.states[stateIdToUse]

                if self:getAnimationTime(wiper.animName) == 1 then
                    self:playAnimation(wiper.animName, -currentState.animSpeed, 1, true)
                end

				if self.spec_ManualWipers.ButtonHit == 1 then
					currentState.animPause = 2000
				elseif self.spec_ManualWipers.ButtonHit == 2 then
					currentState.animPause = 600
				elseif self.spec_ManualWipers.ButtonHit == 3 then
					currentState.animPause = 1
				end

                if wiper.nextStartTime == nil or wiper.nextStartTime < g_currentMission.time then
                    if not self:getIsAnimationPlaying(wiper.animName) then
						if currentState.animPause > 0 then
						end
                        self:playAnimation(wiper.animName, currentState.animSpeed, 0, true)
                        wiper.nextStartTime = nil
                    end
                end
                if wiper.nextStartTime == nil then
                    wiper.nextStartTime = g_currentMission.time + (wiper.animDuration / currentState.animSpeed) * 2 + currentState.animPause
                end
            end
        end
    end
end
Wipers.onUpdateTick = Utils.overwrittenFunction(Wipers.onUpdateTick, ManualWipers.onUpdateTick)

function ManualWipers.SyncClientServer(vehicle, ButtonHit)
	local spec = vehicle.spec_ManualWipers
	
	spec.ButtonHit = ButtonHit
end