-- This Scripts checks if there are incompatible bales loaded with MaizePlus and displays a warning message.
-- It also checks if all heightTypes are registered or displays a error message
-- by [F/A] braeven
-- Version 0.9
-- Date: 02.05.2024

testHeightTypesAndBales = {}

function testHeightTypesAndBales.test()
	--Testen ob Grass zu Grass_fermented wird für alle Ballen
	local grassFillTypeId = g_fillTypeManager:getFillTypeIndexByName("GRASS_WINDROW")
	local modsDirLen = string.len(g_modsDirectory)
	local wrongFermenting = false
	local wrongFermentingMods = {}
	local rightFermentingMods = {}
	--Mods für die wir die Ballen mitbringen hinterlegen
	rightFermentingMods["FS22_KroneBigPack1270VC"] = true
	rightFermentingMods["FS22_Hesston4900Baler"] = true
	rightFermentingMods["FS22_NHD800_D1000"] = true
	rightFermentingMods["FS22_NHD800_D1000_crossplay"] = true

	--Durch alle registrierten Ballen durchgehen
	for _, baleType in ipairs(g_baleManager.bales) do
		if baleType.isAvailable then
			for _, baleFillType in ipairs(baleType.fillTypes) do
				if baleFillType.fillTypeIndex == grassFillTypeId then
					--XML Laden um Fermenting-FillType auslesen zu können, leider keine andere Möglichkeit
					local xmlFile = XMLFile.load("roundbale", baleType.xmlFilename, g_baleManager.baleXMLSchema)
					xmlFile:iterate("bale.fillTypes.fillType", function (_, key)
						local fillTypeName = xmlFile:getValue(key .. "#name")
						local supportsWrapping = xmlFile:getBool(key .. "#supportsWrapping")
						if fillTypeName:upper() == "GRASS_WINDROW" and supportsWrapping == true then
							local fermentingFillTypeName = xmlFile:getValue(key .. ".fermenting#outputFillType")
							--Wenn Grass_Fermented nicht der Output ist, gibt es mit M+ Probleme
							if fermentingFillTypeName ~= nil and fermentingFillTypeName:upper() ~= "GRASS_FERMENTED" and baleType.customEnvironment~=nil then
								wrongFermenting = true
								wrongFermentingMods[baleType.customEnvironment] = true
							--False Positive ausschließen
							elseif fermentingFillTypeName ~= nil and fermentingFillTypeName:upper() == "GRASS_FERMENTED" then
								if baleType.customEnvironment~=nil then
									rightFermentingMods[baleType.customEnvironment] = true
								else
									local snippedPath = baleType.xmlFilename:sub(modsDirLen+1, -1)
									local snippeds = string.split(snippedPath, "/")
									rightFermentingMods[snippeds[1]] = true
								end
							end
						end
					end)
					xmlFile:delete()
				end
			end
		end
	end

	if wrongFermenting == true then
		local mods = ""
		local foundOne = false
		for modName, _ in pairs(wrongFermentingMods) do
			if rightFermentingMods[modName] == nil then
				mods = mods..modName.." "
				foundOne = true
			end
		end

		if foundOne == true then
			local title = "Maize Plus: Incompatible BaleTypes detected"
			local text = "Maize Plus detected mods, that added bales with wrong fermenting outputs. MaizePlus might not work correctly.\n Detected mods: "..mods

			g_gui:showYesNoDialog({
				title = title,
				text = text,
				callback = testHeightTypesAndBales.callBack,
				yesText = g_i18n:getText("button_continue"),
				noText = g_i18n:getText("button_continue"),
				target = self
			})
		end
	end

	--Testen ob HeightTypes angemeldet werden konnten.
	local test = g_densityMapHeightManager:getDensityMapHeightTypeByFillTypeName("SEMIDRYGRASS_WINDROW")
	if test == nil then
		local title = "Maize Plus: To many HeightTypes"
		local text = "Maize Plus could not register its HeightTypes, some features might be broken. Please remove other mods with HeightTypes or raise the amount of usuable HeightTypes."
		g_gui:showYesNoDialog({
			title = title,
			text = text,
			callback = testHeightTypesAndBales.callBack,
			yesText = g_i18n:getText("button_continue"),
			noText = g_i18n:getText("button_continue"),
			target = self
		})
	end
end

function testHeightTypesAndBales.callBack()
--Do nothing
end

MPLoadingScreen.onReadyToStart = Utils.appendedFunction(MPLoadingScreen.onReadyToStart, testHeightTypesAndBales.test)