-- Ability to switch between different converters in tedders, realizing multiple tedding stages 
-- by modelleicher (Farming Agency)

tedderConverterSwitcher = {}

-- append to eventListener to add onRegisterActionEvents to Tedder
function tedderConverterSwitcher.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", Tedder)
end
Tedder.registerEventListeners = Utils.appendedFunction(Tedder.registerEventListeners, tedderConverterSwitcher.registerEventListeners)

-- onRegister actionEvent for Tedder
function Tedder.onRegisterActionEvents(self, isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        local spec = self.spec_tedder

        self:clearActionEventsTable(spec.actionEvents)  

        if isActiveForInputIgnoreSelection then
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.IMPLEMENT_EXTRA3 , self, Tedder.switchConverter, false, true, false, true, nil)
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
            
            g_inputBinding:setActionEventText(actionEventId, g_i18n:getText("action_tedderSwitchConverter")..": "..g_i18n:getText("tedderConverter_"..spec.currentConverter))
        end
    end
end

function tedderConverterSwitcher.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "switchConverter", Tedder.switchConverter)
end
Tedder.registerFunctions = Utils.appendedFunction(Tedder.registerFunctions, tedderConverterSwitcher.registerFunctions)


-- append to Tedder onLoad 
function tedderConverterSwitcher.onLoad(self, superFunc, savegame)
    local returnValue = superFunc(self, savegame)
    
    local spec = self.spec_tedder

    -- list of converters for this tedder, change here if this changes
    spec.converterList = {"TEDDER", "TEDDER_STEP1", "TEDDER_STEP2", "TEDDER_STEP3"} 
    -- current index 
    spec.converterIndex = 1
    -- current converter
    spec.currentConverter = spec.converterList[spec.converterIndex] 

    return returnValue
end
Tedder.onLoad = Utils.overwrittenFunction(Tedder.onLoad, tedderConverterSwitcher.onLoad)


function Tedder.switchConverter(self, actionName, inputValue, callbackState, isAnalog, value, value2, value3, noEventSend, forceIndex)

    local spec = self.spec_tedder

    -- if forceIndex (from event) isn't nil set converter to that
    if forceIndex ~= nil then
        spec.currentConverter = spec.converterList[forceIndex]
    else
        -- otherwise go through list and take next, begin at 1 if at max
        for index, name in pairs(spec.converterList) do
            if name == spec.currentConverter then
                if index == #spec.converterList then
                    index = 1
                else
                    index = index +1
                end
                spec.currentConverter = spec.converterList[index]
                spec.converterIndex = index
                break
            end
        end
    end

    -- call event
    tedderConverterSwitcherEvent.sendEvent(self, spec.converterIndex, noEventSend)

    -- reset converter
	spec.fillTypeConverters = {}
	spec.fillTypeConvertersReverse = {}

    -- add new converter
    local converterData = g_fillTypeManager:getConverterDataByName(spec.currentConverter)
    if converterData ~= nil then
        for from, to in pairs(converterData) do
            spec.fillTypeConverters[from] = to

            if spec.fillTypeConvertersReverse[to.targetFillTypeIndex] == nil then
                spec.fillTypeConvertersReverse[to.targetFillTypeIndex] = {}
            end

            table.insert(spec.fillTypeConvertersReverse[to.targetFillTypeIndex], from)
        end
    end
	
	if spec.actionEvents ~= nil and spec.actionEvents[InputAction.IMPLEMENT_EXTRA3] ~= nil then
		g_inputBinding:setActionEventText(spec.actionEvents[InputAction.IMPLEMENT_EXTRA3].actionEventId, g_i18n:getText("action_tedderSwitchConverter")..": "..g_i18n:getText("tedderConverter_"..spec.currentConverter))
	end

end

-- onReadStream appendet to Tedder to synch converterIndex upon joining MP game
function tedderConverterSwitcher.onReadStream(self, streamId, connection)
    local converterIndex = streamReadInt8(streamId)
    if converterIndex ~= nil and self.switchConverter ~= nil then
        self:switchConverter(nil, nil, nil, nil, nil, nil, nil, true, converterIndex)
    end
end
Tedder.onReadStream = Utils.appendedFunction(Tedder.onReadStream, tedderConverterSwitcher.onReadStream)

-- onWriteStream appended to Tedder to synch converterIndex upon joining MP game
function tedderConverterSwitcher.onWriteStream(self, streamId, connection)
	local spec = self.spec_tedder
	streamWriteInt8(streamId, spec.converterIndex)
end
Tedder.onWriteStream = Utils.appendedFunction(Tedder.onWriteStream, tedderConverterSwitcher.onWriteStream)


-- ConverterSwitch Event called when Input is called
tedderConverterSwitcherEvent = {}
local tedderConverterSwitcherEvent_mt = Class(tedderConverterSwitcherEvent, Event)

InitEventClass(tedderConverterSwitcherEvent, "tedderConverterSwitcherEvent")

function tedderConverterSwitcherEvent.emptyNew()
	local self = Event.new(tedderConverterSwitcherEvent_mt)
    self.className = "tedderConverterSwitcherEvent";
	return self
end

function tedderConverterSwitcherEvent.new(vehicle, converterIndex)
	local self = tedderConverterSwitcherEvent.emptyNew()
	self.vehicle = vehicle
	self.converterIndex = converterIndex

	return self
end

function tedderConverterSwitcherEvent:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.converterIndex = streamReadInt8(streamId)

	self:run(connection)
end

function tedderConverterSwitcherEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteInt8(streamId, self.converterIndex)
end

function tedderConverterSwitcherEvent:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
        self.vehicle:switchConverter(nil, nil, nil, nil, nil, nil, nil, true, self.converterIndex)
	end

	if not connection:getIsServer() then
		g_server:broadcastEvent(tedderConverterSwitcherEvent.new(self.vehicle, self.converterIndex), nil, connection, self.vehicle)
	end
end

function tedderConverterSwitcherEvent.sendEvent(vehicle, converterIndex, noEventSend)
	if (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(tedderConverterSwitcherEvent.new(vehicle, converterIndex), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(tedderConverterSwitcherEvent.new(vehicle, converterIndex))
		end
	end
end


