-- add additional fillTypes to straw blowers so all major bales can be dissolved 
-- by modelleicher (Farming Agency)

strawBlowerExtension = {}


function strawBlowerExtension.onLoad(self, superFunc, ...)
	local returnValue = superFunc(self, ...)
	
	local fillUnit = self:getFillUnitByIndex(self.spec_strawBlower.fillUnitIndex)
	
	-- list of current M+ bale fillTypes 
	local names = {"dryGrass_windrow", "dryClover_windrow", "dryAlfalfa_windrow", "dryHorseGrass_windrow", "grass_fermented", "clover_fermented", "alfalfa_fermented", "horseGrass_fermented", "choppedMaize_fermented", "silage" }
	
	for _, name in pairs(names) do
		if g_fillTypeManager:getFillTypeIndexByName(name) ~= nil then
			fillUnit.supportedFillTypes[g_fillTypeManager:getFillTypeIndexByName(name)] = true
		end;
	end;
	
	return returnValue
end;
StrawBlower.onLoad = Utils.overwrittenFunction(StrawBlower.onLoad, strawBlowerExtension.onLoad)
	