--[[
Adds M+ Bales to Stationary Balers
by: [F/A]Braeven
date: 01.04.2023
Version 1.3

Changelog
Version 1.0 - Initial Release
Version 1.1 - Added Support for Silage Additives for BALERSTATIONARY
Version 1.2 - Added Custom Wrap Colors for all BALERS
Version 1.3 - Added Support for Silage Additive for all Balers, Forage Harvesters and ForageWagons
Version 1.4 - Added Support for Alfalfa/Clover/Premium DLC Fruittypes depending if they are present on a map
]]

maizePlusBalers = {}
maizePlusBalers.test = false
maizePlusBalers.overWriteBalesBalerStationary = "STRAW GRASS_WINDROW WETGRASS_WINDROW SEMIDRYGRASS_WINDROW DRYGRASS_WINDROW CHAFF CROP_WINDROW CHOPPEDMAIZE SUGARBEET_CUT FORAGE FORAGE2 FORAGE3 FORAGE4 FORAGE5 BEETPULP CCMRAW"
maizePlusBalers.overWriteAdditiveBalerStationary = "GRASS_WINDROW WETGRASS_WINDROW SEMIDRYGRASS_WINDROW CHAFF CROP_WINDROW CHOPPEDMAIZE BEETPULP CCMRAW"
maizePlusBalers.overWriteAdditiveBaler = "GRASS_WINDROW WETGRASS_WINDROW SEMIDRYGRASS_WINDROW CROP_WINDROW CHOPPEDMAIZE"
maizePlusBalers.overWriteAdditiveForageWagon = "GRASS_WINDROW WETGRASS_WINDROW SEMIDRYGRASS_WINDROW CROP_WINDROW"
maizePlusBalers.overWriteAdditiveForageHarvesters = "GRASS_WINDROW WETGRASS_WINDROW SEMIDRYGRASS_WINDROW DRYGRASS_WINDROW CHAFF CROP_WINDROW CHOPPEDMAIZE CCMRAW"

maizePlusBalers.additionalWrappingColors = "SHARED_YELLOW1 DEUTZ_GREEN5 SHARED_SILVER SHARED_GREY SHARED_GREYLIGHT SHARED_GREYDARK SHARED_BLACKONYX SHARED_BLACKJET"
maizePlusBalers.additionalWrappingColorNames = "$l10n_ui_colorYellow $l10n_ui_colorGreenLight $l10n_ui_colorSilver $l10n_ui_colorGreyLight $l10n_ui_colorGrey $l10n_ui_colorGreyDark $l10n_ui_colorBlackOnyx $l10n_ui_colorBlackJet"

function maizePlusBalers.testFillTypes()
	maizePlusBalers.test = true
	local testAlfalfa = g_fillTypeManager:getFillTypeIndexByName("ALFALFA_WINDROW")
	if testAlfalfa ~= nil then
		maizePlusBalers.overWriteBalesBalerStationary = maizePlusBalers.overWriteBalesBalerStationary .. " ALFALFA_WINDROW"
		maizePlusBalers.overWriteAdditiveBalerStationary = maizePlusBalers.overWriteAdditiveBalerStationary .. " ALFALFA_WINDROW"
		maizePlusBalers.overWriteAdditiveBaler = maizePlusBalers.overWriteAdditiveBaler .. " ALFALFA_WINDROW"
		maizePlusBalers.overWriteAdditiveForageWagon = maizePlusBalers.overWriteAdditiveForageWagon .. " ALFALFA_WINDROW"
		maizePlusBalers.overWriteAdditiveForageHarvesters = maizePlusBalers.overWriteAdditiveForageHarvesters .. " ALFALFA_WINDROW"
	end
	local testClover = g_fillTypeManager:getFillTypeIndexByName("CLOVER_WINDROW")
	if testClover ~= nil then
		maizePlusBalers.overWriteBalesBalerStationary = maizePlusBalers.overWriteBalesBalerStationary .. " CLOVER_WINDROW"
		maizePlusBalers.overWriteAdditiveBalerStationary = maizePlusBalers.overWriteAdditiveBalerStationary .. " CLOVER_WINDROW"
		maizePlusBalers.overWriteAdditiveBaler = maizePlusBalers.overWriteAdditiveBaler .. " CLOVER_WINDROW"
		maizePlusBalers.overWriteAdditiveForageWagon = maizePlusBalers.overWriteAdditiveForageWagon .. " CLOVER_WINDROW"
		maizePlusBalers.overWriteAdditiveForageHarvesters = maizePlusBalers.overWriteAdditiveForageHarvesters .. " CLOVER_WINDROW"
	end
end

function maizePlusBalers.loadFillUnitFromXML(self, superFunc, xmlFile, key, entry, index)
	local test = string.upper(xmlFile:getValue("vehicle#type", ""))
	if test == "BALERSTATIONARY" then
		if maizePlusBalers.test == false then
			maizePlusBalers.testFillTypes()
		end
		local fillTypeNames = xmlFile:getValue(key .. "#fillTypes")
		if fillTypeNames ~= nil then
			--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
			if string.upper(fillTypeNames) == "STRAW DRYGRASS_WINDROW GRASS_WINDROW CHAFF SUGARBEET_CUT FORAGE" then
				xmlFile:setValue(key .. "#fillTypes", maizePlusBalers.overWriteBalesBalerStationary)
			end
		end
	end

	local returnValue = superFunc(self, xmlFile, key, entry, index)

	return returnValue
end

FillUnit.loadFillUnitFromXML = Utils.overwrittenFunction(FillUnit.loadFillUnitFromXML, maizePlusBalers.loadFillUnitFromXML)



function maizePlusBalers.loadSpecValueFillTypes(xmlFile, superFunc, customEnvironment, baseDir)
	local rootName = xmlFile:getRootName()
	local test = string.upper(xmlFile:getValue("vehicle#type", ""))
	if test ~= nil then
		test = string.upper(test)
		if test == "BALERSTATIONARY" then
			if maizePlusBalers.test == false then
				maizePlusBalers.testFillTypes()
			end
			local i = 0

			while true do
				local key = string.format(rootName .. ".fillUnit.fillUnitConfigurations.fillUnitConfiguration(%d)", i)
				if not xmlFile:hasProperty(key) then
					break
				end

				local j = 0

				while true do
					local unitKey = string.format(key .. ".fillUnits.fillUnit(%d)", j)
					if not xmlFile:hasProperty(unitKey) then
						break
					end

					local showInShop = xmlFile:getValue(unitKey .. "#showInShop")
					local capacity = xmlFile:getValue(unitKey .. "#capacity")

					if (showInShop == nil or showInShop) and (capacity == nil or capacity > 0) then
						local currentFillTypes = xmlFile:getValue(unitKey .. "#fillTypes")
						if currentFillTypes ~= nil then
							--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
							if string.upper(currentFillTypes) == "STRAW DRYGRASS_WINDROW GRASS_WINDROW CHAFF SUGARBEET_CUT FORAGE" then
								xmlFile:setValue(unitKey .. "#fillTypes", maizePlusBalers.overWriteBalesBalerStationary)
							end
						end
					end

					j = j + 1
				end

				i = i + 1
			end
		end
	end

	return superFunc(xmlFile, customEnvironment, baseDir)
end

FillUnit.loadSpecValueFillTypes = Utils.overwrittenFunction(FillUnit.loadSpecValueFillTypes, maizePlusBalers.loadSpecValueFillTypes)



function maizePlusBalers.onLoadBaler(self, superFunc, savegame)
	local rootName = self.xmlFile:getRootName()
	local test = string.upper(self.xmlFile:getValue("vehicle#type", ""))
	if test ~= nil then
		test = string.upper(test)
		if test == "BALERSTATIONARY" then
			if maizePlusBalers.test == false then
				maizePlusBalers.testFillTypes()
			end
			local currentFillTypes = self.xmlFile:getValue("vehicle.baler.additives#fillTypes")
			if currentFillTypes ~= nil then
				--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
				if string.upper(currentFillTypes) == "GRASS_WINDROW CHAFF" then
					self.xmlFile:setValue("vehicle.baler.additives#fillTypes", maizePlusBalers.overWriteAdditiveBalerStationary)
				end
			end
		elseif test == "BALERWRAPPEREXTENDED" or test == "BALER" or test == "BALERWRAPPER" then
			if maizePlusBalers.test == false then
				maizePlusBalers.testFillTypes()
			end
			if self.xmlFile:hasProperty("vehicle.baler.additives") then
				local currentFillTypes = self.xmlFile:getValue("vehicle.baler.additives#fillTypes")
				if currentFillTypes ~= nil then
					--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
					if string.upper(currentFillTypes) == "GRASS_WINDROW" then
						self.xmlFile:setValue("vehicle.baler.additives#fillTypes", maizePlusBalers.overWriteAdditiveBaler)
					end
				end
			end
		end
	end

	return superFunc(self, savegame)
end

Baler.onLoad = Utils.overwrittenFunction(Baler.onLoad, maizePlusBalers.onLoadBaler)



function maizePlusBalers.onLoadForageWagon(self, superFunc, savegame)
	local rootName = self.xmlFile:getRootName()
	local test = string.upper(self.xmlFile:getValue("vehicle#type", ""))
	if test ~= nil then
		if string.upper(test) == "FORAGEWAGON" then
			if maizePlusBalers.test == false then
				maizePlusBalers.testFillTypes()
			end
			if self.xmlFile:hasProperty("vehicle.forageWagon.additives") then
				local currentFillTypes = self.xmlFile:getValue("vehicle.forageWagon.additives#fillTypes")
				if currentFillTypes ~= nil then
					--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
					if string.upper(currentFillTypes) == "GRASS_WINDROW" then
						self.xmlFile:setValue("vehicle.forageWagon.additives#fillTypes", maizePlusBalers.overWriteAdditiveForageWagon)
					end
				end
			end
		end
	end

	return superFunc(self, savegame)
end

ForageWagon.onLoad = Utils.overwrittenFunction(ForageWagon.onLoad, maizePlusBalers.onLoadForageWagon)


function maizePlusBalers.loadCombineSetup(self, superFunc, xmlFile, baseKey, entry)
	local rootName = xmlFile:getRootName()
	local test = string.upper(xmlFile:getValue("vehicle#type", ""))
	if test ~= nil then
		if string.upper(test) == "COMBINEDRIVABLE" then
			if maizePlusBalers.test == false then
				maizePlusBalers.testFillTypes()
			end
			if xmlFile:hasProperty("vehicle.combine.additives") then
				local currentFillTypes = xmlFile:getValue("vehicle.combine.additives#fillTypes")
				if currentFillTypes ~= nil then
					--Nur Überschreiben, wenn die richtigen FillTypes vorher drin waren
					if string.upper(currentFillTypes) == "CHAFF GRASS_WINDROW" then
						xmlFile:setValue("vehicle.combine.additives#fillTypes", maizePlusBalers.overWriteAdditiveForageHarvesters)
					end
				else
					-- wenn additive keine filltype beinhalten in der XML ist der default Wert "CHAFF GRASS_WINDROW" und das tauschen wir dann auch aus
					self.xmlFile:setValue("vehicle.forageWagon.additives#fillTypes", maizePlusBalers.overWriteAdditiveForageWagon)
				end
			end
		end
	end

	return superFunc(self, xmlFile, baseKey, entry)
end

Combine.loadCombineSetup = Utils.overwrittenFunction(Combine.loadCombineSetup, maizePlusBalers.loadCombineSetup)



function maizePlusBalers.getConfigurationsFromXML(xmlFile, superFunc, key, baseDir, customEnvironment, isMod, storeItem)
	if xmlFile:hasProperty("vehicle.wrappingColorConfigurations") then
		local newWraps = string.split(maizePlusBalers.additionalWrappingColors, " ")
		local newWrapNames = string.split(maizePlusBalers.additionalWrappingColorNames, " ")
	
		local wrapNumber = -1
			xmlFile:iterate("vehicle.wrappingColorConfigurations.wrappingColorConfiguration", function (index, wrappingKey)
			wrapNumber = wrapNumber +1
		end)

		for i = wrapNumber+1, wrapNumber + #newWraps do
				xmlFile:setValue("vehicle.wrappingColorConfigurations.wrappingColorConfiguration("..i..")#color", newWraps[i - wrapNumber])
				xmlFile:setValue("vehicle.wrappingColorConfigurations.wrappingColorConfiguration("..i..")#name", newWrapNames[i - wrapNumber])
				xmlFile:setValue("vehicle.wrappingColorConfigurations.wrappingColorConfiguration("..i..")#price", 100)
		end
	end
	return superFunc(xmlFile, key, baseDir, customEnvironment, isMod, storeItem)
end

StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, maizePlusBalers.getConfigurationsFromXML)