-- This script loads Storeitems, Spezialisations and other Stuff, that normally need to be defined inside the modDesc.xml
-- By: [F/A] Braeven
-- Date: 27.08.2023
-- Version 1.0.0.0
-- Only for use with MaizePlus/TerraLife, permission for other use can one be given through Braeven / Farming Agency

MaizePlusStoreItem = {}
MaizePlusStoreItem.ModDirectory = g_currentModDirectory
MaizePlusStoreItem.ModName = g_currentModName

function MaizePlusStoreItem:AddXmlSchema()
	MaizePlusStoreItem.XmlSchema = XMLSchema.new("MaizePlus")
	local schema = MaizePlusStoreItem.XmlSchema
	schema:register(XMLValueType.STRING, "maizePlus.storeItems.storeItem(?)#xmlFilename", "Filename", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brands.brand(?)#name", "BrandName", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brands.brand(?)#title", "BrandName", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brands.brand(?)#image", "ImageFilename", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brands.brand(?)#imageOffset", "Image offset", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brandColors.color(?)#name", "Name of the Color", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.brandColors.color(?)#value", "Color Value", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.specializations.specialization(?)#name", "Specialization Name", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.specializations.specialization(?)#className", "Specialization Class Name", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.vehicleTypes.type(?)#name", "Vehicle Specialization Name", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.vehicleTypes.type(?)#parent", "Vehicle Specialization Parent Name", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.vehicleTypes.type(?)#className", "Vehicle Specialization Classname", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.vehicleTypes.type(?)#filename", "Vehicle Specialization Filename", nil, false)
	schema:register(XMLValueType.STRING, "maizePlus.vehicleTypes.type(?).specialization#name", "Vehicle Specialization Name", nil, false)
end

function MaizePlusStoreItem:loadStore()
	local xmlFile = XMLFile.load("TempDesc", MaizePlusStoreItem.ModDirectory.."xml/maizePlus_storeItems.xml")
	local mod = g_modManager:getModByName(MaizePlusStoreItem.ModName)
	xmlFile:iterate("maizePlus.storeItems.storeItem", function (_, key)
		local storeItemXMLFilename = xmlFile:getString(key .. "#xmlFilename")

		if storeItemXMLFilename ~= nil then
			g_storeManager:addModStoreItem(storeItemXMLFilename, MaizePlusStoreItem.ModDirectory, MaizePlusStoreItem.ModName, true, false, mod.title)
		end
	end)
	xmlFile:delete()
end

function MaizePlusStoreItem:loadBrands()
	local xmlFile = XMLFile.load("TempDesc", MaizePlusStoreItem.ModDirectory.."xml/maizePlus_storeItems.xml")
	xmlFile:iterate("maizePlus.brands.brand", function (_, key)
		local name = xmlFile:getString(key .. "#name")
		local title = xmlFile:getString(key .. "#title")
		local image = xmlFile:getString(key .. "#image")
		local offset = xmlFile:getFloat(key .. "#imageOffset")

		g_brandManager:addBrand(name, title, image, MaizePlusStoreItem.ModDirectory, true, nil, offset)
	end)
	
	xmlFile:iterate("maizePlus.brandColors.color", function (_, key)
		g_brandColorManager:loadBrandColorFromXML(xmlFile.handle, key)
	end)
	
	xmlFile:delete()
end

function MaizePlusStoreItem:loadSpecializations()
	local modEnv = _G[MaizePlusStoreItem.ModName]
	local xmlFile = XMLFile.load("TempDesc", MaizePlusStoreItem.ModDirectory.."xml/maizePlus_storeItems.xml")
	xmlFile:iterate("maizePlus.specializations.specialization", function (_, key)
		local specName = xmlFile:getString(key .. "#name")
		local className = xmlFile:getString(key .. "#className")
		local filename = xmlFile:getString(key .. "#filename")

		if specName ~= nil and className ~= nil and filename ~= nil then
			filename = MaizePlusStoreItem.ModDirectory .. filename

				modEnv.g_specializationManager:addSpecialization(specName, className, filename, MaizePlusStoreItem.ModName)

		end
	end)
	xmlFile:delete()
end

function MaizePlusStoreItem:loadVehicleSpecializations()
	local xmlFile = XMLFile.load("TempDesc", MaizePlusStoreItem.ModDirectory.."xml/maizePlus_storeItems.xml")
	xmlFile:iterate("maizePlus.vehicleTypes.type", function (_, key)
		g_vehicleTypeManager:loadTypeFromXML(xmlFile.handle, key, true, MaizePlusStoreItem.ModDirectory, MaizePlusStoreItem.ModName)
	end)
	xmlFile:delete()
end

MaizePlusStoreItem:AddXmlSchema()
MaizePlusStoreItem:loadBrands()
MaizePlusStoreItem:loadStore()
MaizePlusStoreItem:loadSpecializations()
MaizePlusStoreItem:loadVehicleSpecializations()