-- This script prevents loading Maize Plus if a TerraLife Map was detected to prevent Bugs, wrong items and other stuff.
-- By: [F/A] Braeven
-- Date: 18.09.2023
-- Version 1.1.0.0
-- Only for use with MaizePlus/TerraLife, permission for other use can one be given through Braeven / Farming Agency


testTerraLife = {}

function testTerraLife:AddXmlSchema()
	testTerraLife.XmlSchema = XMLSchema.new("terraLife")
	local schema = testTerraLife.XmlSchema
	schema:register(XMLValueType.STRING, "map.terraLife#version", "Required TerraLife Version", nil, nil)
end

function testTerraLife:test()
	local mapDirectory = g_mpLoadingScreen.missionInfo.map.baseDirectory
	if mapDirectory == "" then
		--wenn mapDirectory leer ist, handelt es sich um die Basemaps
		return false
	elseif fileExists(mapDirectory .. "dlcDesc.xml") then
		--wenn dlcDesc existiert, handelt es sich um DLC-Map
		return false
	else
		local path = mapDirectory .. "modDesc.xml"
		local xmlFile = XMLFile.load("TempDesc", path)
		if xmlFile:hasProperty("moddesc.terraLife") then
			return true
		else
			return false
		end
		xmlFile:delete()
	end
end

testTerraLife:AddXmlSchema()

if testTerraLife:test() == false then
	source(g_currentModDirectory .. "scr/loadFillTypes.lua")
	source(g_currentModDirectory .. "scr/loadHeightTypes.lua")
	source(g_currentModDirectory .. "scr/bunkerSiloChanges.lua")
	source(g_currentModDirectory .. "scr/loadAnimalFood.lua")
	source(g_currentModDirectory .. "scr/animalDataOverride.lua")
	source(g_currentModDirectory .. "scr/converterOverride.lua")
	source(g_currentModDirectory .. "scr/loadMotionPathEffects.lua")
	source(g_currentModDirectory .. "scr/tedderConverterSwitcher.lua")
	source(g_currentModDirectory .. "scr/mowerConverterSwitcher.lua")
	source(g_currentModDirectory .. "scr/loadBales.lua")
	source(g_currentModDirectory .. "scr/l10n_localToGlobal.lua")
	source(g_currentModDirectory .. "scr/strawBlowerExtension.lua")
	source(g_currentModDirectory .. "scr/mixerWagonUniversalDisplay.lua")
	source(g_currentModDirectory .. "scr/registerMaizePlusSpecs.lua")
	source(g_currentModDirectory .. "scr/addToProductionAndSellingStation.lua")
	source(g_currentModDirectory .. "scr/pickupCutterOverride.lua")
	source(g_currentModDirectory .. "scr/baleMissionGrassFermented.lua")
	source(g_currentModDirectory .. "scr/green_mowing.lua")
	source(g_currentModDirectory .. "scr/levelerFix.lua")
	source(g_currentModDirectory .. "scr/maizePlusBalers.lua")
	source(g_currentModDirectory .. "scr/loadStoreItems.lua")
	source(g_currentModDirectory .. "scr/testHeightTypesAndBales.lua")
	Logging.info("Maize Plus loaded")
else
	Logging.info("Loading Maize Plus was stopped, TerraLife was detected")
end