-- load fillTypes from maizePlus_fillTypes.xml via basegame function

loadFillTypes = {}

local modDirectory = g_currentModDirectory

function loadFillTypes.loadFillTypesFromXML(self, superFunc)

    superFunc(self)

    if fileExists(modDirectory.."xml/maizePlus_fillTypes.xml") then
        local fillTypesXML = loadXMLFile("MaizePlus_fillTypes", modDirectory.."xml/maizePlus_fillTypes.xml")

	    g_fillTypeManager:loadFillTypes(fillTypesXML, modDirectory , false, "FS22_MaizePlus")
		
		
		-- load windrow sqm value specific for M+
		local path = "map.fillTypes.fillType("
		local i = 0
		while true do
			local fillTypeName = getXMLString(fillTypesXML, path..i..")#name")
			if fillTypeName == nil or fillTypeName == "" then
				break
			end
			local windrowLiterPerSqm = getXMLFloat(fillTypesXML, path..i..").maizePlus#windrowLiterPerSqm")
			if windrowLiterPerSqm ~= nil then
				g_fillTypeManager.fillTypes[g_fillTypeManager:getFillTypeIndexByName(fillTypeName)].windrowLiterPerSqm = windrowLiterPerSqm
			end
			i = i+1
		end
		

		path = "map.additionalWindrows.windrow("
		i = 0
		loadFillTypes.additionalWindrows = {}
		while true do
			local fillTypeName = getXMLString(fillTypesXML, path..i..")#name")
			if fillTypeName == nil or fillTypeName == "" then
				break
			end
			local fruitType = getXMLString(fillTypesXML, path..i..")#fruitType")
			
			if loadFillTypes.additionalWindrows[fruitType] == nil then
				loadFillTypes.additionalWindrows[fruitType] = {}
			end

			table.insert(loadFillTypes.additionalWindrows[fruitType], g_fillTypeManager:getFillTypeIndexByName(fillTypeName))
			
			i = i+1
		end		
		
	
				
	    delete(fillTypesXML)
    else
        print("MaizePlus Warning: Can't load '"..tostring(modDirectory.."xml/maizePlus_fillTypes.xml").."' no custom FillTypes for MaizePlus will be loaded!")
    end

 	-- change names of default silage and chaff 
    g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.SILAGE].title = g_i18n:getText("fillType_silageNew")
    g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.CHAFF].title = g_i18n:getText("fillType_chaffNew")  

	-- change name of sugarbeet cut
	g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.SUGARBEET_CUT].title = g_i18n:getText("fillType_sugarbeet_cutNew")  
		
	-- change name of grass_windrow
	g_fillTypeManager.fillTypes[g_fillTypeManager.nameToIndex.GRASS_WINDROW].title = g_i18n:getText("fillType_grass_windrow_new")  
end
FillTypeManager.loadDefaultTypes = Utils.overwrittenFunction(FillTypeManager.loadDefaultTypes, loadFillTypes.loadFillTypesFromXML)

-- adjust getFillTypeLiterPerSqm in FruitTypes to return fillType windrowLiterPerSqm in case we have a windrow that isn't a windrow technically (e.g. has no fruitType)
function loadFillTypes.getFillTypeLiterPerSqm(self, superFunc, fillType, defaultTo)
	
	-- call default first
	local returnValue = superFunc(self, fillType, defaultTo);
	
	-- only check for our value if default returned defaultTo value 
	if returnValue == defaultTo then 
		local fillType = g_fillTypeManager.fillTypes[fillType]
		if fillType.windrowLiterPerSqm ~= nil then
			return fillType.windrowLiterPerSqm
		end
	end
	
	return returnValue
end
FruitTypeManager.getFillTypeLiterPerSqm = Utils.overwrittenFunction(FruitTypeManager.getFillTypeLiterPerSqm, loadFillTypes.getFillTypeLiterPerSqm)


    



