-- load animalFood from maizePlus_animalFood.xml via basegame function
-- by modelleicher (Farming Agency)

loadAnimalFood = {}

local modDirectory = g_currentModDirectory


function loadAnimalFood.loadAnimalFoodFromXML()
	-- default path within M+
	local path = modDirectory.."xml/maizePlus_animalFood.xml"
	
	-- check if FS22_maizePlus_animalFoodAdditions mod is present and loaded 
	local mod = g_modManager:getModByName("FS22_maizePlus_animalFoodAdditions")
	if mod ~= nil and g_modIsLoaded["FS22_maizePlus_animalFoodAdditions"] then
			
		-- check if file exists and adjust path, otherwise warning print
		if fileExists(mod.modDir.."maizePlus_animalFood.xml") then
			path = mod.modDir.."maizePlus_animalFood.xml"
		else
			print("MaizePlus Info: No maizePlus_animalFood.xml in FS22_maizePlus_animalFoodAdditions found. Default MaizePlus animalFood Settings loaded.")
		end
	end;
	
	-- check if FS22_maizePlus_hofBergmann_animalFoodAdditions mod is present and loaded 
	local mod = g_modManager:getModByName("FS22_maizePlus_hofBergmann_animalFoodAdditions")
	if mod ~= nil and g_modIsLoaded["FS22_maizePlus_hofBergmann_animalFoodAdditions"] then
			
		-- check if file exists and adjust path, otherwise warning print
		if fileExists(mod.modDir.."maizePlus_animalFood.xml") then
			path = mod.modDir.."maizePlus_animalFood.xml"
		else
			print("MaizePlus Info: No maizePlus_animalFood.xml in FS22_maizePlus_hofBergmann_animalFoodAdditions found. Default MaizePlus animalFood Settings loaded.")
		end
	end;

	-- load our custom XML or at least try to do so
	local animalFoodXml = XMLFile.load("animalFood", path, AnimalFoodSystem.xmlSchema)	
	if animalFoodXml == nil then
		print("MaizePlus Warning: Can't load maizePlus_animalFood.xml, no custom food data will be loaded! (This only happens if "..tostring(modDirectory.."xml/maizePlus_animalFood.xml").." and XML in FS22_maizePlus_animalFoodAdditions doesn't exist or can't be loaded)")
	else

		-- reset all basegame tables
		g_currentMission.animalFoodSystem.animalFood = {}
		g_currentMission.animalFoodSystem.indexToAnimalFood = {}
		g_currentMission.animalFoodSystem.animalTypeIndexToFood = {}
		g_currentMission.animalFoodSystem.mixtures = {}
		g_currentMission.animalFoodSystem.recipes = {}
		g_currentMission.animalFoodSystem.recipeFillTypeIndexToRecipe = {}
		g_currentMission.animalFoodSystem.animalMixtures = {}
		g_currentMission.animalFoodSystem.mixtureFillTypeIndexToMixture = {}

		-- load all stuff again but ours this time
		g_currentMission.animalFoodSystem:loadAnimalFood(animalFoodXml)
		g_currentMission.animalFoodSystem:loadMixtures(animalFoodXml)
		g_currentMission.animalFoodSystem:loadRecipes(animalFoodXml)

		-- delete xml
		animalFoodXml:delete()

	end
end

FoliageSystem.loadMapData = Utils.appendedFunction(FoliageSystem.loadMapData, loadAnimalFood.loadAnimalFoodFromXML)

-- add disableSelection bool to recipes that shouldn't be selected in the mixerWagonRecipeChanger
function loadAnimalFood.loadRecipe(self, superFunc, recipe, xmlFile, key)

	local returnValues = superFunc(self, recipe, xmlFile, key)

	local disableSelection = getXMLBool(xmlFile.handle, key.."#disableSelection")
	if disableSelection then
		recipe.disableSelection = true;
	end;

	return 	returnValues
end
AnimalFoodSystem.loadRecipe = Utils.overwrittenFunction(AnimalFoodSystem.loadRecipe, loadAnimalFood.loadRecipe)


