-- Leveler fix
-- Stops leveler function with Maize+ silage types

LevelerFix = {}

function LevelerFix:onUpdate(superfunc, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local function isSilage(fillType)
		local silageFound = false
		for index, value in pairs(FillType) do
			--print("index / value: "..tostring(index).." / "..tostring(value))
			if value == fillType then
				local indexStr = tostring(index)
				silageFound = string.lower(indexStr) == "choppedmaize_fermented" or string.lower(indexStr) == "ccm" 
							or string.lower(indexStr) == "grass_fermented" or string.lower(indexStr) == "silage"
							or string.lower(indexStr) == "beetpulp_fermented" or string.lower(indexStr) == "brewersgrain_fermented" 
							or string.lower(indexStr) == "clover_fermented" or string.lower(indexStr) == "alfalfa_fermented"
			end
			if silageFound then break end
		end
		return silageFound
	end
    
    local spec = self.spec_leveler

    if self.isClient then
        local fillType = FillType.UNKNOWN
        local silageFound = false
        for _, levelerNode in pairs(spec.nodes) do
            fillType = self:getFillUnitLastValidFillType(levelerNode.fillUnitIndex)
            silageFound = isSilage(fillType)
            if fillType ~= FillType.UNKNOWN and not silageFound then
                break
            end
        end

        if fillType ~= FillType.UNKNOWN and not silageFound and spec.lastFillLevelMovedPct > 0 then
            g_effectManager:setFillType(spec.effects, fillType)
            g_effectManager:startEffects(spec.effects)


            for _, effect in pairs(spec.effects) do
                if effect:isa(LevelerEffect) or effect:isa(SnowPlowMotionPathEffect) then
                    effect:setFillLevel(spec.lastFillLevelMovedPct)
                    effect:setLastVehicleSpeed(self.movingDirection * self:getLastSpeed())
                end
            end
        else
            g_effectManager:stopEffects(spec.effects)
        end
    end

    if self.isServer then
        for _, levelerNode in pairs(spec.nodes) do
            local x0,y0,z0 = localToWorld(levelerNode.node, -levelerNode.halfWidth, levelerNode.yOffset, levelerNode.maxDropDirOffset)
            local x1,y1,z1 = localToWorld(levelerNode.node,  levelerNode.halfWidth, levelerNode.yOffset, levelerNode.maxDropDirOffset)
            if not spec.ignoreFarmlandState then
                local ownerFarmId = self:getOwnerFarmId()
                if not g_farmlandManager:getCanAccessLandAtWorldPosition(ownerFarmId, x0, z0) or
                   not g_farmlandManager:getCanAccessLandAtWorldPosition(ownerFarmId, x1, z1) then
                    break
                end
            end

            local pickedUpFillLevel = 0
            local fillType = self:getFillUnitFillType(levelerNode.fillUnitIndex)
            local fillLevel = self:getFillUnitFillLevel(levelerNode.fillUnitIndex)
            local silageFound = isSilage(fillType)

            if fillType == FillType.UNKNOWN or fillLevel < g_densityMapHeightManager:getMinValidLiterValue(fillType) + 0.001 then
                local newFillType = DensityMapHeightUtil.getFillTypeAtLine(x0,y0,z0, x1,y1,z1, 0.5*levelerNode.maxDropDirOffset)
                local newSilageFound = isSilage(newFillType)
                if newFillType ~= FillType.UNKNOWN and not newSilageFound and newFillType ~= fillType then
                    if self:getFillUnitSupportsFillType(levelerNode.fillUnitIndex, newFillType) then
                        self:addFillUnitFillLevel(self:getOwnerFarmId(), levelerNode.fillUnitIndex, -math.huge)
                        fillType = newFillType
                    end
                end
            end
            local heightType = g_densityMapHeightManager:getDensityMapHeightTypeByFillTypeIndex(fillType)

            if fillType ~= FillType.UNKNOWN and not silageFound and heightType ~= nil then
                local innerRadius = 0.5
                local outerRadius = 2
                local capacity = self:getFillUnitCapacity(levelerNode.fillUnitIndex)

                -- limit the leveler node Y direction to the world Y (So the node + offset can be higher as the node but cannot dig into the ground when facing downwards)
                local dirY = 0
                if levelerNode.alignToWorldY then
                    local dirX, dirZ
                    dirX, dirY, dirZ = localDirectionToWorld(levelerNode.referenceFrame, 0, 0, 1)
                    I3DUtil.setWorldDirection(levelerNode.node, dirX, math.max(dirY, 0), dirZ, 0, 1, 0)
                end
                --#debug DebugUtil.drawDebugNode(levelerNode.node, "levelerNode", false)

                -- pick up at node
                if self:getIsLevelerPickupNodeActive(levelerNode) then
                    if spec.pickUpDirection == self.movingDirection and self.lastSpeed > 0.0001 then
                        local sx,sy,sz = localToWorld(levelerNode.node, -levelerNode.halfWidth, levelerNode.yOffset, levelerNode.zOffset)
                        local ex,ey,ez = localToWorld(levelerNode.node,  levelerNode.halfWidth, levelerNode.yOffset, levelerNode.zOffset)

                        --#debug DebugUtil.drawDebugLine(sx, sy, sz, ex, ey, ez, 0, 1, 0)

                        if dirY >= 0 then
                            local _, sy2, _ = localToWorld(levelerNode.node, -levelerNode.halfWidth, levelerNode.yOffset, levelerNode.zOffset + innerRadius)
                            local _, ey2, _ = localToWorld(levelerNode.node,  levelerNode.halfWidth, levelerNode.yOffset, levelerNode.zOffset + innerRadius)

                            sy = math.max(sy, sy2)
                            ey = math.max(ey, ey2)
                        end

                        fillLevel = self:getFillUnitFillLevel(levelerNode.fillUnitIndex)
                        local delta = -(capacity-fillLevel)
                        local numHeightLimitChecks = levelerNode.numHeightLimitChecks
                        if numHeightLimitChecks > 0 then
                            local movementY = 0
                            for i=0,numHeightLimitChecks do
                                local t = i/numHeightLimitChecks
                                local xi = sx + (ex-sx)*t
                                local yi = sy + (ey-sy)*t
                                local zi = sz + (ez-sz)*t
                                local hi = DensityMapHeightUtil.getHeightAtWorldPos(xi,yi,zi)
                                movementY = math.max(movementY, hi-0.05 - yi) -- limit to 5cm below surface
                            end
                            if movementY > 0 then
                                sy = sy+movementY
                                ey = ey+movementY
                            end
                        end

                        levelerNode.lastPickUp, levelerNode.lineOffsetPickUp = DensityMapHeightUtil.tipToGroundAroundLine(self, delta, fillType, sx,sy,sz, ex,ey,ez, innerRadius, outerRadius, levelerNode.lineOffsetPickUp, true, nil)

                        --#debug DebugUtil.drawDebugLine(sx, sy, sz, ex, ey, ez, 1, 0, 0, innerRadius)

                        if levelerNode.lastPickUp < 0 then
                            if self.notifiyBunkerSilo ~= nil then
                                self:notifiyBunkerSilo(levelerNode.lastPickUp, fillType, (sx+ex) * 0.5, (sy+ey) * 0.5, (sz+ez) * 0.5)
                            end

                            levelerNode.lastPickUp = levelerNode.lastPickUp + spec.litersToPickup
                            spec.litersToPickup = 0

                            self:addFillUnitFillLevel(self:getOwnerFarmId(), levelerNode.fillUnitIndex, -levelerNode.lastPickUp, fillType, ToolType.UNDEFINED, nil)
                            pickedUpFillLevel = levelerNode.lastPickUp
                        end
                    end
                end

                local lastPickUpPerMS = -pickedUpFillLevel

                spec.lastFillLevelMovedBuffer = spec.lastFillLevelMovedBuffer + lastPickUpPerMS
                spec.lastFillLevelMovedBufferTimer = spec.lastFillLevelMovedBufferTimer + dt
                if spec.lastFillLevelMovedBufferTimer > spec.lastFillLevelMovedBufferTime then
                    spec.lastFillLevelMovedTarget = spec.lastFillLevelMovedBuffer / spec.lastFillLevelMovedBufferTimer

                    spec.lastFillLevelMovedBufferTimer = 0
                    spec.lastFillLevelMovedBuffer = 0
                end

                if self.movingDirection < 0 and self.lastSpeed * 3600 > 0.5 then
                    spec.lastFillLevelMovedBuffer = 0
                end

                -- drop at node
                fillLevel = self:getFillUnitFillLevel(levelerNode.fillUnitIndex)
                if fillLevel > 0 then
                    local f = (fillLevel/capacity)
                    local width = MathUtil.lerp(levelerNode.halfMinDropWidth, levelerNode.halfMaxDropWidth, f)

                    local sx,sy,sz = localToWorld(levelerNode.node, -width, levelerNode.yOffset, levelerNode.zOffset)
                    local ex,ey,ez = localToWorld(levelerNode.node,  width, levelerNode.yOffset, levelerNode.zOffset)

                    local yOffset = -0.15

                    levelerNode.lastDrop1, levelerNode.lineOffsetDrop1 = DensityMapHeightUtil.tipToGroundAroundLine(self, fillLevel, fillType, sx,sy+yOffset,sz, ex,ey+yOffset,ez, innerRadius, outerRadius, levelerNode.lineOffsetDrop1, true, nil)

                    --#debug DebugUtil.drawDebugLine(sx,sy+yOffset,sz, ex,ey+yOffset,ez, 1, 1, 1, innerRadius)

                    if levelerNode.lastDrop1 > 0 then
                        local leftOver = fillLevel - levelerNode.lastDrop1
                        if leftOver <= g_densityMapHeightManager:getMinValidLiterValue(fillType) then
                            levelerNode.lastDrop1 = fillLevel
                            spec.litersToPickup = spec.litersToPickup + leftOver
                        end
                        self:addFillUnitFillLevel(self:getOwnerFarmId(), levelerNode.fillUnitIndex, -levelerNode.lastDrop1, fillType, ToolType.UNDEFINED, nil)
                    end
                end

                -- drop further at front
                fillLevel = self:getFillUnitFillLevel(levelerNode.fillUnitIndex)

                if fillLevel > 0 then
                    local dropOffset = MathUtil.lerp(levelerNode.minDropDirOffset, levelerNode.maxDropDirOffset, spec.lastFillLevelMovedPct)

                    local wx, wy, wz = localToWorld(levelerNode.node, 0, levelerNode.yOffset, 0)
                    local tx, ty, tz = localToWorld(levelerNode.node, 0, levelerNode.yOffset, levelerNode.zOffset + dropOffset)

                    levelerNode.raycastLastFillType = fillType
                    levelerNode.raycastLastRadius = outerRadius
                    levelerNode.raycastHitObject = false
                    local rDirX, rDirY, rDirZ = tx-wx, ty-wy, tz-wz
                    local distance = MathUtil.vector3Length(rDirX, rDirY, rDirZ)
                    rDirX, rDirY, rDirZ = MathUtil.vector3Normalize(rDirX, rDirY, rDirZ)
                    raycastAll(wx, wy, wz, rDirX, rDirY, rDirZ, "onLevelerRaycastCallback", distance, levelerNode, CollisionFlag.STATIC_OBJECTS, false, true)

                    --#debug drawDebugLine(wx, wy, wz, 1, 0, 0, wx+rDirX*distance, wy+rDirY*distance, wz+rDirZ*distance, 0, 1, 0, true)
                end
            else
                spec.lastFillLevelMovedBuffer = 0
                spec.lastFillLevelMovedTarget = 0
            end

            -- call fill level changed callack to inform bunker silo about change
            if pickedUpFillLevel < 0 and fillType ~= FillType.UNKNOWN and fillType ~= FillType.SILAGE and fillType ~= FillType.GRASS_FERMENTED then
                self:notifiyBunkerSilo(pickedUpFillLevel, fillType)
            end

            if levelerNode.allowsSmoothing and (levelerNode.smoothDirection == 0 or self.movingDirection == levelerNode.smoothDirection) then
                local smoothAmount = 0
                if self.lastSpeedReal > 0.0002 then -- start smoothing if driving faster than 0.7km/h
                    smoothAmount = spec.smoothAccumulation + math.max(self.lastMovedDistance * 0.5, 0.0003*dt) -- smooth 1.2m per meter driving or at least 0.3m/s
                    local rounded = DensityMapHeightUtil.getRoundedHeightValue(smoothAmount)
                    spec.smoothAccumulation = smoothAmount - rounded
                else
                    spec.smoothAccumulation = 0
                end

                if smoothAmount > 0 then
                    DensityMapHeightUtil.smoothAroundLine(levelerNode.node, levelerNode.width, levelerNode.smoothGroundRadius, levelerNode.smoothOverlap, smoothAmount)
                end
            end
        end

        local smoothFactor = 0.05
        if spec.lastFillLevelMovedTarget == 0 then
            smoothFactor = 0.2
        end

        spec.lastFillLevelMoved = spec.lastFillLevelMoved * (1-smoothFactor) + spec.lastFillLevelMovedTarget * smoothFactor
        if spec.lastFillLevelMoved < 0.005 then
            spec.lastFillLevelMoved = 0
        end

        local oldPercentage = spec.lastFillLevelMovedPct
        spec.lastFillLevelMovedPct = math.max(math.min(spec.lastFillLevelMoved / spec.maxFillLevelPerMS, 1), 0)

        if spec.lastFillLevelMovedPct ~= oldPercentage then
            self:raiseDirtyFlags(spec.dirtyFlag)
        end

        if spec.forceNode ~= nil then
            if self.movingDirection == spec.forceDir and spec.lastFillLevelMoved > 0 then
                spec.lastForce = -spec.maxForce * spec.lastFillLevelMovedPct
                local dx, dy, dz = localDirectionToWorld(spec.forceDirNode, 0, 0, spec.lastForce)
                local px, py, pz = getCenterOfMass(spec.forceNode)

                addForce(spec.forceNode, dx, dy, dz, px, py, pz, true)
            end
        end
    end
end
Leveler.onUpdate = Utils.overwrittenFunction(Leveler.onUpdate, LevelerFix.onUpdate)