-- converts the local (mod environment) l10n texts to global ones (only for the current modEnvironment)
-- by modelleicher (Farming Agency)

l10n_localToGlobal = {}
l10n_localToGlobal.modName = g_currentModName

-- attach to I18N getText to get "self"
function l10n_localToGlobal.getText(self, superFunc, text, env)

    -- print("l10n_localToGlobal.text: " .. text);
	-- check if available in TL+ mod Environment, so in current mod translation list
	local modEnv = self.modEnvironments[l10n_localToGlobal.modName];
	if modEnv ~= nil and modEnv.texts[text] ~= nil then
		return superFunc(self, text, l10n_localToGlobal.modName);
	end
	
	-- check if available in TL+AFA mod Environment
	local myModKey = l10n_localToGlobal.modName.."_animalFoodAdditions";
	local modEnv = self.modEnvironments[myModKey];
	if modEnv ~= nil and modEnv.texts[text] ~= nil then
		return superFunc(self, text, myModKey);
	end
	
	-- at last use the default method with default parameter
	return superFunc(self, text, env);
end
I18N.getText = Utils.overwrittenFunction(I18N.getText, l10n_localToGlobal.getText)